/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.Tuner;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.FoxHttpsSocket;
import com.tridium.fox.sys.FoxWebSocketAdapter;
import com.tridium.fox.sys.FoxwssHttpSessionListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@NiagaraType
public final class BFoxWebSocketAcceptor
extends BComponent
implements BIService,
BIRestrictedComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxWebSocketAcceptor.class);
    private static final BIcon ICON = BIcon.std((String)"braces.png");
    private final Array<WebSocketInfo> webSockets = new Array(WebSocketInfo.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStopped() throws Exception {
        WebSocketInfo[] webSocketInfoArray = this.webSockets;
        synchronized (this.webSockets) {
            WebSocketInfo[] socketInfos = (WebSocketInfo[])this.webSockets.trim();
            this.webSockets.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (WebSocketInfo info : socketInfos) {
                info.socket.close();
            }
            return;
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BFoxService;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!(parent instanceof BFoxService)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicatesInParent((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        WebSocketInfo[] infos;
        Array<WebSocketInfo> array = this.webSockets;
        synchronized (array) {
            infos = (WebSocketInfo[])this.webSockets.trim();
        }
        out.startTable(true);
        out.trTitle((Object)("Open Connections (" + infos.length + ')'), 6);
        out.w((Object)"<tr>");
        out.th((Object)"URI").th((Object)"Remote Host").th((Object)"Encrypted").th((Object)"Accept").th((Object)"Open").th((Object)"Last Message");
        out.w((Object)"</tr>\n");
        BFacets dateTimeFacets = BFacets.make((String[])new String[]{"showTimeZone", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BBoolean.FALSE, BBoolean.TRUE, BBoolean.TRUE});
        for (int i = 0; i < infos.length; ++i) {
            WebSocketInfo info = infos[i];
            BAbsTime lastMessageTime = BAbsTime.make((long)info.lastMessageTime);
            out.tr((Object)info.socket.getRequestURI(), (Object)info.socket.remoteAddr, (Object)(info.isEncrypted ? "Yes" : "No "), (Object)info.acceptTime.toString((Context)dateTimeFacets), (Object)(info.openTime.isNull() ? " - " : info.openTime.toString((Context)dateTimeFacets)), (Object)(lastMessageTime.isNull() ? " - " : lastMessageTime.toString((Context)dateTimeFacets)));
        }
        out.endTable();
        super.spy(out);
    }

    @WebSocket
    public static final class FoxWebSocket
    implements FoxwssHttpSessionListener.IHttpSessionDestroyListener {
        private final HttpSession httpSession;
        Session session;
        private BFoxService service;
        private BFoxWebSocketAcceptor foxWebSocketAcceptor;
        private WebSocketInfo info;
        private FoxHttpsSocket foxHttpsSocket;
        private FoxSession foxSession;
        private FoxWebSocketAdapter adapter;
        private InputStream inputStream;
        private OutputStream outputStream;
        private String remoteAddr;

        FoxWebSocket(HttpSession httpSession) {
            this.httpSession = httpSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketConnect
        public void onConnect(Session session) {
            this.session = session;
            this.service = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            this.foxWebSocketAcceptor = this.service.getFoxWebsocketAcceptor();
            InetAddress inetAddr = session.getRemoteAddress().getAddress();
            this.remoteAddr = Objects.toString(inetAddr != null ? inetAddr.getHostAddress() : "", "");
            this.info = new WebSocketInfo(this, session.isSecure());
            try {
                this.adapter = new FoxWebSocketAdapter();
                this.adapter.onWebSocketConnect(session);
                this.foxHttpsSocket = AccessController.doPrivileged(() -> FoxHttpsSocket.makeServerSocket(this, inetAddr));
                this.foxSession = Tuner.openServer(this.service.getFoxServer(), this.foxHttpsSocket, "foxwss");
            }
            catch (Exception e) {
                FoxHttpsSocket.LOG.log(Level.FINE, "Failed to open Fox Server connection for WebSocket", e);
                this.close(1011, "Failed to open Fox Server WebSocket", e);
                return;
            }
            if (this.foxWebSocketAcceptor != null) {
                Array array = this.foxWebSocketAcceptor.webSockets;
                synchronized (array) {
                    this.foxWebSocketAcceptor.webSockets.add((Object)this.info);
                }
            }
            this.info.openTime = BAbsTime.now();
            FoxwssHttpSessionListener.addDestroyListener(this);
        }

        @OnWebSocketClose
        public void onClose(Session session, int closeCode, String closeReason) {
            this.close(closeCode, closeReason, null);
        }

        @OnWebSocketMessage
        public void onBinaryMessage(Session session, byte[] buf, int offset, int len) {
            this.info.lastMessageTime = System.currentTimeMillis();
            this.adapter.onWebSocketBinary(buf, offset, len);
        }

        @OnWebSocketMessage
        public void onTextMessage(Session session, String str) {
            this.info.lastMessageTime = System.currentTimeMillis();
            this.adapter.onWebSocketText(str);
        }

        @OnWebSocketError
        public void onError(Session session, Throwable cause) {
            try {
                if (this.adapter != null) {
                    this.adapter.onWebSocketError(cause);
                }
            }
            finally {
                this.adapter = null;
                this.close(1011, "Closed from onError", cause);
            }
        }

        @Override
        public void onHttpSessionDestroyed(HttpSession destroyedSession) {
            if (this.httpSession != null && destroyedSession.getId().equals(this.httpSession.getId())) {
                if (FoxHttpsSocket.LOG.isLoggable(Level.FINE)) {
                    FoxHttpsSocket.LOG.log(Level.FINE, "FoxWebSocket.onHttpSessionDestroyed: " + destroyedSession);
                }
                this.close();
            }
        }

        InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = this.adapter.getInputStream(null);
            }
            return this.inputStream;
        }

        OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = this.adapter.getOutputStream();
            }
            return this.outputStream;
        }

        void close() {
            this.close(1000, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(int statusCode, String reason, Throwable cause) {
            Object tmp;
            FoxwssHttpSessionListener.removeDestroyListener(this);
            if (this.foxWebSocketAcceptor != null) {
                Array array = this.foxWebSocketAcceptor.webSockets;
                synchronized (array) {
                    this.foxWebSocketAcceptor.webSockets.remove((Object)this.info);
                }
            }
            try {
                try {
                    if (this.session != null) {
                        tmp = this.session;
                        this.session = null;
                        tmp.close(statusCode, reason);
                    }
                }
                finally {
                    try {
                        if (this.foxSession != null) {
                            tmp = this.foxSession;
                            this.foxSession = null;
                            ((FoxSession)tmp).close(cause);
                        }
                    }
                    finally {
                        if (this.adapter != null) {
                            tmp = this.adapter;
                            this.adapter = null;
                            ((FoxWebSocketAdapter)((Object)tmp)).onWebSocketClose(statusCode, reason);
                        }
                    }
                }
            }
            finally {
                try {
                    this.closeStreams();
                }
                finally {
                    if (this.foxHttpsSocket != null) {
                        try {
                            tmp = this.foxHttpsSocket;
                            this.foxHttpsSocket = null;
                            ((FoxHttpsSocket)tmp).close();
                        }
                        catch (Exception ex) {
                            FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing FoxHttpsSocket", ex);
                        }
                    }
                }
            }
        }

        private void closeStreams() {
            Closeable tmp;
            if (this.inputStream != null) {
                try {
                    tmp = this.inputStream;
                    this.inputStream = null;
                    ((InputStream)tmp).close();
                }
                catch (IOException e) {
                    FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing FoxWebSocket input stream", e);
                }
            }
            if (this.outputStream != null) {
                try {
                    tmp = this.outputStream;
                    this.outputStream = null;
                    ((OutputStream)tmp).close();
                }
                catch (IOException e) {
                    FoxHttpsSocket.LOG.log(Level.FINE, "Unexpected exception closing FoxWebSocket output stream", e);
                }
            }
        }

        private URI getRequestURI() {
            if (this.session == null) {
                throw new IllegalStateException();
            }
            return this.session.getUpgradeRequest().getRequestURI();
        }
    }

    private static final class WebSocketInfo {
        private final BAbsTime acceptTime = BAbsTime.now();
        private final FoxWebSocket socket;
        private final boolean isEncrypted;
        private BAbsTime openTime = BAbsTime.NULL;
        private long lastMessageTime;

        private WebSocketInfo(FoxWebSocket socket, boolean isEncrypted) {
            this.socket = socket;
            this.isEncrypted = isEncrypted;
        }
    }
}

