/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.CRLConsumer;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ServerCertificateHealth;
import com.tridium.crypto.core.io.TrustAnchorConsumer;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxWebSocketAcceptor;
import com.tridium.fox.sys.BServerConnections;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BISecurityService;
import com.tridium.security.BSecurityInfo;
import com.tridium.security.BServerCertificateHealth;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.engine.NClockTicket;
import com.tridium.sys.license.Brand;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CertAliasCasePropertyValidator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BServerPort;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ServerTlsParameters;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.web.BWebService;
import javax.net.ServerSocketFactory;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="foxPort", type="BServerPort", defaultValue="new BServerPort(1911, IpProtocol.TCP)"), @NiagaraProperty(name="foxEnabled", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsPort", type="BServerPort", defaultValue="new BServerPort(4911, IpProtocol.TCP)"), @NiagaraProperty(name="foxsEnabled", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsOnly", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxOverWebsocketEnabled", type="boolean", defaultValue="true", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="cipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxsCert", type="String", defaultValue="CertUtils.LEGACY_CERT_ALIAS", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)"), @Facet(value="BFacets.make(\"purposeId\", \"SERVER_CERT\")")}, deprecated=true), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="serverCertificateHealth", type="BServerCertificateHealth", defaultValue="new BServerCertificateHealth()", flags=7), @NiagaraProperty(name="requestTimeout", type="BRelTime", defaultValue="BRelTime.make(Fox.requestTimeout)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1))")}), @NiagaraProperty(name="socketOptionTimeout", type="BRelTime", defaultValue="BRelTime.make(Fox.soTimeout)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1))")}), @NiagaraProperty(name="socketTcpNoDelay", type="boolean", defaultValue="true"), @NiagaraProperty(name="keepAliveInterval", type="BRelTime", defaultValue="BRelTime.make(Fox.keepAliveInterval)"), @NiagaraProperty(name="maxServerSessions", type="int", defaultValue="Fox.maxServerSessions"), @NiagaraProperty(name="multicastEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="enableAnnouncement", type="boolean", defaultValue="true"), @NiagaraProperty(name="multicastTimeToLive", type="int", defaultValue="Fox.multicastTimeToLive"), @NiagaraProperty(name="serverConnections", type="BServerConnections", defaultValue="new BServerConnections()"), @NiagaraProperty(name="traceSessionStates", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceReadFrame", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceWriteFrame", type="boolean", defaultValue="false"), @NiagaraProperty(name="traceMulticast", type="boolean", defaultValue="false"), @NiagaraProperty(name="auditStationLoginEvents", type="boolean", defaultValue="false"), @NiagaraProperty(name="supportLegacyClients", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0, GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE)", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:FrozenEnumFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:FrozenEnumEditor\"), BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="foxWebsocketAcceptor", type="BFoxWebSocketAcceptor", defaultValue="new BFoxWebSocketAcceptor()", flags=7)})
@NiagaraActions(value={@NiagaraAction(name="resetAllConnections", flags=128), @NiagaraAction(name="delayStationStarted", flags=4)})
public class BFoxService
extends BComponent
implements BIService,
BIRestrictedComponent,
BISecurityInfoSource,
TrustAnchorConsumer,
BICertificateAliasAndPasswordContainer,
CRLConsumer {
    public static final boolean SUPPORT_LEGACY_CLIENTS_BY_DEFAULT = true;
    private static final BFacets LEXICON_FACET = BFacets.make((String)"lexicon", (String)"fox");
    private static final BEnumRange GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{SlotPath.escape((String)"Use Default On Installed Platform"), SlotPath.escape((String)"No (Recommended)"), SlotPath.escape((String)"Yes")}, (int)3, (BFacets)LEXICON_FACET);
    private static final BEnumRange LOCAL_SUPPORT_LEGACY_CLIENTS_RANGE = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{SlotPath.escape((String)"Default: Yes (may change in future version)"), SlotPath.escape((String)"No (Recommended)"), SlotPath.escape((String)"Yes")}, (int)3, (BFacets)LEXICON_FACET);
    @Generated
    public static final Property foxPort = BFoxService.newProperty((int)0, (BValue)new BServerPort(1911, IpProtocol.TCP), null);
    @Generated
    public static final Property foxEnabled = BFoxService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property foxsPort = BFoxService.newProperty((int)0, (BValue)new BServerPort(4911, IpProtocol.TCP), null);
    @Generated
    public static final Property foxsEnabled = BFoxService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property foxsOnly = BFoxService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property foxsMinProtocol = BFoxService.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property foxOverWebsocketEnabled = BFoxService.newProperty((int)4, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property cipherSuiteGroup = BFoxService.newProperty((int)0, (BValue)BTlsCipherSuiteGroup.recommended, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Deprecated
    @Generated
    public static final Property foxsCert = BFoxService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)), (BFacets)BFacets.make((String)"purposeId", (String)"SERVER_CERT")));
    @Generated
    public static final Property certAliasAndPassword = BFoxService.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property serverCertificateHealth = BFoxService.newProperty((int)7, (BValue)new BServerCertificateHealth(), null);
    @Generated
    public static final Property requestTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.requestTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    @Generated
    public static final Property socketOptionTimeout = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.soTimeout), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    @Generated
    public static final Property socketTcpNoDelay = BFoxService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property keepAliveInterval = BFoxService.newProperty((int)0, (BValue)BRelTime.make((long)Fox.keepAliveInterval), null);
    @Generated
    public static final Property maxServerSessions = BFoxService.newProperty((int)0, (int)Fox.maxServerSessions, null);
    @Generated
    public static final Property multicastEnabled = BFoxService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property enableAnnouncement = BFoxService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property multicastTimeToLive = BFoxService.newProperty((int)0, (int)Fox.multicastTimeToLive, null);
    @Generated
    public static final Property serverConnections = BFoxService.newProperty((int)0, (BValue)new BServerConnections(), null);
    @Generated
    public static final Property traceSessionStates = BFoxService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property traceReadFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property traceWriteFrame = BFoxService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property traceMulticast = BFoxService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property auditStationLoginEvents = BFoxService.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property supportLegacyClients = BFoxService.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)GENERIC_SUPPORT_LEGACY_CLIENTS_RANGE), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:FrozenEnumFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:FrozenEnumEditor"), (String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property foxWebsocketAcceptor = BFoxService.newProperty((int)7, (BValue)new BFoxWebSocketAcceptor(), null);
    @Generated
    public static final Action resetAllConnections = BFoxService.newAction((int)128, null);
    @Generated
    public static final Action delayStationStarted = BFoxService.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private final ServiceListener serviceListener = new ServiceListener(){

        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BISecurityService.TYPE) && event.getId() == 0) {
                ((BISecurityService)event.getService().as(BISecurityService.class)).register((BISecurityInfoSource)BFoxService.this);
            }
        }
    };
    public static final Logger LOG = Logger.getLogger("fox");
    private static final BIcon ICON = BIcon.std((String)"fox.png");
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private final List<FoxServerConnectionListener> serverConnectionListeners = new ArrayList<FoxServerConnectionListener>();
    private Daemon daemon;
    private Clock.Ticket restartTicket;
    private String trustAnchorConsumerId;
    private String crlConsumerId;
    private CertAliasCasePropertyValidator validator = new CertAliasCasePropertyValidator(certAliasAndPassword.getName());

    @Generated
    public BServerPort getFoxPort() {
        return (BServerPort)this.get(foxPort);
    }

    @Generated
    public void setFoxPort(BServerPort v) {
        this.set(foxPort, (BValue)v, null);
    }

    @Generated
    public boolean getFoxEnabled() {
        return this.getBoolean(foxEnabled);
    }

    @Generated
    public void setFoxEnabled(boolean v) {
        this.setBoolean(foxEnabled, v, null);
    }

    @Generated
    public BServerPort getFoxsPort() {
        return (BServerPort)this.get(foxsPort);
    }

    @Generated
    public void setFoxsPort(BServerPort v) {
        this.set(foxsPort, (BValue)v, null);
    }

    @Generated
    public boolean getFoxsEnabled() {
        return this.getBoolean(foxsEnabled);
    }

    @Generated
    public void setFoxsEnabled(boolean v) {
        this.setBoolean(foxsEnabled, v, null);
    }

    @Generated
    public boolean getFoxsOnly() {
        return this.getBoolean(foxsOnly);
    }

    @Generated
    public void setFoxsOnly(boolean v) {
        this.setBoolean(foxsOnly, v, null);
    }

    @Generated
    public BSslTlsEnum getFoxsMinProtocol() {
        return (BSslTlsEnum)this.get(foxsMinProtocol);
    }

    @Generated
    public void setFoxsMinProtocol(BSslTlsEnum v) {
        this.set(foxsMinProtocol, (BValue)v, null);
    }

    @Generated
    public boolean getFoxOverWebsocketEnabled() {
        return this.getBoolean(foxOverWebsocketEnabled);
    }

    @Generated
    public void setFoxOverWebsocketEnabled(boolean v) {
        this.setBoolean(foxOverWebsocketEnabled, v, null);
    }

    @Generated
    public BTlsCipherSuiteGroup getCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(cipherSuiteGroup);
    }

    @Generated
    public void setCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(cipherSuiteGroup, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getFoxsCert() {
        return this.getString(foxsCert);
    }

    @Deprecated
    @Generated
    public void setFoxsCert(String v) {
        this.setString(foxsCert, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BServerCertificateHealth getServerCertificateHealth() {
        return (BServerCertificateHealth)this.get(serverCertificateHealth);
    }

    @Generated
    public void setServerCertificateHealth(BServerCertificateHealth v) {
        this.set(serverCertificateHealth, (BValue)v, null);
    }

    @Generated
    public BRelTime getRequestTimeout() {
        return (BRelTime)this.get(requestTimeout);
    }

    @Generated
    public void setRequestTimeout(BRelTime v) {
        this.set(requestTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getSocketOptionTimeout() {
        return (BRelTime)this.get(socketOptionTimeout);
    }

    @Generated
    public void setSocketOptionTimeout(BRelTime v) {
        this.set(socketOptionTimeout, (BValue)v, null);
    }

    @Generated
    public boolean getSocketTcpNoDelay() {
        return this.getBoolean(socketTcpNoDelay);
    }

    @Generated
    public void setSocketTcpNoDelay(boolean v) {
        this.setBoolean(socketTcpNoDelay, v, null);
    }

    @Generated
    public BRelTime getKeepAliveInterval() {
        return (BRelTime)this.get(keepAliveInterval);
    }

    @Generated
    public void setKeepAliveInterval(BRelTime v) {
        this.set(keepAliveInterval, (BValue)v, null);
    }

    @Generated
    public int getMaxServerSessions() {
        return this.getInt(maxServerSessions);
    }

    @Generated
    public void setMaxServerSessions(int v) {
        this.setInt(maxServerSessions, v, null);
    }

    @Generated
    public boolean getMulticastEnabled() {
        return this.getBoolean(multicastEnabled);
    }

    @Generated
    public void setMulticastEnabled(boolean v) {
        this.setBoolean(multicastEnabled, v, null);
    }

    @Generated
    public boolean getEnableAnnouncement() {
        return this.getBoolean(enableAnnouncement);
    }

    @Generated
    public void setEnableAnnouncement(boolean v) {
        this.setBoolean(enableAnnouncement, v, null);
    }

    @Generated
    public int getMulticastTimeToLive() {
        return this.getInt(multicastTimeToLive);
    }

    @Generated
    public void setMulticastTimeToLive(int v) {
        this.setInt(multicastTimeToLive, v, null);
    }

    @Generated
    public BServerConnections getServerConnections() {
        return (BServerConnections)this.get(serverConnections);
    }

    @Generated
    public void setServerConnections(BServerConnections v) {
        this.set(serverConnections, (BValue)v, null);
    }

    @Generated
    public boolean getTraceSessionStates() {
        return this.getBoolean(traceSessionStates);
    }

    @Generated
    public void setTraceSessionStates(boolean v) {
        this.setBoolean(traceSessionStates, v, null);
    }

    @Generated
    public boolean getTraceReadFrame() {
        return this.getBoolean(traceReadFrame);
    }

    @Generated
    public void setTraceReadFrame(boolean v) {
        this.setBoolean(traceReadFrame, v, null);
    }

    @Generated
    public boolean getTraceWriteFrame() {
        return this.getBoolean(traceWriteFrame);
    }

    @Generated
    public void setTraceWriteFrame(boolean v) {
        this.setBoolean(traceWriteFrame, v, null);
    }

    @Generated
    public boolean getTraceMulticast() {
        return this.getBoolean(traceMulticast);
    }

    @Generated
    public void setTraceMulticast(boolean v) {
        this.setBoolean(traceMulticast, v, null);
    }

    @Generated
    public boolean getAuditStationLoginEvents() {
        return this.getBoolean(auditStationLoginEvents);
    }

    @Generated
    public void setAuditStationLoginEvents(boolean v) {
        this.setBoolean(auditStationLoginEvents, v, null);
    }

    @Generated
    public BDynamicEnum getSupportLegacyClients() {
        return (BDynamicEnum)this.get(supportLegacyClients);
    }

    @Generated
    public void setSupportLegacyClients(BDynamicEnum v) {
        this.set(supportLegacyClients, (BValue)v, null);
    }

    @Generated
    public BFoxWebSocketAcceptor getFoxWebsocketAcceptor() {
        return (BFoxWebSocketAcceptor)this.get(foxWebsocketAcceptor);
    }

    @Generated
    public void setFoxWebsocketAcceptor(BFoxWebSocketAcceptor v) {
        this.set(foxWebsocketAcceptor, (BValue)v, null);
    }

    @Generated
    public void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    @Generated
    public void delayStationStarted() {
        this.invoke(delayStationStarted, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public boolean isServing() {
        Daemon daemon = this.daemon;
        return daemon != null && daemon.isServing();
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (!Flags.has((BComplex)this, (Slot)foxsCert, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getFoxsCert());
            this.getCertAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)foxsCert, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)certAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)certAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)certAliasAndPassword, this.getFlags((Slot)certAliasAndPassword) & 0xFFFFFFFB);
            this.setFlags((Slot)serverCertificateHealth, this.getFlags((Slot)serverCertificateHealth) & 0xFFFFFFFB);
            this.getCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        }
        if (!Flags.isUserDefined1((BComplex)this, (Slot)foxOverWebsocketEnabled)) {
            this.setFlags((Slot)foxOverWebsocketEnabled, this.getFlags((Slot)foxOverWebsocketEnabled) & 0xFFFFFFFB | 0x10000000);
        }
    }

    public void stationStarted() {
        BServerPort tfoxPort = null;
        BServerPort tfoxsPort = null;
        try {
            Optional webService;
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            this.serviceStopped();
            this.initOptions();
            if (this.getFoxEnabled()) {
                tfoxPort = this.getFoxPort();
            }
            if (this.getFoxsEnabled()) {
                tfoxsPort = this.getFoxsPort();
            }
            this.daemon = new Daemon(this, tfoxPort, tfoxsPort);
            this.daemon.run();
            keys.add("foxport");
            if (tfoxPort != null) {
                values.add(String.valueOf(tfoxPort.getPublicServerPort()));
            } else {
                values.add("-1");
            }
            keys.add("foxsport");
            if (tfoxsPort != null) {
                values.add(String.valueOf(tfoxsPort.getPublicServerPort()));
            } else {
                values.add("-1");
            }
            BServerPort foxwssPort = null;
            if (this.getFoxOverWebsocketEnabled() && (webService = Sys.findService((Type)BWebService.TYPE)).isPresent() && ((BWebService)webService.get()).getHttpsEnabled()) {
                foxwssPort = ((BWebService)webService.get()).getHttpsPort();
            }
            keys.add("foxwssport");
            if (foxwssPort != null) {
                values.add(String.valueOf(foxwssPort.getPublicServerPort()));
            } else {
                values.add("-1");
            }
            Nre.getPlatform().reportSummaryFields(keys.toArray(new String[0]), values.toArray(new String[0]));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot start", e);
        }
        Optional securityService = Sys.findService((Type)BISecurityService.TYPE);
        if (securityService.isPresent()) {
            ((BISecurityService)((BIService)securityService.get()).as(BISecurityService.class)).register((BISecurityInfoSource)this);
        } else {
            AccessController.doPrivileged(() -> {
                Nre.getServiceManager().addServiceListener(this.serviceListener);
                return null;
            });
        }
        this.trustAnchorConsumerId = AccessController.doPrivileged(() -> CoreCryptoManager.get().registerTrustAnchorConsumer((TrustAnchorConsumer)this));
        this.crlConsumerId = AccessController.doPrivileged(() -> CoreCryptoManager.get().registerCRLConsumer((CRLConsumer)this));
    }

    public void serviceStarted() {
        try {
            AccessController.doPrivileged(() -> Nre.getServiceManager()).getService("platCrypto:CertManagerService");
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) & 0xFFFFFFFA);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) & 0xFFFFFFFA);
        }
        catch (Exception e) {
            this.setFlags((Slot)foxsPort, this.getFlags((Slot)foxsPort) | 1 | 4);
            this.setFoxsEnabled(false);
            this.setFlags((Slot)foxsEnabled, this.getFlags((Slot)foxsEnabled) | 1 | 4);
            this.setFoxsOnly(false);
            this.setFlags((Slot)foxsOnly, this.getFlags((Slot)foxsOnly) | 1 | 4);
            this.setFlags((Slot)foxsMinProtocol, this.getFlags((Slot)foxsMinProtocol) | 1 | 4);
        }
        finally {
            this.setSupportLegacyClients(BDynamicEnum.make((int)this.getSupportLegacyClients().getOrdinal(), (BEnumRange)LOCAL_SUPPORT_LEGACY_CLIENTS_RANGE));
        }
    }

    public void serviceStopped() {
        if (this.daemon != null) {
            LOG.info("Service stopped");
            this.daemon.stop();
        }
        this.daemon = null;
        Sys.findService((Type)BISecurityService.TYPE).ifPresent(s -> ((BISecurityService)s.as(BISecurityService.class)).unregister((BISecurityInfoSource)this));
        AccessController.doPrivileged(() -> {
            Nre.getServiceManager().removeServiceListener(this.serviceListener);
            return null;
        });
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().unregisterTrustAnchorConsumer(this.trustAnchorConsumerId);
            CoreCryptoManager.get().unregisterCRLConsumer(this.crlConsumerId);
            return null;
        });
    }

    private void initOptions() {
        Fox.appName = "Station";
        Fox.appVersion = String.valueOf(Sys.getBajaVersion());
        Fox.hostName = Sys.getHostName();
        Fox.hostAddress = Sys.getLocalHost(null).getHostAddress();
        Fox.ipv4Enabled = !NreLib.getLocalHost((boolean)false).isLoopbackAddress();
        Fox.ipv6Enabled = Fox.ipv6Enabled && !NreLib.getLocalHost((boolean)true).isLoopbackAddress();
        Fox.requestTimeout = (int)this.getRequestTimeout().getMillis();
        Fox.keepAliveInterval = (int)this.getKeepAliveInterval().getMillis();
        Fox.soTimeout = (int)this.getSocketOptionTimeout().getMillis();
        Fox.tcpNoDelay = this.getSocketTcpNoDelay();
        Fox.multicastEnabled = this.getMulticastEnabled();
        Fox.multicastTimeToLive = this.getMulticastTimeToLive();
        Fox.maxServerSessions = this.getMaxServerSessions();
        Fox.traceSessionStates = this.getTraceSessionStates();
        Fox.traceReadFrame = this.getTraceReadFrame();
        Fox.traceWriteFrame = this.getTraceWriteFrame();
        Fox.traceMulticast = this.getTraceMulticast();
    }

    public static BFoxService waitUntilPortOpen(long timeout) {
        try {
            BFoxService service = (BFoxService)Sys.getService((Type)TYPE);
            long start = Clock.ticks();
            while (!service.isServing()) {
                if (Clock.ticks() - start > timeout) {
                    throw new BajaRuntimeException("BFoxService.waitUntilPortOpen timed out");
                }
                Thread.sleep(100L);
            }
            return service;
        }
        catch (BajaRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("ERROR: BFoxService.waitUntilPortOpen failed");
            e.printStackTrace();
            throw new BajaRuntimeException("FoxService.waitUntilPortOpen", (Throwable)e);
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BSecurityInfo getSecurityInfo() {
        BSecurityInfo info = new BSecurityInfo();
        info.setSourceName(this.getDisplayName(null));
        if (this.isMounted()) {
            info.setHyperlink(this.getSlotPathOrd());
        }
        info.add("alias", (BValue)BString.make((String)this.getCertAliasAndPassword().getAlias()));
        return info;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == serverCertificateHealth) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (prop == foxPort || prop == foxsPort) {
            this.triggerDelayedStationStarted();
        } else if (prop == certAliasAndPassword || prop == foxsMinProtocol || prop == foxsOnly || prop == cipherSuiteGroup) {
            if (this.getFoxsEnabled()) {
                this.triggerDelayedStationStarted();
            }
        } else if (prop == foxEnabled || prop == foxsEnabled || prop == multicastEnabled) {
            this.triggerDelayedStationStarted();
        } else {
            this.initOptions();
        }
    }

    private synchronized void triggerDelayedStationStarted() {
        this.triggerDelayedStationStarted(500L);
    }

    private synchronized void triggerDelayedStationStarted(long waitMillis) {
        if (!this.isRunning()) {
            if (this.restartTicket != null) {
                this.restartTicket.cancel();
                this.restartTicket = null;
            }
            return;
        }
        this.setServerCertificateHealth(new BServerCertificateHealth());
        if (this.restartTicket == null) {
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)waitMillis), (Action)delayStationStarted, null);
        }
        if (this.restartTicket instanceof NClockTicket && waitMillis < ((NClockTicket)this.restartTicket).millisLeft()) {
            this.restartTicket.cancel();
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)waitMillis), (Action)delayStationStarted, null);
        }
    }

    public void doResetAllConnections() {
        new Thread(){

            @Override
            public void run() {
                for (BFoxServerConnection connection : (BFoxServerConnection[])BFoxService.this.getServerConnections().getChildren(BFoxServerConnection.class)) {
                    try {
                        connection.forceDisconnect();
                    }
                    catch (Exception e) {
                        Logger.getLogger("fox").log(Level.WARNING, "Error resetting connections", e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelayStationStarted() {
        BFoxService bFoxService = this;
        synchronized (bFoxService) {
            this.restartTicket = null;
        }
        this.stationStarted();
    }

    public void updateTrustAnchors() {
        this.triggerDelayedStationStarted(120000L);
    }

    public void updateCRLs() {
        this.triggerDelayedStationStarted(120000L);
    }

    public BFoxServerConnection makePersistentServerConnection(String name) {
        BFoxServerConnection conn = (BFoxServerConnection)this.getServerConnections().get(name);
        if (conn != null && conn.isPersistent()) {
            this.getServerConnections().remove(name);
            conn = null;
        }
        if (conn == null) {
            conn = new BFoxServerConnection();
            this.getServerConnections().add(name, (BValue)conn, 3);
        }
        conn.setPersistent(true);
        return conn;
    }

    public BFoxServerConnection makeServerConnection(FoxSession session, FoxMessage remoteHello) throws Exception {
        FoxServerConnectionListener listener2;
        BFoxServerConnection conn = null;
        Iterator<FoxServerConnectionListener> iterator = this.serverConnectionListeners.iterator();
        while (iterator.hasNext() && (conn = (listener2 = iterator.next()).getPersistentConnection(session, remoteHello)) == null) {
        }
        if (conn == null) {
            String stationName = remoteHello.getString("station.name", null);
            if (stationName != null) {
                String serverConnName = "Station_" + stationName;
                BFoxServerConnection existingServerConn = (BFoxServerConnection)this.getServerConnections().get(serverConnName);
                conn = existingServerConn == null || existingServerConn.isPersistent() ? new BFoxServerConnection() : existingServerConn;
            } else {
                conn = new BFoxServerConnection();
            }
        }
        for (FoxServerConnectionListener listener2 : this.serverConnectionListeners) {
            listener2.serverConnectionCreated(conn, session, remoteHello);
        }
        return conn;
    }

    public void registerServerConnectionListener(FoxServerConnectionListener listener) {
        this.serverConnectionListeners.add(listener);
    }

    public void unregisterServerConnectionListener(FoxServerConnectionListener listener) {
        this.serverConnectionListeners.remove(listener);
    }

    public void notifyServerConnectionClosed(BFoxServerConnection connection, Throwable cause) {
        this.serverConnectionListeners.forEach(listener -> {
            try {
                listener.serverConnectionClosed(connection, cause);
            }
            catch (Throwable t) {
                Logger.getLogger("fox").log(Level.SEVERE, "Error notifying connection closed", t);
            }
        });
        if (this.getServerConnections() == connection.getParent() && !connection.isPersistent()) {
            this.getServerConnections().remove(connection.getPropertyInParent());
        }
    }

    public FoxServer getFoxServer() {
        return this.daemon;
    }

    public static NiagaraNetwork getNiagaraNetwork() {
        try {
            return (NiagaraNetwork)Sys.getService((Type)Sys.getType((String)"niagaraDriver:NiagaraNetwork"));
        }
        catch (ServiceNotFoundException snfe) {
            return null;
        }
    }

    public static int getHttpPort() {
        try {
            Type type = Sys.getType((String)"web:WebService");
            BComponent webService = Sys.getService((Type)type);
            BInteger port = (BInteger)webService.get("httpPort");
            return port.getInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean auditConnection(String operation, FoxSession session) {
        String appName = session.getRemoteHello().getString("app.name", "Station");
        if (appName.equals("Station")) {
            switch (operation) {
                case "Login": 
                case "Logout": 
                case "Logout (Timeout)": {
                    BFoxService svc = (BFoxService)Sys.getService((Type)TYPE);
                    return svc.getAuditStationLoginEvents();
                }
            }
            return true;
        }
        return true;
    }

    public final boolean allowLegacyClients() {
        int ordinal = this.getSupportLegacyClients().getOrdinal();
        switch (ordinal) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)certAliasAndPassword) > -1) {
            return this.validator;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (certAliasAndPassword.equals(property)) {
            return this.validator;
        }
        return super.getPropertyValidator(property, context);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public final Property getCertificateAliasAndPasswordProperty(Context context) {
        return certAliasAndPassword;
    }

    public BPassword retrieveCertificatePassword(Property certAliasAndPasswordProperty, Context context) {
        if (!certAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + certAliasAndPassword + '\"');
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        return BPassword.make((String)AccessController.doPrivileged(() -> this.getCertAliasAndPassword().getPassword().getValue()));
    }

    public void certificateSigned(Property certAliasAndPasswordProperty, X509Certificate[] certificateChain, Context context) {
        if (!certAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + certAliasAndPassword + '\"');
        }
        this.changed(certAliasAndPassword, null);
    }

    class Daemon
    extends FoxServer {
        private final BFoxService service;

        public Daemon(BFoxService service, BServerPort foxPort, BServerPort foxsPort) {
            super(foxPort, foxsPort);
            this.service = service;
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public ServerSocket getFoxsServerSocket() throws IOException {
            try {
                return AccessController.doPrivileged(() -> {
                    CoreCryptoManager ccm;
                    ICryptoManager cryptoService;
                    try {
                        cryptoService = (ICryptoManager)Nre.getServiceManager().getService("platCrypto:CertManagerService");
                        ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                    }
                    catch (Exception e) {
                        throw new IOException("unable to get crypto services references", e);
                    }
                    BCertificateAliasAndPassword aliasAndPassword = this.service.getCertAliasAndPassword();
                    try (SecretChars certPasswordChars = null;){
                        ServerCertificateHealth certStatus;
                        String certAlias = null;
                        if (!aliasAndPassword.getPassword().isDefault()) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("using cert password to retrieve certificate " + aliasAndPassword.getAlias());
                            }
                            try {
                                certPasswordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());
                            }
                            catch (Exception e) {
                                LOG.log(Level.SEVERE, "error decoding password for cert", e);
                            }
                            certStatus = ccm.checkServerCertificateStatus(aliasAndPassword.getAlias(), certPasswordChars, LOG);
                            this.service.setServerCertificateHealth(new BServerCertificateHealth(certStatus));
                            certAlias = certStatus.getReturnedCert();
                            if ("default".equals(certAlias)) {
                                certPasswordChars = null;
                            }
                        } else {
                            certStatus = ccm.checkServerCertificateStatus(aliasAndPassword.getAlias(), null, LOG);
                            this.service.setServerCertificateHealth(new BServerCertificateHealth(certStatus));
                            certAlias = certStatus.getReturnedCert();
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("service started with cert " + aliasAndPassword.getAlias());
                        }
                        if ("tridium".equals(certAlias) || "default".equals(certAlias)) {
                            LOG.warning("Using default TLS server certificate '" + certAlias + "' is not recommended. Generate a certificate specifically for this installation and sign it with a proper CA.");
                        }
                        TlsCipherSuiteGroup cipherSuiteGroup = this.service.getCipherSuiteGroup().getCipherSuiteGroup();
                        boolean wantClientAuth = !ccm.getTrustAnchors().isEmpty();
                        ServerTlsParameters tlsParams = new ServerTlsParameters(this.service.getFoxsMinProtocol().getTag(), certAlias, cipherSuiteGroup, wantClientAuth);
                        if (certPasswordChars != null) {
                            tlsParams.setKeyPassphrase(certPasswordChars.get());
                        }
                        if (cipherSuiteGroup != TlsCipherSuiteGroup.recommended) {
                            LOG.warning("not using recommended tls cipher suite group, using " + tlsParams);
                        } else if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("using " + tlsParams);
                        }
                        ServerSocketFactory fact = cryptoService.getServerSocketFactory(tlsParams);
                        if (this.foxsPort.getBindToLoopback()) {
                            ServerSocket serverSocket = fact.createServerSocket(BFoxService.this.getFoxsPort().getBindingPort(), 10, InetAddress.getByName(null));
                            return serverSocket;
                        }
                        ServerSocket serverSocket = fact.createServerSocket(BFoxService.this.getFoxsPort().getBindingPort(), 10);
                        return serverSocket;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }

        @Override
        public FoxConnection makeConnection(FoxSession session, FoxMessage remoteHello) throws Exception {
            return BFoxService.this.makeServerConnection(session, remoteHello);
        }

        @Override
        public void connectionAuthenticated(FoxConnection conn, FoxSession session, FoxMessage remoteHello) throws Exception {
            BFoxServerConnection serverConn;
            if (conn instanceof BFoxServerConnection && (serverConn = (BFoxServerConnection)conn).getParent() == null) {
                String serverConnName;
                String stationName = remoteHello.getString("station.name", null);
                if (stationName != null) {
                    serverConnName = "Station_" + stationName;
                    if (BFoxService.this.getServerConnections().getSlot(serverConnName) != null) {
                        serverConnName = "Session?";
                    }
                } else {
                    serverConnName = "Session?";
                }
                BFoxService.this.getServerConnections().add(serverConnName, (BValue)serverConn, 3);
            }
            for (FoxServerConnectionListener listener : BFoxService.this.serverConnectionListeners) {
                listener.serverConnectionAuthenticated(conn, session, remoteHello);
            }
        }

        @Override
        public FoxMessage getAnnouncement(FoxMessage message) {
            BWebService webService;
            InetAddress announcementAddressV6;
            InetAddress announcementAddressV4;
            if (!BFoxService.this.getEnableAnnouncement()) {
                return null;
            }
            FoxMessage msg = new FoxMessage();
            msg.add("station", Sys.getStation().getStationName());
            if (Fox.ipv4Enabled && !(announcementAddressV4 = NreLib.getLocalHost((boolean)false)).isLoopbackAddress()) {
                msg.add("hostName", announcementAddressV4.getHostName());
                msg.add("hostAddress", announcementAddressV4.getHostAddress());
            }
            if (Fox.ipv6Enabled && !(announcementAddressV6 = NreLib.getLocalHost((boolean)true)).isLoopbackAddress()) {
                msg.add("hostNameIPv6", announcementAddressV6.getHostName());
                msg.add("hostAddressIPv6", announcementAddressV6.getHostAddress());
            }
            if (BFoxService.this.getFoxEnabled()) {
                msg.add("foxPort", BFoxService.this.getFoxPort().getPublicServerPort());
            }
            if (BFoxService.this.getFoxsEnabled()) {
                msg.add("foxsPort", BFoxService.this.getFoxsPort().getPublicServerPort());
            }
            if (BFoxService.this.getFoxOverWebsocketEnabled() && (webService = (BWebService)Sys.findService((Type)BWebService.TYPE).orElse(null)) != null && webService.getHttpsEnabled()) {
                msg.add("foxwssPort", webService.getHttpsPort().getPublicServerPort());
            }
            msg.add("httpPort", BFoxService.getHttpPort());
            msg.add("version", Sys.getBajaVersion().toString());
            msg.add("hostId", Nre.getHostId());
            msg.add("hostModel", Nre.getHostModel());
            msg.add("brandId", Brand.getBrandId());
            msg.add("vmName", Fox.vmName);
            msg.add("vmVersion", Fox.vmVersion);
            msg.add("osName", Fox.osName);
            msg.add("osVersion", Fox.osVersion);
            return msg;
        }

        @Override
        public boolean authenticateBasic(FoxSession session, String username, String password) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateBasic in BFoxService. This call should be handled by an Authentication Agent.");
        }

        @Override
        public boolean authenticateDigest(FoxSession session, String username, byte[] nonce, byte[] digest) throws Exception {
            throw new AuthenticationException("Unsupported method call authenticateDigest in BFoxService. This call should be handled by an Authentication Agent.");
        }
    }

    public static interface FoxServerConnectionListener {
        default public BFoxServerConnection getPersistentConnection(FoxSession session, FoxMessage remoteHello) {
            return null;
        }

        default public void serverConnectionCreated(BFoxServerConnection connection, FoxSession session, FoxMessage remoteHello) {
        }

        default public void serverConnectionClosed(BFoxServerConnection connection, Throwable cause) {
        }

        default public void serverConnectionAuthenticated(FoxConnection conn, FoxSession session, FoxMessage remoteHello) {
        }
    }
}

