/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.LoginFailureCause;
import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.DefaultExemptionApprover;
import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.crypto.core.io.AliasedKeyManagerBuilder;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BFoxwssScheme;
import com.tridium.fox.sys.FoxHttpsSocket;
import com.tridium.fox.sys.FoxWebSocketAdapter;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.sys.Nre;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.nre.security.ExemptionApprover;
import javax.baja.nre.security.ExemptionHandler;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.BUsernameSchemeCredentials;
import javax.baja.security.ReportCauseAuthenticationException;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.tls.TlsFatalAlert;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.WebSocketTimeoutException;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="port", type="int", defaultValue="BFoxScheme.DEFAULT_PORT"), @NiagaraProperty(name="useFoxs", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="foxOverWebsocket", type="BFoxClientWebsocketBehavior", defaultValue="BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails", flags=5), @NiagaraProperty(name="foxOverWebsocketPort", type="int", defaultValue="443", flags=5), @NiagaraProperty(name="foxOverWebsocketPathPrefix", type="String", defaultValue="", flags=4), @NiagaraProperty(name="foxOverWebsocketInUse", type="boolean", defaultValue="false", flags=69), @NiagaraProperty(name="lastFailureTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastFailureCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="retryPeriod", type="BRelTime", defaultValue="BRelTime.make(5*60*1000)"), @NiagaraProperty(name="nextAttemptTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="credentialStore", type="BClientCredentials", defaultValue="new BClientCredentials()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CredentialStoreFE\"))")})})
@NiagaraActions(value={@NiagaraAction(name="manualConnect"), @NiagaraAction(name="manualDisconnect"), @NiagaraAction(name="lingerTimeout", flags=20)})
public class BFoxClientConnection
extends BFoxConnection
implements AuthenticationClient {
    @Generated
    public static final Property port = BFoxClientConnection.newProperty((int)0, (int)1911, null);
    @Generated
    public static final Property useFoxs = BFoxClientConnection.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property foxOverWebsocket = BFoxClientConnection.newProperty((int)5, (BValue)BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails, null);
    @Generated
    public static final Property foxOverWebsocketPort = BFoxClientConnection.newProperty((int)5, (int)443, null);
    @Generated
    public static final Property foxOverWebsocketPathPrefix = BFoxClientConnection.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property foxOverWebsocketInUse = BFoxClientConnection.newProperty((int)69, (boolean)false, null);
    @Generated
    public static final Property lastFailureTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailureCause = BFoxClientConnection.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property retryPeriod = BFoxClientConnection.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    @Generated
    public static final Property nextAttemptTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property credentialStore = BFoxClientConnection.newProperty((int)0, (BValue)new BClientCredentials(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CredentialStoreFE")));
    @Generated
    public static final Action manualConnect = BFoxClientConnection.newAction((int)0, null);
    @Generated
    public static final Action manualDisconnect = BFoxClientConnection.newAction((int)0, null);
    @Generated
    public static final Action lingerTimeout = BFoxClientConnection.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxClientConnection.class);
    public static long engageLinger = 60000L;
    private static final long FOX_WS_HTTP_CONNECTION_TIMEOUT;
    private static final CoalesceQueue queue;
    private static final ThreadPoolWorker threadPool;
    private static final Lexicon LEX;
    private static final ExecutorService FOX_WS_EXECUTOR_SERVICE;
    private static final String CLIENT_CERT_SCHEME_NAME = "clientcert";
    private BFoxSession foxSession;
    private AuthenticationClient authenticationClient = this;
    private String authenticationScheme;
    private BHost remoteHost;
    private final Object connectLock = new Object();
    private long lastFailureTicks;
    private Exception lastFailureException;
    private final Object retryLock = new Object();
    private final Map<Interest, InterestLogItem> interests = new HashMap<Interest, InterestLogItem>(5);
    private final List<InterestLogItem> interestLog = new ArrayList<InterestLogItem>(20);
    private Clock.Ticket lingerTicket;
    private boolean checkBrandCompatibility = true;
    volatile boolean sslHandshakeComplete;
    private SSLSocketFactory socketFactory = null;
    private volatile Runnable exemptionRequest;
    boolean skipFoxwssFallthrough;
    boolean clientCertAuthFailure;
    private volatile boolean foxwssServerCertValidationFailure;

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public boolean getUseFoxs() {
        return this.getBoolean(useFoxs);
    }

    @Generated
    public void setUseFoxs(boolean v) {
        this.setBoolean(useFoxs, v, null);
    }

    @Generated
    public BFoxClientWebsocketBehavior getFoxOverWebsocket() {
        return (BFoxClientWebsocketBehavior)this.get(foxOverWebsocket);
    }

    @Generated
    public void setFoxOverWebsocket(BFoxClientWebsocketBehavior v) {
        this.set(foxOverWebsocket, (BValue)v, null);
    }

    @Generated
    public int getFoxOverWebsocketPort() {
        return this.getInt(foxOverWebsocketPort);
    }

    @Generated
    public void setFoxOverWebsocketPort(int v) {
        this.setInt(foxOverWebsocketPort, v, null);
    }

    @Generated
    public String getFoxOverWebsocketPathPrefix() {
        return this.getString(foxOverWebsocketPathPrefix);
    }

    @Generated
    public void setFoxOverWebsocketPathPrefix(String v) {
        this.setString(foxOverWebsocketPathPrefix, v, null);
    }

    @Generated
    public boolean getFoxOverWebsocketInUse() {
        return this.getBoolean(foxOverWebsocketInUse);
    }

    @Generated
    public void setFoxOverWebsocketInUse(boolean v) {
        this.setBoolean(foxOverWebsocketInUse, v, null);
    }

    @Generated
    public BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    @Generated
    public void setLastFailureTime(BAbsTime v) {
        this.set(lastFailureTime, (BValue)v, null);
    }

    @Generated
    public String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    @Generated
    public void setLastFailureCause(String v) {
        this.setString(lastFailureCause, v, null);
    }

    @Generated
    public BRelTime getRetryPeriod() {
        return (BRelTime)this.get(retryPeriod);
    }

    @Generated
    public void setRetryPeriod(BRelTime v) {
        this.set(retryPeriod, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextAttemptTime() {
        return (BAbsTime)this.get(nextAttemptTime);
    }

    @Generated
    public void setNextAttemptTime(BAbsTime v) {
        this.set(nextAttemptTime, (BValue)v, null);
    }

    @Generated
    public BClientCredentials getCredentialStore() {
        return (BClientCredentials)this.get(credentialStore);
    }

    @Generated
    public void setCredentialStore(BClientCredentials v) {
        this.set(credentialStore, (BValue)v, null);
    }

    @Generated
    public void manualConnect() {
        this.invoke(manualConnect, null, null);
    }

    @Generated
    public void manualDisconnect() {
        this.invoke(manualDisconnect, null, null);
    }

    @Generated
    public void lingerTimeout() {
        this.invoke(lingerTimeout, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxClientConnection(BFoxSession foxSession) {
        this.foxSession = foxSession;
        this.setRemoteHost(foxSession.getHost());
        this.setPort(foxSession.getPort());
        switch (foxSession.getFoxConnectionType()) {
            case FOXS_OR_FOXWSS: {
                this.setUseFoxs(true);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails);
                break;
            }
            case FOX_OR_FOXWSS: {
                this.setUseFoxs(false);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails);
                break;
            }
            case FOXWSS: {
                this.setUseFoxs(true);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketOnly);
                break;
            }
            case FOXS: {
                this.setUseFoxs(true);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.websocketDisabled);
                break;
            }
            default: {
                this.setUseFoxs(false);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.websocketDisabled);
            }
        }
        this.setFoxOverWebsocketPort(foxSession.websocketPort);
        this.init();
    }

    public BFoxClientConnection() {
        this.init();
    }

    private void init() {
        if (Sys.getStation() != null) {
            try {
                AccessController.doPrivileged(() -> Nre.getServiceManager()).getService("platCrypto:CertManagerService");
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
                this.setFlags((Slot)foxOverWebsocket, this.getFlags((Slot)foxOverWebsocket) & 0xFFFFFFFA);
                this.setFlags((Slot)foxOverWebsocketPort, this.getFlags((Slot)foxOverWebsocketPort) & 0xFFFFFFFA);
                this.setFlags((Slot)foxOverWebsocketInUse, this.getFlags((Slot)foxOverWebsocketInUse) & 0xFFFFFFFB);
            }
            catch (Exception e) {
                this.setUseFoxs(false);
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) | 1 | 4);
                this.setFoxOverWebsocket(BFoxClientWebsocketBehavior.websocketDisabled);
                this.setFoxOverWebsocketInUse(false);
                this.setFlags((Slot)foxOverWebsocket, this.getFlags((Slot)foxOverWebsocket) | 1 | 4);
                this.setFlags((Slot)foxOverWebsocketPort, this.getFlags((Slot)foxOverWebsocketPort) | 1 | 4);
                this.setFlags((Slot)foxOverWebsocketInUse, this.getFlags((Slot)foxOverWebsocketInUse) | 4);
            }
        } else {
            this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
        }
        this.set(channels, BFoxChannelRegistry.getPrototype().newCopy());
    }

    public String getUsername() {
        return this.getCredentials().getUsername();
    }

    public final BFoxSession getFoxSession() {
        return this.foxSession;
    }

    public final BHost getRemoteHost() {
        Optional<NiagaraStation> station = this.getConnectionTarget(NiagaraStation.class);
        return station.isPresent() ? station.get().getRemoteHost() : this.remoteHost;
    }

    public void setRemoteHost(BHost remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteHost(BHost remoteHost, int port) {
        this.setRemoteHost(remoteHost);
        this.setPort(port);
    }

    public void setCredentials(BIUserCredentials credentials) {
        this.getCredentialStore().setCredentials(credentials);
    }

    public void setSSLSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.socketFactory;
    }

    public BIUserCredentials getCredentials() {
        return this.getCredentialStore().getCredentials();
    }

    public void setAuthenticationClient(AuthenticationClient client) {
        this.authenticationClient = client;
    }

    public AuthenticationClient getAuthenticationClient() {
        return this.authenticationClient;
    }

    public void setAuthenticationScheme(String scheme) {
        this.authenticationScheme = scheme;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isSslHandshakeComplete() {
        return this.sslHandshakeComplete;
    }

    public int getEffectiveFoxOverWebsocketPort() {
        int websocketPort = this.getFoxOverWebsocketPort();
        if (websocketPort <= 0) {
            return BFoxwssScheme.getPreferredFoxwssPort();
        }
        return websocketPort;
    }

    @Override
    public void sessionOpened(FoxSession session) {
        if (this.checkBrandCompatibility) {
            Acceptor.accept(session);
        }
        super.sessionOpened(session);
        if (this.foxSession != null) {
            this.foxSession.sessionOpened();
        }
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::clientOpened);
    }

    @Override
    public void sessionClosed(FoxSession session, Throwable cause) {
        this.sessionClosed(session, cause, null);
    }

    @Override
    public void sessionClosed(FoxSession session, Throwable cause, LoginFailureCause failureCause) {
        super.sessionClosed(session, cause);
        if (this.foxSession != null) {
            this.foxSession.sessionClosed(failureCause);
        }
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::clientClosed);
    }

    public void connect() throws Exception {
        try {
            AccessController.doPrivileged(new ConnectPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private boolean isClientCertAuthUnrecoverableKeyException(BFoxSession foxSession, BIUserCredentials cred, Exception e) {
        return foxSession != null && cred instanceof BCertificateAliasCredential && e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UnrecoverableKeyException;
    }

    private void listenForHandshake(final SSLSocket socket) {
        HandshakeCompletedListener listener = new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                BFoxClientConnection.this.sslHandshakeComplete = true;
                socket.removeHandshakeCompletedListener(this);
            }
        };
        socket.addHandshakeCompletedListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interest[] getInterests() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return this.interests.keySet().toArray(new Interest[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasInterests() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return !this.interests.isEmpty();
        }
    }

    public InterestLogItem[] getInterestLog() {
        InterestLogItem[] active = this.interests.values().toArray(new InterestLogItem[0]);
        InterestLogItem[] historical = this.interestLog.toArray(new InterestLogItem[0]);
        InterestLogItem[] total = new InterestLogItem[active.length + historical.length];
        System.arraycopy(active, 0, total, 0, active.length);
        System.arraycopy(historical, 0, total, active.length, historical.length);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEngaged(Interest interest) {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return this.interests.get(interest) != null;
        }
    }

    public void engageNoRetry(Interest interest) throws Exception {
        this.engageNoRetry(interest, 5000L);
    }

    public void engageNoRetry(Interest interest, long failFastPeriod) throws Exception {
        this.engageNoRetry(interest, failFastPeriod, false);
    }

    public void engageNoRetry(Interest interest, long failFastPeriod, boolean updateState) throws Exception {
        Exception ex = this.lastFailureException;
        if (ex != null && Clock.ticks() - this.lastFailureTicks < failFastPeriod) {
            throw ex;
        }
        try {
            this.engage(interest, false);
        }
        catch (Exception e) {
            if (updateState) {
                this.transition("Waiting for retry...");
                long retryPeriod = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + retryPeriod)));
            }
            throw e;
        }
    }

    public void engageRetry(Interest interest) throws Exception {
        this.engage(interest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engage(Interest interest, boolean retry) throws Exception {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            if (this.interests.get(interest) == null) {
                InterestLogItem log = this.logEngaged(interest);
                this.interests.put(interest, log);
            }
            if (this.lingerTicket != null) {
                this.lingerTicket.cancel();
            }
        }
        while (true) {
            try {
                this.connect();
                this.interruptRetries();
                return;
            }
            catch (Exception e) {
                if (!retry) {
                    throw e;
                }
                this.transition("Waiting for retry...");
                long retryPeriod = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + retryPeriod)));
                Object object = this.retryLock;
                synchronized (object) {
                    this.retryLock.wait(retryPeriod);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disengage(Interest interest) {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            int oldSize = this.interests.size();
            if (interest != null) {
                InterestLogItem log = this.interests.get(interest);
                if (log != null) {
                    this.logDisengaged(log);
                }
                this.interests.remove(interest);
            }
            if (oldSize > 0 && this.interests.size() == 0) {
                if (this.isRunning()) {
                    this.lingerTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)engageLinger), (Action)lingerTimeout, null);
                } else {
                    this.close();
                }
            }
        }
        this.sslHandshakeComplete = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRetries() {
        if (this.retryLock == null) {
            return;
        }
        Object object = this.retryLock;
        synchronized (object) {
            this.retryLock.notifyAll();
        }
    }

    private void transition(String newState) {
        if (this.log.isTraceOn()) {
            this.log.trace(this.getState() + " -> " + newState);
        }
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLingerTimeout() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            this.lingerTicket = null;
            if (this.interests.size() == 0) {
                this.close();
            }
        }
    }

    public boolean getCheckBrandCompatibility() {
        return this.checkBrandCompatibility;
    }

    public void setCheckBrandCompatibility(boolean check) {
        this.checkBrandCompatibility = check;
    }

    public final boolean isPasswordResetRequired() {
        FoxMessage remoteWelcome;
        FoxSession session = this.session();
        if (session != null && (remoteWelcome = session.getRemoteWelcome()) != null) {
            return remoteWelcome.getBoolean("forceReset", false);
        }
        return false;
    }

    public void pingOk() {
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::pingOk);
    }

    public void pingFail(String cause) {
        this.getConnectionTarget(NiagaraStation.class).ifPresent(station -> station.pingFail(cause));
    }

    public void doManualConnect() throws Exception {
        this.connect();
    }

    public void doManualDisconnect() throws Exception {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(lingerTimeout)) {
            try {
                if (!threadPool.isRunning()) {
                    ThreadPoolWorker threadPoolWorker = threadPool;
                    synchronized (threadPoolWorker) {
                        if (!threadPool.isRunning()) {
                            threadPool.start("foxLingerTimeout");
                        }
                    }
                }
                queue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
            }
            catch (Exception e) {
                if (this.log.isTraceOn()) {
                    this.log.error("Could not invoke lingerTimeout action on fox client connection " + this.toDebugString(), e);
                }
                this.log.error("Could not invoke lingerTimeout action on fox client connection " + this.toDebugString());
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop.isFrozen() && (prop.getDefaultFlags() & 1) == 0) {
            this.interruptRetries();
        }
    }

    public void started() {
        BValue pingHealth;
        BComplex parent;
        if (!Flags.has((BComplex)this, (Slot)lastFailureCause, (int)0x10000000)) {
            this.setFacets((Slot)lastFailureCause, BFacets.make((String)"fieldWidth", (int)100));
            this.setFlags((Slot)lastFailureCause, this.getFlags((Slot)lastFailureCause) | 0x10000000);
        }
        if ((parent = this.getParent()) instanceof NiagaraStation && (pingHealth = parent.get("health")) instanceof BComplex) {
            BComplex pingHealthComplex = pingHealth.asComplex();
            Property pingHealthProp = pingHealthComplex.getPropertyInParent();
            Property lastFailCauseProp = pingHealthComplex.getProperty("lastFailCause");
            if (lastFailCauseProp != null && pingHealthProp != null && !Flags.has((BComplex)parent, (Slot)pingHealthProp, (int)0x10000000)) {
                pingHealthComplex.setFacets((Slot)lastFailCauseProp, BFacets.make((String)"multiLine", (boolean)true));
                parent.setFlags((Slot)pingHealthProp, parent.getFlags((Slot)pingHealthProp) | 0x10000000);
            }
        }
    }

    @Override
    void fwStarted() {
        if (!Flags.isUserDefined1((BComplex)this, (Slot)foxOverWebsocket)) {
            this.setFlags((Slot)foxOverWebsocket, this.getFlags((Slot)foxOverWebsocket) & 0xFFFFFFFA | 0x10000000);
        }
        if (!Flags.isUserDefined1((BComplex)this, (Slot)foxOverWebsocketPort)) {
            this.setFlags((Slot)foxOverWebsocketPort, this.getFlags((Slot)foxOverWebsocketPort) & 0xFFFFFFFA | 0x10000000);
        }
        if (!Flags.isUserDefined1((BComplex)this, (Slot)foxOverWebsocketInUse)) {
            this.setFlags((Slot)foxOverWebsocketInUse, this.getFlags((Slot)foxOverWebsocketInUse) & 0xFFFFFFFB | 0x10000000);
        }
    }

    private InterestLogItem logEngaged(Interest interest) {
        InterestLogItem log = new InterestLogItem();
        log.interest = interest.toString();
        log.startTicks = Clock.ticks();
        return log;
    }

    private void logDisengaged(InterestLogItem log) {
        log.endTicks = Clock.ticks();
        while (this.interestLog.size() >= 20) {
            this.interestLog.remove(0);
        }
        this.interestLog.add(log);
    }

    public static void spyThreadPoolWorker(SpyWriter out) {
        try {
            threadPool.spy(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BUsernameCredential requestUsername(AuthenticationRealm realm) {
        BValue authScheme = this.get("authenticationScheme");
        if (authScheme instanceof BString && !((BString)authScheme).getString().isEmpty()) {
            return new BUsernameSchemeCredentials(this.getCredentials().getUsername(), ((BString)authScheme).getString());
        }
        return new BUsernameCredential(this.getCredentials().getUsername());
    }

    public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
        return this.getCredentials();
    }

    static {
        try {
            engageLinger = Long.parseLong(AccessController.doPrivileged(() -> System.getProperty("niagara.fox.engageLinger", "" + engageLinger)).trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FOX_WS_HTTP_CONNECTION_TIMEOUT = AccessController.doPrivileged(() -> Long.getLong("foxwss.connectiontimeout", 60000L));
        queue = new CoalesceQueue(1000);
        threadPool = new ThreadPoolWorker((Worker.ITodo)queue);
        threadPool.setMaxThreads(1000);
        LEX = Lexicon.make((String)"fox");
        FOX_WS_EXECUTOR_SERVICE = Executors.newCachedThreadPool(new FoxWebSocketAdapter.FoxwssThreadFactory("FoxwssClientThread-"));
    }

    public static class InterestLogItem {
        public String interest;
        public long startTicks;
        public long endTicks;
    }

    public static class StringInterest
    implements Interest {
        private String string;

        public StringInterest(String s) {
            if (s == null) {
                throw new IllegalArgumentException("interest string is null");
            }
            this.string = s;
        }

        @Override
        public int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof StringInterest && ((StringInterest)o).string.equals(this.string);
        }

        @Override
        public String toString() {
            return this.string;
        }
    }

    public static interface Interest {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    private static class WbToStationFoxwssExemptionApprover
    implements ExemptionApprover,
    Runnable {
        private static final long FIVE_MINUTES = 300000L;
        private final BFoxClientConnection clientConnection;
        private final AtomicBoolean exemptionApprovalComplete = new AtomicBoolean();
        private final AtomicBoolean approved = new AtomicBoolean();
        private volatile CertValidationResult certValidationResult;

        public WbToStationFoxwssExemptionApprover(BFoxClientConnection clientConnection) {
            this.clientConnection = clientConnection;
        }

        public boolean approveExemption(CertValidationResult result) {
            this.certValidationResult = result;
            this.exemptionApprovalComplete.set(false);
            this.approved.set(false);
            this.clientConnection.exemptionRequest = this;
            long startTicks = Clock.ticks();
            while (!this.exemptionApprovalComplete.get() && Clock.ticks() - startTicks < 300000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean isApproved = this.approved.get();
            this.clientConnection.foxwssServerCertValidationFailure = !isApproved;
            return isApproved;
        }

        @Override
        public void run() {
            try {
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                ExemptionHandler exemptionHandler = (ExemptionHandler)cryptoManager.getClientSocketFactory(ClientTlsParameters.DEFAULT);
                this.approved.set(exemptionHandler.getExemptionApprover().approveExemption(this.certValidationResult));
            }
            catch (Exception e) {
                FoxHttpsSocket.LOG.log(Level.WARNING, "FoxClientConnection could not process WbExemptionApprover", FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? e : null);
            }
            finally {
                this.exemptionApprovalComplete.set(true);
            }
        }
    }

    private static class StationToStationFoxwssExemptionApprover
    extends DefaultExemptionApprover {
        private final BFoxClientConnection clientConnection;

        public StationToStationFoxwssExemptionApprover(BFoxClientConnection clientConnection) {
            this.clientConnection = clientConnection;
        }

        public boolean approveExemption(CertValidationResult result) {
            boolean returnValue = super.approveExemption(result);
            this.clientConnection.foxwssServerCertValidationFailure = !returnValue;
            return returnValue;
        }
    }

    private class ConnectPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private ConnectPrivilegedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() throws Exception {
            Optional<NiagaraStation> parent = BFoxClientConnection.this.getConnectionTarget(NiagaraStation.class);
            long startTicks = Clock.ticks();
            Object object = BFoxClientConnection.this.connectLock;
            synchronized (object) {
                if (BFoxClientConnection.this.isConnected()) {
                    return null;
                }
                if (BFoxClientConnection.this.lastFailureTicks > startTicks) {
                    throw BFoxClientConnection.this.lastFailureException;
                }
                String startState = BFoxClientConnection.this.getState();
                FoxSession.IFoxSessionListener[] listeners = FoxSession.createListeners(BFoxClientConnection.this);
                try {
                    if (parent.isPresent() && parent.get().isFatalFault()) {
                        throw new Exception(parent.get().getFaultCause());
                    }
                    BFoxClientConnection.this.transition("Connecting...");
                    BFoxClientConnection.this.setNextAttemptTime(BAbsTime.NULL);
                    BHost remoteHost = BFoxClientConnection.this.getRemoteHost();
                    if (remoteHost == null) {
                        throw new IllegalStateException("Remote host not set");
                    }
                    BIUserCredentials cred = BFoxClientConnection.this.getCredentials();
                    if ((cred.getUsername() == null || cred.getUsername().isEmpty()) && BFoxClientConnection.this.authenticationClient.getPreconnectCredentials().isPresent()) {
                        cred = (BIUserCredentials)BFoxClientConnection.this.authenticationClient.getPreconnectCredentials().get();
                    }
                    BFoxClientConnection.this.skipFoxwssFallthrough = BFoxClientConnection.this.foxSession != null && !BFoxwssScheme.getAttemptFoxOverWebsocketIfFoxOrFoxsFails();
                    BFoxClientConnection.this.clientCertAuthFailure = false;
                    BFoxClientConnection.this.foxwssServerCertValidationFailure = false;
                    Socket socket = null;
                    boolean redirect = false;
                    if (BFoxClientWebsocketBehavior.useWebsocketOnly.equals((Object)BFoxClientConnection.this.getFoxOverWebsocket())) {
                        this.attemptFoxWebSocketConnection(cred, listeners);
                    } else {
                        if (!BFoxClientConnection.this.getUseFoxs()) {
                            try {
                                socket = remoteHost.openSocket(BFoxClientConnection.this.getPort());
                                BFoxClientConnection.this.skipFoxwssFallthrough = true;
                                BFoxClientConnection.this.sslHandshakeComplete = true;
                                Fox.open((FoxConnection)BFoxClientConnection.this, socket, (BICredentials)cred, listeners);
                                BFoxClientConnection.this.setFoxOverWebsocketInUse(false);
                            }
                            catch (FoxsRedirectException fre) {
                                if (BFoxClientConnection.this.foxSession != null) {
                                    throw fre;
                                }
                                socket.close();
                                redirect = true;
                                int redirectPort = fre.getPort();
                                BFoxClientConnection.this.setPort(fre.getPort());
                                BFoxClientConnection.this.setUseFoxs(true);
                                BFoxClientConnection.this.log.message("received foxs redirect to port " + redirectPort);
                            }
                            catch (Throwable t) {
                                if (socket == null && !BFoxClientConnection.this.skipFoxwssFallthrough && BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails.equals((Object)BFoxClientConnection.this.getFoxOverWebsocket())) {
                                    this.attemptFoxWebSocketConnection(cred, listeners);
                                    if (BFoxClientConnection.this.foxSession != null) {
                                        BFoxClientConnection.this.foxSession.reconfigureForWebSocket();
                                    }
                                }
                                throw t;
                            }
                        }
                        if (BFoxClientConnection.this.getUseFoxs() || redirect) {
                            try {
                                if (BFoxClientConnection.this.socketFactory == null) {
                                    ClientTlsParameters tlsParameters;
                                    ICryptoManager cryptoFactory;
                                    block61: {
                                        cryptoFactory = CertManagerFactory.getInstance();
                                        if (cred instanceof BCertificateAliasCredential) {
                                            tlsParameters = new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol(), ((BCertificateAliasCredential)cred).getCertificateAlias());
                                            if (!((BCertificateAliasCredential)cred).getCertificatePassword().equals((Object)BPassword.DEFAULT)) {
                                                try (SecretChars certPasswordChars = ((BCertificateAliasCredential)cred).getCertificatePassword().getSecretChars();){
                                                    tlsParameters.setKeyPassphrase(certPasswordChars.get());
                                                }
                                                catch (Exception e) {
                                                    if (BFoxClientConnection.this.log.isTraceOn()) {
                                                        BFoxClientConnection.this.log.message("error decoding password for cert", e);
                                                        break block61;
                                                    }
                                                    BFoxClientConnection.this.log.message("error decoding password for cert");
                                                }
                                            }
                                        } else {
                                            tlsParameters = ClientTlsParameters.DEFAULT;
                                        }
                                    }
                                    try {
                                        SocketFactory fact = cryptoFactory.getClientSocketFactory(tlsParameters);
                                        socket = remoteHost.openSocket(BFoxClientConnection.this.getPort(), fact);
                                        BFoxClientConnection.this.skipFoxwssFallthrough = true;
                                    }
                                    catch (SecurityException e) {
                                        if (BFoxClientConnection.this.isClientCertAuthUnrecoverableKeyException(BFoxClientConnection.this.foxSession, cred, e)) {
                                            BFoxClientConnection.this.clientCertAuthFailure = true;
                                            BFoxClientConnection.this.skipFoxwssFallthrough = true;
                                            BFoxClientConnection.this.foxSession.getConnection().getAuthenticationClient().setPreconnectCredentials(null);
                                            throw new FoxAuthenticationException(Lexicon.make((String)"clientCertAuth").getText("authnHandler.unsupportedCertificateCredentials"), BFoxClientConnection.this.foxSession.getAuthenticationScheme(), null, BFoxClientConnection.this.foxSession.getConnection().session());
                                        }
                                        throw new AuthenticationException((AuthenticationRealm)BFoxClientConnection.this.foxSession, (Throwable)e);
                                    }
                                }
                                socket = remoteHost.openSocket(BFoxClientConnection.this.getPort(), (SocketFactory)BFoxClientConnection.this.socketFactory);
                                BFoxClientConnection.this.skipFoxwssFallthrough = true;
                                if (socket instanceof SSLSocket) {
                                    BFoxClientConnection.this.listenForHandshake((SSLSocket)socket);
                                }
                                if (BFoxClientConnection.this.foxSession != null) {
                                    BFoxClientConnection.this.foxSession.setUseFoxs(true);
                                    BFoxClientConnection.this.foxSession.setPort(BFoxClientConnection.this.getPort());
                                }
                                Fox.open((FoxConnection)BFoxClientConnection.this, socket, (BICredentials)cred, listeners);
                                BFoxClientConnection.this.setFoxOverWebsocketInUse(false);
                            }
                            catch (Throwable t) {
                                if (socket == null && !BFoxClientConnection.this.skipFoxwssFallthrough && BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails.equals((Object)BFoxClientConnection.this.getFoxOverWebsocket())) {
                                    this.attemptFoxWebSocketConnection(cred, listeners);
                                    if (BFoxClientConnection.this.foxSession != null) {
                                        BFoxClientConnection.this.foxSession.reconfigureForWebSocket();
                                    }
                                }
                                if (t instanceof ServiceNotFoundException) {
                                    throw new IOException("CryptoFactory not found.");
                                }
                                if (t instanceof TlsFatalAlert) {
                                    throw new LocalizableException("fox", "error.untrustedFoxsCertificate", t);
                                }
                                throw t;
                            }
                        }
                    }
                    BFoxClientConnection.this.lastFailureTicks = 0L;
                    BFoxClientConnection.this.lastFailureException = null;
                    BFoxClientConnection.this.setLastFailureTime(BAbsTime.NULL);
                    BFoxClientConnection.this.setLastFailureCause("");
                    if (BFoxClientConnection.this.isPasswordResetRequired()) {
                        BFoxClientConnection.this.pingFail(LEX.getText("ping.fail.passwordResetRequired"));
                    } else {
                        BFoxClientConnection.this.pingOk();
                    }
                    if (BFoxClientConnection.this.foxSession != null) {
                        BFoxClientConnection.this.foxSession.postConnect();
                    }
                }
                catch (FoxsRedirectException fre) {
                    throw fre;
                }
                catch (Exception e) {
                    String cause;
                    String string = cause = e instanceof Localizable ? ((Localizable)e).toString(null) : e.toString();
                    if (e instanceof FoxAuthenticationException) {
                        FoxAuthenticationException ex = (FoxAuthenticationException)e;
                        cause = "Authentication Failed";
                        if (e instanceof ReportCauseAuthenticationException) {
                            cause = cause + ": " + ((ReportCauseAuthenticationException)e).getCauseMessage();
                        }
                        if (ex.fatal != null) {
                            cause = cause + ": " + ex.fatal;
                        }
                    }
                    BFoxClientConnection.this.transition(startState);
                    BFoxClientConnection.this.lastFailureTicks = Clock.ticks();
                    BFoxClientConnection.this.lastFailureException = e;
                    BFoxClientConnection.this.setLastFailureTime(Clock.time());
                    BFoxClientConnection.this.setLastFailureCause(cause.replace('\n', ' '));
                    BFoxClientConnection.this.pingFail(cause);
                    if (listeners != FoxSession.nullListeners) {
                        for (FoxSession.IFoxSessionListener listener : listeners) {
                            listener.connectionAborted(cause, e);
                        }
                    }
                    if (listeners != FoxSession.nullListeners) {
                        for (FoxSession.IFoxSessionListener listener : listeners) {
                            listener.connectionAborted(cause, e);
                        }
                    }
                    BFoxClientConnection.this.sslHandshakeComplete = false;
                    throw e;
                }
            }
            return null;
        }

        private void attemptFoxWebSocketConnection(BIUserCredentials cred, FoxSession.IFoxSessionListener[] listeners) throws Exception {
            WebSocketClient[] webSocketClient = new WebSocketClient[]{null};
            FoxWebSocketAdapter socketAdapter = new FoxWebSocketAdapter(BFoxClientConnection.this);
            try {
                ClientTlsParameters tlsParameters;
                if (cred instanceof BCertificateAliasCredential) {
                    tlsParameters = new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol(), ((BCertificateAliasCredential)cred).getCertificateAlias(), TlsCipherSuiteGroup.recommended);
                    if (!((BCertificateAliasCredential)cred).getCertificatePassword().equals((Object)BPassword.DEFAULT)) {
                        try (SecretChars certPasswordChars = ((BCertificateAliasCredential)cred).getCertificatePassword().getSecretChars();){
                            tlsParameters.setKeyPassphrase(certPasswordChars.get());
                        }
                        catch (Exception e) {
                            if (FoxHttpsSocket.LOG.isLoggable(Level.INFO)) {
                                FoxHttpsSocket.LOG.log(Level.INFO, "Error decoding password for cert of " + BFoxClientConnection.this.toDisplayPathString(null), FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? e : null);
                            }
                        }
                    }
                } else {
                    tlsParameters = new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol(), ClientTlsParameters.DEFAULT.getCertAlias(), TlsCipherSuiteGroup.recommended);
                }
                SslContextFactory factory = this.getWebSocketSslContextFactory(tlsParameters);
                String host = BFoxClientConnection.this.getRemoteHost().getHostname();
                int port = BFoxClientConnection.this.getEffectiveFoxOverWebsocketPort();
                if (IPAddressUtil.isIpv6Address((String)host) || IPAddressUtil.isIpv4MappedAddress((String)host)) {
                    host = '[' + host + ']';
                }
                HttpClient[] httpClient = new HttpClient[]{null};
                String niagaraUserAgent = "Niagara/" + AccessController.doPrivileged(Nre::getModuleManager).getModuleForClass(HttpConnection.class).getVendorVersion();
                try {
                    Future fut;
                    try {
                        webSocketClient[0] = AccessController.doPrivileged(() -> {
                            httpClient[0] = new HttpClient(factory);
                            httpClient[0].setUserAgentField(new HttpField(HttpHeader.USER_AGENT, niagaraUserAgent));
                            httpClient[0].setExecutor((Executor)FOX_WS_EXECUTOR_SERVICE);
                            httpClient[0].setConnectTimeout(FOX_WS_HTTP_CONNECTION_TIMEOUT);
                            httpClient[0].setMaxConnectionsPerDestination(1);
                            return new WebSocketClient(httpClient[0]);
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    webSocketClient[0].setStopAtShutdown(true);
                    webSocketClient[0].start();
                    String pathPrefix = BFoxClientConnection.this.getFoxOverWebsocketPathPrefix().trim();
                    if (pathPrefix.isEmpty()) {
                        pathPrefix = "/";
                    } else {
                        if (!pathPrefix.startsWith("/")) {
                            pathPrefix = '/' + pathPrefix;
                        }
                        if (!pathPrefix.endsWith("/")) {
                            pathPrefix = pathPrefix + '/';
                        }
                    }
                    URI uri = URI.create("wss://" + host + ':' + port + pathPrefix + "foxwss");
                    if (FoxHttpsSocket.LOG.isLoggable(Level.FINE)) {
                        FoxHttpsSocket.LOG.fine("Attempting foxwss connection for " + BFoxClientConnection.this.toDisplayPathString(null) + " to URI: " + uri);
                    }
                    try {
                        fut = AccessController.doPrivileged(() -> webSocketClient[0].connect((Object)socketAdapter, uri));
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    long maxWaitTicks = FOX_WS_HTTP_CONNECTION_TIMEOUT * 2L;
                    long startFoxwssConnectionTicks = Clock.ticks();
                    while (!fut.isDone()) {
                        if (BFoxClientConnection.this.exemptionRequest != null) {
                            Runnable temp = BFoxClientConnection.this.exemptionRequest;
                            BFoxClientConnection.this.exemptionRequest = null;
                            temp.run();
                        }
                        if (Clock.ticks() - startFoxwssConnectionTicks > maxWaitTicks) {
                            throw new WebSocketTimeoutException("Unexpected timeout waiting for foxwss connection");
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable t) {
                    if (FoxHttpsSocket.LOG.isLoggable(Level.WARNING)) {
                        FoxHttpsSocket.LOG.log(Level.WARNING, "Error creating WebSocket session for " + BFoxClientConnection.this.toDisplayPathString(null), FoxHttpsSocket.LOG.isLoggable(Level.FINE) ? t : null);
                    }
                    throw t;
                }
            }
            catch (SecurityException e) {
                try {
                    webSocketClient[0].stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (BFoxClientConnection.this.isClientCertAuthUnrecoverableKeyException(BFoxClientConnection.this.foxSession, cred, e)) {
                    BFoxClientConnection.this.clientCertAuthFailure = true;
                    BFoxClientConnection.this.foxSession.getConnection().getAuthenticationClient().setPreconnectCredentials(null);
                    throw new FoxAuthenticationException(Lexicon.make((String)"clientCertAuth").getText("authnHandler.unsupportedCertificateCredentials"), BFoxClientConnection.this.foxSession.getAuthenticationScheme(), null, BFoxClientConnection.this.foxSession.getConnection().session());
                }
                throw new AuthenticationException((AuthenticationRealm)BFoxClientConnection.this.foxSession, (Throwable)e);
            }
            try {
                Socket socket = AccessController.doPrivileged(() -> FoxHttpsSocket.makeClientSocket(webSocketClient[0], socketAdapter, ((BIpHost)BFoxClientConnection.this.getRemoteHost().as(BIpHost.class)).getInetAddress()));
                BFoxClientConnection.this.skipFoxwssFallthrough = true;
                Fox.open((FoxConnection)BFoxClientConnection.this, socket, (BICredentials)cred, listeners);
            }
            catch (FoxAuthenticationException fae) {
                try {
                    webSocketClient[0].stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                BFoxClientConnection.this.clientCertAuthFailure = BFoxClientConnection.CLIENT_CERT_SCHEME_NAME.equals(fae.method);
                throw fae;
            }
            catch (Exception ex) {
                try {
                    webSocketClient[0].stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw this.computeFoxwssConnectionException(ex);
            }
            BFoxClientConnection.this.sslHandshakeComplete = true;
            BFoxClientConnection.this.setFoxOverWebsocketInUse(true);
        }

        private SslContextFactory getWebSocketSslContextFactory(ClientTlsParameters tlsParameters) throws PrivilegedActionException {
            return AccessController.doPrivileged(() -> {
                CoreCryptoManager ccm = CoreCryptoManager.get();
                SslContextFactory.Client factory = ccm.getSslContextFactory(tlsParameters);
                factory.setEndpointIdentificationAlgorithm("");
                factory.setHostnameVerifier((HostnameVerifier)new TridiumHostnameVerifier(ccm.getExemptionStore()));
                SSLContext sslContext = SSLContext.getInstance((String)CryptoSupport.TYPES.get("tlsv1.2"));
                Object exemptionApprover = Sys.isStation() ? new StationToStationFoxwssExemptionApprover(BFoxClientConnection.this) : new WbToStationFoxwssExemptionApprover(BFoxClientConnection.this);
                CoreClientTrustManager trustManager = CoreClientTrustManager.make((CoreCryptoManager)ccm, () -> ConnectPrivilegedAction.lambda$null$3((ExemptionApprover)exemptionApprover));
                TrustManager[] tm = new X509TrustManager[]{trustManager};
                KeyManager[] km = null;
                if (tlsParameters.getCertAlias() != null) {
                    km = new AliasedKeyManagerBuilder(SecurityInitializer.getInstance().getSecurityInfoProvider(), tlsParameters.getCertAlias(), tlsParameters.getKeyPassphrase() == null ? null : new SecretChars(tlsParameters.getKeyPassphrase(), true)).getKeyManagers();
                }
                sslContext.init(km, tm, new SecureRandom());
                factory.setSslContext(sslContext);
                factory.setSslSessionTimeout(125);
                return factory;
            });
        }

        private Exception computeFoxwssConnectionException(Exception ex) {
            if (BFoxClientConnection.this.foxwssServerCertValidationFailure) {
                return new LocalizableException("fox", "error.untrustedFoxwssCertificate", (Throwable)ex);
            }
            if (ex instanceof EOFException) {
                ConnectException connException = new ConnectException(LEX.getText("error.connectionRefused", new Object[]{ex.getMessage()}));
                connException.setStackTrace(ex.getStackTrace());
                return (Exception)connException.initCause(ex);
            }
            return ex;
        }

        private static /* synthetic */ ExemptionApprover lambda$null$3(ExemptionApprover exemptionApprover) {
            return exemptionApprover;
        }
    }
}

