/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.session.Tuner;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.baja.security.BICredentials;
import javax.baja.sys.Sys;

public class Fox {
    public static final int BASIC_AUTHENTICATION = 0;
    public static final int DIGEST_AUTHENTICATION = 1;
    public static final int TRANSACTIONAL_AUTHENTICATION = 2;
    public static String MULTICAST_ADDRESS = "224.0.1.84";
    public static String IPV6_MULTICAST_ADDRESS = "FF02::137";
    public static final int MULTICAST_PORT = 1911;
    public static final String UNKNOWN_STRING = "unknown";
    public static long sessionCloseTimeout = 10000L;
    public static boolean ipv4Enabled = true;
    public static boolean ipv6Enabled = false;
    public static boolean multicastEnabled = true;
    public static int requestTimeout = 60000;
    public static int keepAliveInterval = 5000;
    public static int soTimeout = 60000;
    public static boolean tcpNoDelay = true;
    public static boolean failsafeTimeouts = true;
    public static int maxServerSessions = 100;
    public static int maxQueueSize = 1000;
    public static int circuitChunkSize = 4096;
    public static int circuitMaxReceiveBuffer = 102400;
    private static final long DEFAULT_PRE_AUTH_FRAME_SIZE_LIMIT = 65536L;
    private static long preAuthFrameSizeLimit = 65536L;
    public static int multicastTimeToLive = 4;
    public static boolean traceWriteFrame = false;
    public static boolean traceReadFrame = false;
    public static boolean traceSessionStates = false;
    public static boolean traceMulticast = false;
    public static String appName = "unknown";
    public static String appVersion = "unknown";
    public static String vmName = AccessController.doPrivileged(() -> System.getProperty("java.vm.name", UNKNOWN_STRING));
    public static String vmVersion = AccessController.doPrivileged(() -> System.getProperty("java.vm.version", UNKNOWN_STRING));
    public static String osName = AccessController.doPrivileged(() -> System.getProperty("os.name", UNKNOWN_STRING));
    public static String osVersion = AccessController.doPrivileged(() -> System.getProperty("os.version", UNKNOWN_STRING));
    public static String hostAddress = "";
    public static String hostName;
    public static ExceptionTranslator exceptionTranslator;
    public static SimpleDateFormat timestampFormatter;
    public static Clock clock;
    public static final ThreadGroup threadGroup;
    private static final int MAX_INT_LEN;
    private static int serverSessionCount;
    private static volatile int invalidFrameCount;

    public static int getInvalidFrameCount() {
        return invalidFrameCount;
    }

    public static void incrementInvalidFrameCount() {
        ++invalidFrameCount;
    }

    public static long getPreAuthFrameSizeLimit() {
        return preAuthFrameSizeLimit;
    }

    public static void setPreAuthFrameSizeLimit(long preAuthFrameSizeLimit) {
        Fox.preAuthFrameSizeLimit = preAuthFrameSizeLimit;
    }

    private static boolean getBoolean(String key, boolean def) {
        String v = AccessController.doPrivileged(() -> System.getProperty(key));
        if (v == null) {
            return def;
        }
        return v.equals("true");
    }

    private static int getInt(String key, int def) {
        String v = AccessController.doPrivileged(() -> System.getProperty(key));
        if (v == null) {
            return def;
        }
        return Integer.parseInt(v);
    }

    private static Object getInstance(String key, Object def) {
        try {
            String v = AccessController.doPrivileged(() -> System.getProperty(key));
            if (v == null) {
                return def;
            }
            return Fox.class.getClassLoader().loadClass(v).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return def;
        }
    }

    private static String getString(String key, String def) {
        return AccessController.doPrivileged(() -> System.getProperty(key, def));
    }

    public static FoxSession open(FoxConnection conn, Socket socket, String user, String password) throws Exception {
        return Fox.open(conn, socket, user, password, FoxSession.nullListeners);
    }

    public static FoxSession open(FoxConnection conn, Socket socket, String user, String password, FoxSession.IFoxSessionListener[] listeners) throws Exception {
        return Tuner.openClient(conn, socket, user, password, listeners);
    }

    public static FoxSession open(FoxConnection conn, Socket socket, BICredentials cred, FoxSession.IFoxSessionListener[] listeners) throws Exception {
        return Tuner.openClient(conn, socket, cred, listeners);
    }

    public static FoxSession getSession(String id) {
        FoxSession session = (FoxSession)SessionManager.getNiagaraSession((String)id, FoxSession.class);
        if (session == null && id.length() <= MAX_INT_LEN) {
            try {
                int intId = Integer.parseInt(id);
                Set foxSessions = SessionManager.getNiagaraSessions(FoxSession.class);
                for (FoxSession foxSession : foxSessions) {
                    if (!foxSession.isLegacyConnection() || foxSession.getLegacyId() != intId) continue;
                    return foxSession;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return session;
    }

    public static int getServerSessionCount() {
        return SessionManager.countNiagaraSessions(FoxSession.class, FoxSession::isServer);
    }

    public static FoxSession[] getSessions() {
        Set foxSessions = SessionManager.getNiagaraSessions(FoxSession.class);
        return foxSessions.toArray(new FoxSession[0]);
    }

    static void register(FoxSession session) {
        SessionManager.addSession((NiagaraSession)session);
    }

    static void unregister(FoxSession session) {
        session.invalidate();
    }

    static void debugSessions() {
        SessionManager.printSessions();
    }

    static {
        try {
            hostAddress = Sys.getLocalHost(null).getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hostName = "";
        try {
            hostName = Sys.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        exceptionTranslator = new ExceptionTranslator();
        try {
            clock = new DefaultClock();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(Nre.findMainThreadGroup((ThreadGroup)Thread.currentThread().getThreadGroup()), "fox");
            }
        });
        try {
            soTimeout = Fox.getInt("niagara.fox.soTimeout", soTimeout);
            tcpNoDelay = Fox.getBoolean("niagara.fox.tcpNoDelay", tcpNoDelay);
            keepAliveInterval = Fox.getInt("niagara.fox.keepAliveInterval", keepAliveInterval);
            requestTimeout = Fox.getInt("niagara.fox.requestTimeout", requestTimeout);
            maxServerSessions = Fox.getInt("niagara.fox.maxServerSessions", maxServerSessions);
            maxQueueSize = Fox.getInt("niagara.fox.maxQueueSize", maxQueueSize);
            circuitChunkSize = Fox.getInt("niagara.fox.circuitChunkSize", circuitChunkSize);
            circuitMaxReceiveBuffer = Fox.getInt("niagara.fox.circuitMaxReceiveBuffer", circuitMaxReceiveBuffer);
            failsafeTimeouts = Fox.getBoolean("niagara.fox.failsafeTimeouts", failsafeTimeouts);
            multicastTimeToLive = Fox.getInt("niagara.fox.multicastTimeToLive", multicastTimeToLive);
            exceptionTranslator = (ExceptionTranslator)Fox.getInstance("niagara.fox.exceptionTranslator", exceptionTranslator);
            traceWriteFrame = Fox.getBoolean("niagara.fox.traceWriteFrame", traceWriteFrame);
            traceReadFrame = Fox.getBoolean("niagara.fox.traceReadFrame", traceReadFrame);
            traceSessionStates = Fox.getBoolean("niagara.fox.traceSessionStates", traceSessionStates);
            traceMulticast = Fox.getBoolean("niagara.fox.traceMulticast", traceMulticast);
            ipv6Enabled = Fox.getBoolean("niagara.ipv6Enabled", ipv6Enabled);
            multicastEnabled = Fox.getBoolean("niagara.fox.multicastEnabled", multicastEnabled);
            sessionCloseTimeout = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.fox.sessionCloseTimeout", sessionCloseTimeout));
            preAuthFrameSizeLimit = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.fox.preAuthFrameSizeLimit", preAuthFrameSizeLimit));
            timestampFormatter = new SimpleDateFormat(Fox.getString("niagara.fox.errorDateFormatString", "HH:mm:ss dd-MMM-yy z"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        FailsafeTimeoutThread thread = new FailsafeTimeoutThread();
        thread.setDaemon(true);
        thread.start();
        MAX_INT_LEN = Integer.toString(Integer.MAX_VALUE).length();
    }

    static class FailsafeTimeoutThread
    extends Thread {
        FailsafeTimeoutThread() {
            super(threadGroup, "Fox:FailsafeTimeout");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(10000L);
                        if (!Fox.failsafeTimeouts) continue;
                        sessions = Fox.getSessions();
                        i = 0;
                        while (true) {
                            if (i < sessions.length) ** break;
                            continue block3;
                            session = sessions[i];
                            readLag = Fox.clock.ticks() - session.getLastReadTicks();
                            writeLag = Fox.clock.ticks() - session.getLastWriteTicks();
                            if (readLag > (long)Fox.soTimeout) {
                                ex = new IOException("Failsafe timeout on read " + readLag + "ms > " + Fox.soTimeout + "ms");
                                System.out.println("SEVERE [" + Fox.timestampFormatter.format(new Date()) + "][fox] " + ex.getMessage());
                                session.close(ex);
                            } else if (writeLag > (long)Fox.soTimeout) {
                                ex = new IOException("Failsafe timeout on write " + writeLag + "ms > " + Fox.soTimeout + "ms");
                                System.out.println("SEVERE [" + Fox.timestampFormatter.format(new Date()) + "][fox] " + ex.getMessage());
                                session.close(ex);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("SEVERE [" + Fox.timestampFormatter.format(new Date()) + "][fox] Exception occurred during FailsafeTimeout check");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class DefaultClock
    extends Clock {
        private DefaultClock() {
        }

        @Override
        public long ticks() {
            return javax.baja.sys.Clock.ticks();
        }
    }

    public static abstract class Clock {
        public abstract long ticks();
    }

    public static class ExceptionTranslator {
        public FoxMessage exceptionToMessage(Throwable e) {
            FoxMessage msg = new FoxMessage();
            msg.add("exception", e.toString());
            return msg;
        }

        public Exception messageToException(FoxMessage msg) throws IOException {
            return new ServerException(msg.getString("exception"));
        }
    }
}

