/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.encoding;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.sys.Context;

public class DecoderFactory {
    private static final Map<String, Provider> providers = new HashMap<String, Provider>();

    public static Object decode(FoxMessage msg, String key, Object arg) throws Exception {
        return DecoderFactory.decode(msg, key, arg, null);
    }

    public static Object decode(FoxMessage msg, String key, Object arg, Context cx) throws Exception {
        FoxObject fo = (FoxObject)msg.get(key);
        return DecoderFactory.decode(fo.encoding, fo.data, arg, cx);
    }

    public static Object decode(FoxObject fo, Object arg) throws Exception {
        return DecoderFactory.decode(fo.encoding, fo.data, arg);
    }

    public static Object decode(String name, byte[] buf, Object arg) throws Exception {
        return DecoderFactory.decode(name, buf, arg, null);
    }

    public static Object decode(String name, byte[] buf, Object arg, Context cx) throws Exception {
        Provider provider = providers.get(name);
        if (provider != null) {
            return provider.decode(buf, arg, cx);
        }
        throw new IOException("Unknown object encoding: " + name);
    }

    public static void register(String name, Provider provider) {
        providers.put(name, provider);
    }

    public static void unregister(String name) {
        providers.remove(name);
    }

    static {
        DecoderFactory.register("bog", new BogCodec.Provider());
    }

    public static interface Provider {
        default public Object decode(byte[] buf, Object arg) throws Exception {
            return this.decode(buf, arg, null);
        }

        public Object decode(byte[] var1, Object var2, Context var3) throws Exception;
    }
}

