/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.dashboard;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.sys.BFoxService;
import com.tridium.security.BServerCertificateHealth;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.security.auth.x500.X500Principal;

@NiagaraType(agent={@AgentOn(types={"fox:FoxService"})})
public class BFoxServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxServiceSecurityDashboardProviderAgent.class);
    private static final String[] TRACE_PROPERTIES = new String[]{"traceMulticast", "traceReadFrame", "traceSessionStates", "traceWriteFrame"};
    private BFoxService foxService;
    private SecurityDashboardItemBuilder builder;
    private boolean legacyEnabledByDefault;
    public static final Logger LOG = Logger.getLogger("fox");
    private static final int VERSION = 5;
    private static final double CERT_EXPIRY_WARNING_MILLIS = BRelTime.makeDays((int)90).getMillis();
    private static final int LEGACY_DEFAULT = 0;
    private static final int LEGACY_NO = 1;
    private static final int LEGACY_YES = 2;
    private static final String CERT_EXPIRED_SUMMARY = "securityDashboard.foxCertificateExpired.summary";
    private static final String CERT_EXPIRED_DESCRIPTION = "securityDashboard.foxCertificateExpired.description";
    private static final String CERT_MISSING_SUMMARY = "securityDashboard.foxCertificateNotAvailable.summary";
    private static final String CERT_MISSING_DESCRIPTION = "securityDashboard.foxCertificateNotAvailable.description";
    private static final String CERT_NEAR_EXPIRY_SUMMARY = "securityDashboard.foxCertificateNearExpiry.summary";
    private static final String CERT_NEAR_EXPIRY_DESCRIPTION = "securityDashboard.foxCertificateNearExpiry.description";
    private static final String CERT_NOT_SELF_SIGNED_SUMMARY = "securityDashboard.foxCertificateNotSelfSigned.summary";
    private static final String CERT_NOT_SELF_SIGNED_DESCRIPTION = "securityDashboard.foxCertificateNotSelfSigned.description";
    private static final String CERT_NOT_YET_VALID_SUMMARY = "securityDashboard.foxCertificateNotYetValidException.summary";
    private static final String CERT_NOT_YET_VALID_DESCRIPTION = "securityDashboard.foxCertificateNotYetValidException.description";
    private static final String CERT_DEFAULT_SUMMARY = "securityDashboard.foxCertificateDefault.summary";
    private static final String CERT_DEFAULT_DESCRIPTION = "securityDashboard.foxCertificateDefault.description";
    private static final String CERT_SELF_SIGNED_SUMMARY = "securityDashboard.foxCertificateSelfSigned.summary";
    private static final String CERT_SELF_SIGNED_DESCRIPTION = "securityDashboard.foxCertificateSelfSigned.description";
    private static final String CERT_IN_VALIDITY_PERIOD_SUMMARY = "securityDashboard.foxCertificateValid.summary";
    private static final String CERT_IN_VALIDITY_PERIOD_DESCRIPTION = "securityDashboard.foxCertificateValid.description";
    private static final String CIPHER_SUITE_SUMMARY = "securityDashboard.cipherSuiteGroup.summary";
    private static final String CIPHER_SUITE_DESCRIPTION = "securityDashboard.cipherSuiteGroup.description";
    private static final String FORWARDING_SUMMARY = "securityDashboard.foxForwarding.summary";
    private static final String FORWARDING_DESCRIPTION = "securityDashboard.foxForwarding.description";
    private static final String LEGACY_CLIENTS_DEFAULT_YES_SUMMARY = "securityDashboard.legacyClients.defaultYes.summary";
    private static final String LEGACY_CLIENTS_DEFAULT_NO_SUMMARY = "securityDashboard.legacyClients.defaultNo.summary";
    private static final String LEGACY_CLIENTS_DISABLED_SUMMARY = "securityDashboard.legacyClients.disabled.summary";
    private static final String LEGACY_CLIENTS_ENABLED_SUMMARY = "securityDashboard.legacyClients.enabled.summary";
    private static final String LEGACY_CLIENTS_DESCRIPTION = "securityDashboard.legacyClients.description";
    private static final String NON_TLS_SUMMARY = "securityDashboard.foxNonTlsProtocol.summary";
    private static final String NON_TLS_DESCRIPTION = "securityDashboard.foxNonTlsProtocol.description";
    private static final String SECTION_HEADER = "securityDashboard.sectionHeader";
    private static final String TLS_OFF_SUMMARY = "securityDashboard.foxTlsProtocolOff.summary";
    private static final String TLS_OFF_DESCRIPTION = "securityDashboard.foxTlsProtocolOff.description";
    private static final String TLS_ON_SUMMARY = "securityDashboard.foxTlsProtocolOn.summary";
    private static final String TLS_ON_DESCRIPTION = "securityDashboard.foxTlsProtocolOn.description";
    private static final String TLS_VERSION_SUMMARY = "securityDashboard.foxTlsProtocol.summary";
    private static final String TLS_VERSION_DESCRIPTION = "securityDashboard.foxTlsProtocol.description";
    private static final String TRACE_ENABLED_SUMMARY = "securityDashboard.foxTracePropertiesEnabled.summary";
    private static final String TRACE_ENABLED_DESCRIPTION = "securityDashboard.foxTracePropertiesEnabled.description";
    private static final String GLOBAL_ENCRYPTED_CERT_SUMMARY = "securityDashboard.foxCertificateGloballyEncrypted.summary";
    private static final String UNIQUE_ENCRYPTED_CERT_SUMMARY = "securityDashboard.foxCertificateUniquelyEncrypted.summary";
    private static final String ENCRYPTED_CERT_DESCRIPTION = "securityDashboard.foxCertificateEncrypted.description";
    private static final String FOXWSS_ENABLED_SUMMARY = "securityDashboard.foxwssEnabled.summary";
    private static final String FOXWSS_ENABLED_DESCRIPTION = "securityDashboard.foxwssEnabled.description";
    private static final String FOXWSS_ENABLED_BUT_NOT_OPERATIONAL_SUMMARY = "securityDashboard.foxwssEnabled.notOperational.summary";
    private static final String FOXWSS_ENABLED_BUT_NOT_OPERATIONAL_DESCRIPTION = "securityDashboard.foxwssEnabled.notOperational.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.foxService = (BFoxService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
        this.legacyEnabledByDefault = true;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.foxService.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 5;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>(this.getTlsItems());
        items.addAll(this.getCipherSuiteItems());
        items.addAll(this.getCertificateItems());
        items.addAll(this.getTraceItems());
        items.addAll(this.getLegacyConnectionItems());
        return items;
    }

    private List<SecurityDashboardItem> getTlsItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        boolean foxEnabled = this.foxService.getFoxEnabled();
        boolean foxsEnabled = this.foxService.getFoxsEnabled();
        boolean foxsOnly = this.foxService.getFoxsOnly();
        BSslTlsEnum minProtocol = this.foxService.getFoxsMinProtocol();
        if (foxEnabled && !foxsEnabled) {
            items.add(this.builder.makeAlert(TLS_OFF_SUMMARY, TLS_OFF_DESCRIPTION));
        }
        if (!foxEnabled && foxsEnabled) {
            items.add(this.builder.makeOk(TLS_ON_SUMMARY, TLS_ON_DESCRIPTION));
        }
        if (foxEnabled && foxsEnabled) {
            if (foxsOnly) {
                items.add(this.builder.makeWarning(FORWARDING_SUMMARY, FORWARDING_DESCRIPTION));
            } else {
                items.add(this.builder.makeAlert(NON_TLS_SUMMARY, NON_TLS_DESCRIPTION));
            }
        }
        if (foxsEnabled) {
            BSecurityItemStatus status = BFoxServiceSecurityDashboardProviderAgent.isTlsVersionStrong(minProtocol) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(this.builder.make(status).withSummary(TLS_VERSION_SUMMARY, new Object[]{minProtocol}).withDescription(TLS_VERSION_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
        }
        if (this.foxService.getFoxOverWebsocketEnabled()) {
            boolean webServiceAcceptingFoxwssConnections;
            try {
                BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
                webServiceAcceptingFoxwssConnections = webService.getEnabled() && webService.getHttpsEnabled();
            }
            catch (ServiceNotFoundException e) {
                webServiceAcceptingFoxwssConnections = false;
            }
            if (webServiceAcceptingFoxwssConnections) {
                items.add(this.builder.makeInfo(FOXWSS_ENABLED_SUMMARY, FOXWSS_ENABLED_DESCRIPTION));
            } else {
                items.add(this.builder.makeInfo(FOXWSS_ENABLED_BUT_NOT_OPERATIONAL_SUMMARY, FOXWSS_ENABLED_BUT_NOT_OPERATIONAL_DESCRIPTION));
            }
        }
        return items;
    }

    private static boolean isTlsVersionStrong(BSslTlsEnum tlsVersion) {
        return tlsVersion.equals((Object)BSslTlsEnum.tlsv1_2) || tlsVersion.equals((Object)BSslTlsEnum.tlsv1_3);
    }

    private List<SecurityDashboardItem> getCipherSuiteItems() {
        if (!this.foxService.getFoxsEnabled()) {
            return Collections.emptyList();
        }
        BTlsCipherSuiteGroup cipherSuite = this.foxService.getCipherSuiteGroup();
        BSecurityItemStatus status = cipherSuite.equals((Object)BTlsCipherSuiteGroup.recommended) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
        return Collections.singletonList(this.builder.make(status).withSummary(CIPHER_SUITE_SUMMARY, new Object[]{cipherSuite}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
    }

    private List<SecurityDashboardItem> getCertificateItems() {
        ArrayList<SecurityDashboardItem> items;
        block23: {
            if (!this.foxService.getFoxsEnabled()) {
                return Collections.emptyList();
            }
            items = new ArrayList<SecurityDashboardItem>();
            String foxsCert = this.foxService.getCertAliasAndPassword().getAlias();
            BServerCertificateHealth health = this.foxService.getServerCertificateHealth();
            switch (health.getCertStatus().getOrdinal()) {
                case 0: {
                    items.add(this.builder.makeOk().withSummary("securityDashboard.certHealth.ok", new Object[]{health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 1: {
                    items.add(this.builder.makeAlert().withSummary("securityDashboard.certHealth.badPassword", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 2: {
                    items.add(this.builder.makeAlert().withSummary("securityDashboard.certHealth.badKey", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 3: {
                    items.add(this.builder.makeAlert().withSummary("securityDashboard.certHealth.missingKey", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 4: {
                    items.add(this.builder.makeAlert().withSummary("securityDashboard.certHealth.badDefault", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 5: {
                    items.add(this.builder.makeOk().withSummary("securityDashboard.certHealth.okIncompleteChain", new Object[]{health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                }
            }
            try {
                X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(foxsCert);
                try {
                    certificate.checkValidity();
                    if (BFoxServiceSecurityDashboardProviderAgent.isNearExpiration(certificate)) {
                        items.add(this.builder.makeWarning().withSummary(CERT_NEAR_EXPIRY_SUMMARY, new Object[]{foxsCert, certificate.getNotAfter()}).withDescription(CERT_NEAR_EXPIRY_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeOk().withSummary(CERT_IN_VALIDITY_PERIOD_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_IN_VALIDITY_PERIOD_DESCRIPTION, new Object[0]));
                    }
                }
                catch (CertificateExpiredException e) {
                    items.add(this.builder.makeAlert().withSummary(CERT_EXPIRED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_EXPIRED_DESCRIPTION, new Object[0]));
                }
                catch (CertificateNotYetValidException e) {
                    items.add(this.builder.makeAlert().withSummary(CERT_NOT_YET_VALID_SUMMARY, new Object[]{foxsCert, certificate.getNotBefore()}).withDescription(CERT_NOT_YET_VALID_DESCRIPTION, new Object[0]));
                }
                if (BFoxServiceSecurityDashboardProviderAgent.isSelfSigned(certificate)) {
                    if ("default".equalsIgnoreCase(foxsCert)) {
                        items.add(this.builder.makeWarning().withSummary(CERT_DEFAULT_SUMMARY, new Object[0]).withDescription(CERT_DEFAULT_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeWarning().withSummary(CERT_SELF_SIGNED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_SELF_SIGNED_DESCRIPTION, new Object[0]));
                    }
                } else {
                    items.add(this.builder.makeOk().withSummary(CERT_NOT_SELF_SIGNED_SUMMARY, new Object[]{foxsCert}).withDescription(CERT_NOT_SELF_SIGNED_DESCRIPTION, new Object[0]));
                }
                try {
                    ICoreKeyStore keyStore = (ICoreKeyStore)CertManagerFactory.getInstance().getKeyStore();
                    if (CertUtils.isPrivateKeyGloballyEncrypted((String)foxsCert, (ICoreKeyStore)keyStore)) {
                        items.add(this.builder.makeWarning().withSummary(GLOBAL_ENCRYPTED_CERT_SUMMARY, new Object[]{foxsCert}).withDescription(ENCRYPTED_CERT_DESCRIPTION, new Object[0]));
                        break block23;
                    }
                    items.add(this.builder.makeOk().withSummary(UNIQUE_ENCRYPTED_CERT_SUMMARY, new Object[]{foxsCert}).withDescription(ENCRYPTED_CERT_DESCRIPTION, new Object[0]));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "unable to check private key for password", e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return items;
    }

    private List<SecurityDashboardItem> getTraceItems() {
        ArrayList<String> tracePropertiesList = new ArrayList<String>();
        for (String prop : TRACE_PROPERTIES) {
            if (!BBoolean.TRUE.equals((Object)this.foxService.get(prop))) continue;
            tracePropertiesList.add(prop);
        }
        if (tracePropertiesList.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.builder.makeWarning().withSummary(TRACE_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", tracePropertiesList)}).withDescription(TRACE_ENABLED_DESCRIPTION, new Object[0]));
    }

    private List<SecurityDashboardItem> getLegacyConnectionItems() {
        String summary = null;
        BSecurityItemStatus status = null;
        switch (this.foxService.getSupportLegacyClients().getOrdinal()) {
            case 0: {
                if (this.legacyEnabledByDefault) {
                    summary = LEGACY_CLIENTS_DEFAULT_YES_SUMMARY;
                    status = BSecurityItemStatus.securityStatusWarning;
                    break;
                }
                summary = LEGACY_CLIENTS_DEFAULT_NO_SUMMARY;
                status = BSecurityItemStatus.securityStatusOK;
                break;
            }
            case 1: {
                summary = LEGACY_CLIENTS_DISABLED_SUMMARY;
                status = BSecurityItemStatus.securityStatusOK;
                break;
            }
            case 2: {
                summary = LEGACY_CLIENTS_ENABLED_SUMMARY;
                status = BSecurityItemStatus.securityStatusAlert;
            }
        }
        return Collections.singletonList(this.builder.make(status, summary, LEGACY_CLIENTS_DESCRIPTION));
    }

    private static boolean isNearExpiration(X509Certificate certificate) {
        return (double)(certificate.getNotAfter().getTime() - new Date().getTime()) < CERT_EXPIRY_WARNING_MILLIS;
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        return CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal());
    }
}

