/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.search.ui;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.fx.BFxWidget;
import com.tridium.ui.fx.FxUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.EnumSet;
import java.util.WeakHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.search.BSearchService;
import javax.baja.security.BPermissions;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.menu.BIQuickSearch;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"workbench:WbProfile"})})
public final class BFxQuickSearch
extends BFxWidget
implements BIQuickSearch {
    @Generated
    public static final Type TYPE = Sys.loadType(BFxQuickSearch.class);
    private static final Lexicon lex = Lexicon.make((String)"search");
    private static final WeakHashMap<BWidgetShell, BFxQuickSearch> quickSearchMap = new WeakHashMap();
    private static final String newSearchWebProperty = "newQuickSearchSubmission";
    private StackPane pane = new StackPane();
    private TextField queryField = new TextField();
    private ImageView searchIcon = FxUtil.getImage((String)"magnifyingGlass");
    private BWbShell shell;
    private TabSubscriber tabSubscriber = new TabSubscriber();
    private EnumSet<KeyCode> keysPressed = EnumSet.noneOf(KeyCode.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Node createNode() {
        if (this.pane.getChildren().isEmpty()) {
            this.queryField.setPrefSize(205.0, 20.0);
            this.queryField.setMinHeight(20.0);
            this.queryField.setPromptText(lex.getText("QuickSearch.defaultText"));
            this.queryField.setFocusTraversable(true);
            this.queryField.focusedProperty().addListener((observable, wasFocused, isFocused) -> {
                if (!isFocused.booleanValue() && !this.keysPressed.isEmpty()) {
                    this.shell.getShellManager().enableInput();
                    this.keysPressed.clear();
                }
            });
            this.queryField.setOnKeyReleased(keyEvent -> {
                this.keysPressed.remove(keyEvent.getCode());
                if (this.keysPressed.isEmpty()) {
                    this.shell.getShellManager().enableInput();
                }
            });
            this.queryField.setOnKeyPressed(keyEvent -> {
                if (this.keysPressed.isEmpty()) {
                    this.shell.getShellManager().disableInput();
                }
                this.keysPressed.add(keyEvent.getCode());
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    String searchOrd = "service:search:SearchService|view:search:SearchWidget?query=" + SlotPath.escape((String)this.queryField.getText());
                    BOrd ord = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)searchOrd);
                    BWidget.invokeLater(() -> {
                        BViewTab tab;
                        this.tabSubscriber.unsubscribeAll();
                        if (this.shell instanceof BNiagaraWbShell && (tab = ((BNiagaraWbShell)this.shell).tab()) != null) {
                            BWbView view = tab.getView();
                            if (view instanceof BWebWidget) {
                                BFxQuickSearch.setNewSearchProperty((BWebWidget)view);
                                this.tabSubscriber.subscribe((BComponent)view);
                            }
                            this.tabSubscriber.subscribe((BComponent)tab);
                        }
                        this.shell.hyperlink(ord);
                    });
                    this.pane.requestFocus();
                }
            });
            StackPane.setAlignment((Node)this.searchIcon, (Pos)Pos.CENTER_LEFT);
            StackPane.setMargin((Node)this.searchIcon, (Insets)new Insets(0.0, 0.0, 0.0, 7.0));
            this.pane.getChildren().addAll((Object[])new Node[]{this.queryField, this.searchIcon});
        }
        return this.pane;
    }

    public boolean isQuickSearchEnabled(BWidget view) {
        if (!(view instanceof BWbEditor)) {
            return false;
        }
        try {
            FoxSession foxSession;
            BFoxClientConnection connection;
            BISession session = ((BWbEditor)view).getCurrentValueSession();
            if (session != null && session instanceof BFoxSession && (connection = ((BFoxSession)session).getConnection()) != null && (foxSession = connection.session()) != null) {
                return (Boolean)foxSession.getFromCache("isQuickSearchEnabled", key -> {
                    OrdTarget searchTarget = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"service:search:SearchService").resolve((BObject)session);
                    BPermissions permissions = searchTarget.getPermissionsForTarget();
                    if (permissions.hasOperatorInvoke() && permissions.hasOperatorRead()) {
                        BSearchService searchService = (BSearchService)searchTarget.get();
                        searchService.lease();
                        return searchService.isOperational();
                    }
                    return false;
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWidget asGlobalWidget(BWidget view, String id) {
        BFxQuickSearch quickSearchWidget;
        WeakHashMap<BWidgetShell, BFxQuickSearch> weakHashMap = quickSearchMap;
        synchronized (weakHashMap) {
            quickSearchWidget = quickSearchMap.get(view.getShell());
            if (quickSearchWidget == null) {
                quickSearchWidget = new BFxQuickSearch();
                quickSearchMap.put(view.getShell(), quickSearchWidget);
            }
            quickSearchWidget.shell = BWbShell.getWbShell((BWidget)view);
            quickSearchWidget.pane.setId(id + "-container");
            quickSearchWidget.queryField.setId(id);
            quickSearchWidget.searchIcon.setId(id + "-icon");
        }
        return quickSearchWidget;
    }

    private static void setNewSearchProperty(BWebWidget widget) {
        Property prop = widget.getProperty(newSearchWebProperty);
        if (prop != null) {
            widget.set(prop, (BValue)BBoolean.TRUE);
        } else {
            int flags = 0x40000007;
            widget.add(newSearchWebProperty, (BValue)BBoolean.TRUE, flags);
        }
    }

    static class TabSubscriber
    extends Subscriber {
        TabSubscriber() {
        }

        public void event(BComponentEvent event) {
            BComponent view;
            if (event.getId() == 0 && BViewTab.content.equals(event.getSlot())) {
                BValue content;
                BComponent tab = event.getSourceComponent();
                if (tab != null && (content = tab.get(BViewTab.content)) instanceof BWebWidget) {
                    BFxQuickSearch.setNewSearchProperty((BWebWidget)content);
                    this.unsubscribeAll();
                }
            } else if (event.getId() == 2 && BFxQuickSearch.newSearchWebProperty.equals(event.getSlotName()) && (view = event.getSourceComponent()) instanceof BWebWidget) {
                BFxQuickSearch.setNewSearchProperty((BWebWidget)view);
                this.unsubscribeAll();
            }
        }
    }
}

