/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.nre.util.NUserAgent;
import java.util.ArrayList;
import java.util.Objects;
import javax.baja.util.Version;
import javax.servlet.http.HttpServletRequest;

public class UserAgent {
    private final String value;
    private final Product product;
    private final Product[] products;
    private final String[] comments;
    public static final String MSIE = "MSIE";
    public static final String MOZILLA = "Mozilla";
    private static final String AX_WEBSTART = "niagaraax/webstart";
    private static final String N4_WEBSTART = "niagara4/webstart";
    private static final String NIAGARA_WEB_LAUNCHER = "niagara/weblauncher";
    private static final Product[] PRODUCT_ARRAY_DEFINITION = new Product[0];

    public UserAgent(String value) {
        this.value = value;
        NUserAgent nuserAgent = new NUserAgent(value);
        this.product = new Product(nuserAgent.getProduct());
        ArrayList<Product> products = new ArrayList<Product>();
        for (NUserAgent.NProduct coreNProduct : nuserAgent.getProducts()) {
            products.add(new Product(coreNProduct));
        }
        this.products = products.toArray(PRODUCT_ARRAY_DEFINITION);
        this.comments = (String[])nuserAgent.getComments().clone();
    }

    public static Product parseProduct(String token) {
        return new Product(NUserAgent.parseProduct((String)token));
    }

    @Deprecated
    public boolean isIE() {
        return this.getProduct().isIE();
    }

    public boolean isMozilla() {
        return this.getProduct().isMozilla();
    }

    @Deprecated
    public boolean isNiagaraAxWebStart() {
        return this.value.toLowerCase().contains(AX_WEBSTART);
    }

    @Deprecated
    public static boolean isNiagaraAxWebStart(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, AX_WEBSTART);
    }

    @Deprecated
    public boolean isNiagara4WebStart() {
        return this.value.toLowerCase().contains(N4_WEBSTART);
    }

    @Deprecated
    public static boolean isNiagara4WebStart(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, N4_WEBSTART);
    }

    @Deprecated
    public boolean isNiagaraWebLauncher() {
        return this.value.toLowerCase().contains(NIAGARA_WEB_LAUNCHER);
    }

    @Deprecated
    public static boolean isNiagaraWebLauncher(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, NIAGARA_WEB_LAUNCHER);
    }

    private static boolean hasUserAgent(HttpServletRequest req, String agentId) {
        String header = req.getHeader("User-Agent");
        return header != null ? header.toLowerCase().contains(agentId) : false;
    }

    public Product getProduct() {
        return this.product;
    }

    public Product[] getProducts() {
        return (Product[])this.products.clone();
    }

    public String[] getComments() {
        return (String[])this.comments.clone();
    }

    public String toString() {
        return this.value;
    }

    public void dump() {
        System.out.println("User-Agent: " + this.value);
        System.out.println("  Primary Product: " + this.product);
        System.out.println("  Products:");
        for (Product item : this.products) {
            System.out.println("    " + item);
        }
        System.out.println("  Comments:");
        for (String comment : this.comments) {
            System.out.println("    " + (String)comment);
        }
    }

    public static class Product {
        private final NUserAgent.NProduct nproduct;

        public Product(String name, String versionString, Version version) {
            this.nproduct = new NUserAgent.NProduct(name, versionString, new com.tridium.nre.util.Version(version.toString()));
        }

        private Product(NUserAgent.NProduct nproduct) {
            this.nproduct = nproduct;
        }

        @Deprecated
        public boolean isIE() {
            return this.nproduct.getName().equals(UserAgent.MSIE);
        }

        public boolean isMozilla() {
            return this.nproduct.getName().equals(UserAgent.MOZILLA);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Product product = (Product)obj;
            return Objects.equals(product.nproduct, this.nproduct);
        }

        public int hashCode() {
            return Objects.hash(this.nproduct);
        }

        public String toString() {
            if (this.nproduct.getVersionString() == null) {
                return this.nproduct.getName();
            }
            if (this.nproduct.getVersion() == null) {
                return this.nproduct.getName() + '/' + this.nproduct.getVersionString();
            }
            return this.nproduct.getName() + '/' + this.nproduct.getVersion();
        }
    }
}

