/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeConfig;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.web.BIWebProfile;

@NiagaraType(agent={@AgentOn(types={"baja:User", "baja:UserPrototype"})})
public class BWebProfileConfig
extends BTypeConfig
implements BIMixIn {
    @Generated
    public static final Type TYPE = Sys.loadType(BWebProfileConfig.class);
    static final BTypeSpec DEFAULT_TYPE_SPEC = BTypeSpec.make((String)"hx:HTML5HxProfile");
    private static boolean loggedMobileRemoval = false;
    private static final Logger LOGGER = Logger.getLogger("web");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWebProfileConfig() {
        this.setTypeSpec(DEFAULT_TYPE_SPEC);
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("webProfileConfig");
    }

    protected void typeConfigStarted() {
        String typeSpec = this.getTypeSpec().toString();
        if (typeSpec.equals("mobile:DefaultMobileWebProfile")) {
            this.setTypeSpec(DEFAULT_TYPE_SPEC);
            BTypeSpec theme = (BTypeSpec)this.get("theme");
            if (theme != null) {
                this.remove("theme");
            }
            if (!loggedMobileRemoval) {
                loggedMobileRemoval = true;
                LOGGER.log(Level.WARNING, "Support for the \"Default Mobile Web Profile\" has been removed. Users with this profile have been switched to the \"Html5 Hx Profile\".");
            }
        }
    }

    public void changed(Property prop, Context cx) {
        if (prop.getType().is(BDynamicEnum.TYPE) && prop.getName().toLowerCase().contains("theme")) {
            this.updateModuleDependencies(false);
        }
        super.changed(prop, cx);
    }

    public TypeInfo getTargetType() {
        return BIWebProfile.TYPE.getTypeInfo();
    }

    public String toString(Context cx) {
        try {
            return this.getTypeSpec().getTypeInfo().getDisplayName(cx);
        }
        catch (Exception e) {
            return this.getTypeSpec().toString(cx);
        }
    }

    public BIWebProfile makeWebProfile() {
        return (BIWebProfile)this.make();
    }
}

