/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.stub;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.baja.nre.util.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class StubHttpServletResponse
implements HttpServletResponse {
    private ByteBuffer buf;
    private ServletOutputStream out;
    private PrintWriter pw;
    private Map<String, Object> headerMap;
    private int status = 200;
    private String statusMessage;
    private String charset = "UTF-8";

    public StubHttpServletResponse() {
        this.reset();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return this.pw;
    }

    public void flushBuffer() throws IOException {
        this.out.flush();
    }

    public String toString() {
        return new String(this.buf.toByteArray());
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }

    public void setHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headerMap.containsKey(name);
    }

    public void addHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public String getHeader(String name) {
        if (!this.containsHeader(name)) {
            return null;
        }
        return this.headerMap.get(name).toString();
    }

    public Collection<String> getHeaders(String s) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getHeaderNames() {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, Long.toString(date));
    }

    public void addDateHeader(String name, long date) {
        this.setDateHeader(name, date);
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        this.status = sc;
        this.statusMessage = sm;
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc, msg);
    }

    public void setContentLength(int len) {
        this.setHeader("Content-Length", Integer.toString(len));
    }

    public void setContentLengthLong(long len) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.headerMap = new HashMap<String, Object>();
        this.buf = new ByteBuffer(1024);
        this.out = new ServletOutputStream(){

            public void write(int b) throws IOException {
                StubHttpServletResponse.this.buf.getOutputStream().write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        };
        this.pw = new PrintWriter((OutputStream)this.out);
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public boolean isCommitted() {
        return false;
    }

    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeUrl(String url) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException();
    }
}

