/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.net.HttpUtil;
import com.tridium.security.UrlWhitelist;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.Template;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.WbServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.file.BFileScheme;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.io.HtmlWriter;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.naming.BLocalScheme;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.BWebStartConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebStartServlet
extends HttpServlet {
    private static final String[] UNAUTHENTICATED_URI_WHITELIST = new String[]{"/webstart/webstartparams", "/webstart/nwl", "/webstart/nwl_download", "/webstart/launcher.nwl", "/webstart/shortcut-icon", "/webstart/app-icon", "/webstart/NiagaraWebLauncher.msi"};
    private static final Pattern JNLP_REDIRECT_PATTERN = Pattern.compile("^/webstart/jnlp_redirect/[\\S&&[^\\\\/\\.]]+\\.jnlp$");
    private static final Pattern WBLITE_REDIRECT_PATTERN = Pattern.compile("^/webstart/nwl_redirect/[\\S&&[^\\\\/\\.]]+\\.nwl$");
    private static final Pattern JX_BROWSER_FILENAME_PATTERN = Pattern.compile("^jxbrowser-((?:[a-zA-Z0-9]+)-){0,1}([0-9]+\\.{1})+jar$");
    static Logger log = Logger.getLogger("web.webstart");
    private boolean licenseWb;
    private static long jnlpTimestamp = System.currentTimeMillis();
    private static final String HTTP_CONNECT_TIMEOUT = AccessController.doPrivileged(() -> System.getProperty("niagara.applet.httpConnectTimeout", "60000"));
    private static final String DEFAULT_READ_TIMEOUT = AccessController.doPrivileged(() -> System.getProperty("niagara.applet.defaultReadTimeout", "60000"));
    private static final String BROWSER_FILE_EXTS = AccessController.doPrivileged(() -> System.getProperty("niagara.webstart.browserFileExts", "pdf"));
    private static final String JX_BROWSER_LOG_LEVEL = AccessController.doPrivileged(() -> System.getProperty("niagara.jxbrowser.log", "OFF"));
    private static final String DEFAULT_NWL_DOWNLOAD_URL = "https://weblauncher.niagara-central.com";
    private static final String NWL_MSI = "NiagaraWebLauncher.msi";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        BWebService webService = WebStartServlet.getWebService();
        try {
            if (webService != null) {
                Feature feature = webService.getLicenseFeature();
                this.licenseWb = feature.getb("ui.wb", false);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error initializing WebStartServlet", ex);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block20: {
            boolean webLauncherEnabled;
            String uri = req.getRequestURI();
            BWebStartConfig webLauncherConfig = WebStartServlet.getWebLauncherConfig();
            boolean bl = webLauncherEnabled = webLauncherConfig != null && webLauncherConfig.getWebStartEnabled();
            if ("/webstart/webstartparams".equals(uri)) {
                if (!webLauncherEnabled) {
                    this.sendStatusWithMessage(req, resp, 403, "webLauncher.notEnabled");
                }
                if (!this.licenseWb) {
                    this.sendStatusWithMessage(req, resp, 403, "webLauncher.notLicensed");
                } else {
                    this.getInitialWebStartParameters(req, resp);
                }
                return;
            }
            if (!this.licenseWb || !webLauncherEnabled) {
                resp.sendError(403);
                return;
            }
            if ("/webstart/nwl_download".equals(uri)) {
                this.getWbliteRedirectForHost(req, resp);
            } else if (uri.startsWith("/webstart/nwl_redirect/")) {
                this.generateWbLiteFileForWebStartApp(req, resp);
            } else if ("/webstart/shortcut-icon".equals(uri)) {
                this.getShortcutIcon(resp);
            } else if ("/webstart/app-icon".equals(uri)) {
                this.getBrandAppIcon(resp);
            } else if ("/webstart/nwl".equals(uri) || "/webstart/launcher.nwl".equals(uri)) {
                this.generateWbLiteDownloadPage(req, resp);
            } else if (uri.equals("/webstart/NiagaraWebLauncher.msi")) {
                try {
                    String downloadLink = this.getNWLInstallLink(req);
                    if (downloadLink.startsWith("file:/")) {
                        this.sendFile(resp, (BIFile)BOrd.make((String)downloadLink).resolve().get());
                        break block20;
                    }
                    resp.sendRedirect(downloadLink);
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Cannot obtain Niagara Web Launcher executable", e);
                    resp.sendRedirect("www.niagara-central.com");
                }
            } else {
                resp.sendError(404);
            }
        }
    }

    private String getNWLInstallLink(HttpServletRequest req) throws Exception {
        String defaultDownloadUrl = new URL(new URL(DEFAULT_NWL_DOWNLOAD_URL), NWL_MSI).toString();
        String nwlDownloadHost = AccessController.doPrivileged(() -> System.getProperty("niagara.webLauncher.installer.downloadURL"));
        if (nwlDownloadHost != null) {
            return new URL(new URL(nwlDownloadHost), NWL_MSI).toString();
        }
        return defaultDownloadUrl;
    }

    private void sendStatusWithMessage(HttpServletRequest req, HttpServletResponse resp, int sc, String lexKey) throws IOException {
        String txt = Lexicon.make((String)"web", (Context)new WebStartJnlpContext(req)).get(lexKey);
        PrintWriter pw = resp.getWriter();
        pw.write(txt);
        pw.close();
        resp.setStatus(sc);
    }

    public void getWbliteRedirectForHost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirect = WebStartServlet.getWbLiteStationRedirectPath();
        String query = req.getQueryString();
        if (query != null) {
            redirect = redirect + "?" + query;
        }
        resp.setContentType("application/x-niagara-weblauncher");
        resp.sendRedirect(WebUtil.getRedirect(req, redirect));
    }

    public static String getWbLiteStationRedirectPath() {
        return "/webstart/nwl_redirect/" + Sys.getStation().getStationName() + ".nwl";
    }

    private String getCodeBaseHref(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        sb.append(scheme).append("://");
        sb.append(req.getServerName());
        if (scheme.equalsIgnoreCase("https") && port != 443 || scheme.equalsIgnoreCase("http") && port != 80) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }

    public static String getAppletHref() {
        String appletVersion = BModule.getClassVersion(WbServlet.class).toString();
        return "/wb/wbapplet-" + appletVersion + ".jar";
    }

    public void generateWbLiteFileForWebStartApp(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (HtmlWriter out = new HtmlWriter((Writer)resp.getWriter());){
            long lastMod = WebStartServlet.getJnlpModificationDate();
            long ifMod = req.getDateHeader("If-Modified-Since");
            if (req.getQueryString() == null && ifMod != -1L && lastMod <= ifMod) {
                resp.sendError(304);
                return;
            }
            JnlpOptions opts = JnlpOptions.instance();
            String vmArgs = opts.getJavaVmOptions();
            resp.setCharacterEncoding("UTF-8");
            out.write("host=" + this.getCodeBaseHref(req));
            out.write("\n");
            if (req.getQueryString() != null) {
                HttpHeaderUtil.neverCache(resp);
            }
            resp.setDateHeader("Last-Modified", WebStartServlet.getJnlpModificationDate());
            resp.setContentType("application/x-niagara-weblauncher");
            resp.setStatus(200);
        }
    }

    private static long getJnlpModificationDate() {
        return jnlpTimestamp / 1000L * 1000L;
    }

    public static void onWebStartConfigChanged() {
        jnlpTimestamp = System.currentTimeMillis();
    }

    private void getShortcutIcon(HttpServletResponse resp) throws IOException, ServletException {
        resp.addHeader("Cache-Control", "no-cache, no-store");
        this.sendImageFile(JnlpOptions.instance().getShortcutIconOrd(), resp);
    }

    private void getBrandAppIcon(HttpServletResponse resp) throws IOException, ServletException {
        JnlpOptions opts = JnlpOptions.instance();
        if (!opts.hasBrandAppIcon()) {
            resp.sendError(404);
            return;
        }
        resp.addHeader("Cache-Control", "no-cache, no-store");
        this.sendImageFile(opts.getBrandAppIconOrd(), resp);
    }

    private void sendImageFile(String str, HttpServletResponse resp) throws IOException, ServletException {
        BOrd ord = BOrd.make((String)str).normalize();
        if (!ord.isNull()) {
            BIFile file;
            OrdQuery[] queries = ord.parse();
            boolean hasModuleQuery = false;
            boolean hasRemoteQuery = false;
            boolean hasUnexpectedQuery = false;
            boolean hasValidFileQuery = false;
            for (OrdQuery query : queries) {
                if (BModuleScheme.INSTANCE.getId().equals(query.getScheme())) {
                    hasModuleQuery = true;
                    continue;
                }
                if (BFileScheme.INSTANCE.getId().equals(query.getScheme())) {
                    FilePath path = (FilePath)query;
                    if (this.isValidImageDirectory(path)) {
                        hasValidFileQuery = true;
                        continue;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Forbidden file path for web start brand image: " + path);
                    continue;
                }
                if (query.isHost()) {
                    if (BLocalScheme.INSTANCE.getId().equals(query.getScheme())) continue;
                    hasRemoteQuery = true;
                    continue;
                }
                hasUnexpectedQuery = true;
            }
            if ((hasModuleQuery || hasValidFileQuery) && !hasRemoteQuery && !hasUnexpectedQuery && (file = this.resolveImageFile(ord)) != null) {
                this.sendFile(resp, file);
                return;
            }
        }
        resp.sendError(404);
    }

    private void sendFile(HttpServletResponse resp, BIFile file) throws IOException, ServletException {
        try {
            resp.setContentType(file.getMimeType());
            AccessController.doPrivileged(() -> {
                try (InputStream in = file.getInputStream();
                     ServletOutputStream out = resp.getOutputStream();){
                    BajaFileUtil.pipe((InputStream)in, (OutputStream)out);
                }
                catch (Exception e) {
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Failed to send web start image", e);
                        }
                        resp.sendError(404);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WebUtil.handleServletPrivilegedException(e);
        }
    }

    private BIFile resolveImageFile(BOrd ord) {
        block5: {
            try {
                BIFile file = (BIFile)ord.resolve().get();
                if (!file.isDirectory() && this.isValidImageFileType(file)) {
                    return file;
                }
            }
            catch (UnresolvedException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Could not resolve brand image ord for web start: " + ord.toDebugString());
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block5;
                log.log(Level.FINE, "Error getting brand image for web start.", e);
            }
        }
        return null;
    }

    private boolean isValidImageDirectory(FilePath path) {
        String[] names;
        return path.isSysHomeAbsolute() && (names = path.getNames()).length == 3 && "workbench".equals(names[0]) && "webstart".equals(names[1]);
    }

    private boolean isValidImageFileType(BIFile file) {
        String mimeType = file.getMimeType();
        return "image/gif".equals(mimeType) || "image/png".equals(mimeType) || "image/x-icon".equals(mimeType) || "image/jpeg".equals(mimeType);
    }

    private void getInitialWebStartParameters(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        JnlpOptions.instance().loadBrandOptions();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("ISO-8859-1");
        Properties props = new Properties();
        try (ServletOutputStream out = resp.getOutputStream();){
            props.setProperty("httpConnectTimeout", HTTP_CONNECT_TIMEOUT);
            props.setProperty("defaultReadTimeout", DEFAULT_READ_TIMEOUT);
            props.setProperty("browserFileExts", BROWSER_FILE_EXTS);
            String logo = WebUtil.getLogo(WebStartServlet.getWebService());
            if (logo != null) {
                props.setProperty("logo", "ord?" + logo);
            }
            if (this.useJxBrowser()) {
                props.setProperty("jxbrowserEnabled", "true");
                props.setProperty("jxbrowserLogLevel", JX_BROWSER_LOG_LEVEL);
            }
            JnlpOptions options = JnlpOptions.instance();
            String appIconOrd = options.getBrandAppIconOrd();
            props.setProperty("appTitle", options.getAppTitle());
            props.setProperty("appIcon", appIconOrd != null ? appIconOrd : "");
            props.setProperty("urlWhitelist", UrlWhitelist.getConfiguredWhitelist());
            props.store((OutputStream)out, "");
        }
    }

    public static boolean matchDeferredAuthRequest(String uri) {
        for (String s : UNAUTHENTICATED_URI_WHITELIST) {
            if (!s.equals(uri)) continue;
            return true;
        }
        return JNLP_REDIRECT_PATTERN.matcher(uri).matches() || WBLITE_REDIRECT_PATTERN.matcher(uri).matches();
    }

    private boolean useJxBrowser() {
        if (!WbServlet.disableJxBrowser) {
            boolean hasLocalJxJars = WbServlet.hasLocalJxJars();
            return hasLocalJxJars;
        }
        return false;
    }

    public static boolean isJxBrowserJarRequest(String uri) {
        String prefix = "/wb/bin/ext/jxbrowser/";
        if (uri.startsWith("/wb/bin/ext/jxbrowser/")) {
            String file = uri.substring("/wb/bin/ext/jxbrowser/".length());
            return "runtime.jar".equals(file) || JX_BROWSER_FILENAME_PATTERN.matcher(file).matches();
        }
        return false;
    }

    private void generateWbLiteDownloadPage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Lexicon lex = Lexicon.make((String)"web", (Context)new WebStartJnlpContext(req));
        try (PrintWriter out = resp.getWriter();){
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/html");
            HashMap<String, String> templateParams = new HashMap<String, String>();
            templateParams.put("title", lex.getHtmlSafeText("nwl.title"));
            BWebService webService = WebStartServlet.getWebService();
            if (null != webService && webService.get("loginCss") != null) {
                templateParams.put("loginCss", Template.process(BOrd.make((String)"module://web/com/tridium/web/rc/loginCssN4.vm"), true));
            } else {
                templateParams.put("loginCss", "");
            }
            templateParams.put("downloadMsg", lex.getHtmlSafeText("nwl.download.getFile"));
            templateParams.put("getFile", lex.getHtmlSafeText("nwl.download.getFileLink"));
            String externalLink = "/webstart/NiagaraWebLauncher.msi";
            String wbLiteExternalAnchor = "<a id=\"niagara_webLauncherExternalLink\" href=\"" + externalLink + "\">" + lex.getHtmlSafe("nwl.link.installer") + "</a>";
            templateParams.put("getNWL", lex.getHtmlSafeText("nwl.download.getNWL", new Object[]{" "}) + wbLiteExternalAnchor);
            templateParams.put("runFile", lex.getHtmlSafeText("nwl.download.runFile"));
            templateParams.put("closeBrowser", lex.getHtmlSafeText("nwl.download.closeBrowser"));
            BOrd template = BOrd.make((String)"module://web/com/tridium/web/rc/wbliteDownloadN4.vm");
            out.print(Template.process(templateParams, template));
        }
    }

    public static String makeWebStartJnlpPath(String initialPath) {
        return "/webstart/wbwebstart.jnlp?path=" + HttpUtil.encodeUrl((String)initialPath);
    }

    public static String makeWbLitePath(String initialPath) {
        return "/webstart/launcher.nwl?path=" + HttpUtil.encodeUrl((String)initialPath);
    }

    private static BWebStartConfig getWebLauncherConfig() {
        BWebService webService = WebStartServlet.getWebService();
        if (webService == null) {
            return null;
        }
        return webService.getWebStartConfig();
    }

    private static BWebService getWebService() {
        try {
            return (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException svcEx) {
            log.log(Level.SEVERE, "WebService not found", svcEx);
            return null;
        }
    }

    private static class WebStartJnlpContext
    implements Context {
        String lang;

        public WebStartJnlpContext(HttpServletRequest req) {
            this.lang = req.getLocale().toString();
        }

        public String getLanguage() {
            return this.lang;
        }

        public BObject getFacet(String s) {
            return null;
        }

        public BFacets getFacets() {
            return null;
        }

        public BUser getUser() {
            return null;
        }

        public Context getBase() {
            return null;
        }
    }

    private static class JnlpOptions {
        private String vmArgs;
        private String appTitle;
        private String shortcutIcon;
        private String appIcon;
        private String brandVendor;
        private static final String DEFAULT_APP_TITLE = "Niagara Web Start";
        private static final String DEFAULT_SHORTCUT_ICON = "module://icons/x32/workbench.png";
        private static final String DEFAULT_VENDOR = "Tridium";

        static JnlpOptions instance() {
            return JnlpOptionsHolder.INSTANCE;
        }

        private String getAppTitle() {
            return this.appTitle;
        }

        private String getJavaVmOptions() {
            return this.vmArgs;
        }

        private String getShortcutIconOrd() {
            return this.shortcutIcon;
        }

        private String getBrandVendor() {
            return this.brandVendor;
        }

        private boolean hasBrandAppIcon() {
            return this.appIcon != null;
        }

        private String getBrandAppIconOrd() {
            return this.appIcon;
        }

        private JnlpOptions() {
            try {
                this.loadVmOptions();
                this.loadBrandOptions();
            }
            catch (IOException | ServletException e) {
                log.log(Level.WARNING, "Failed to read Web Start JNLP options.", e);
            }
        }

        private void loadVmOptions() throws IOException, ServletException {
            try {
                AccessController.doPrivileged(() -> {
                    block14: {
                        try {
                            File file = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "nre.properties");
                            if (!file.exists()) break block14;
                            Properties nreProperties = new Properties();
                            try (FileInputStream in = new FileInputStream(file);){
                                nreProperties.load(in);
                            }
                            this.vmArgs = nreProperties.getProperty("webstart.java.options", null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                WebUtil.handleServletPrivilegedException(e);
            }
        }

        private void loadBrandOptions() throws IOException, ServletException {
            this.appTitle = DEFAULT_APP_TITLE;
            this.shortcutIcon = DEFAULT_SHORTCUT_ICON;
            this.brandVendor = DEFAULT_VENDOR;
            try {
                AccessController.doPrivileged(() -> {
                    block17: {
                        try {
                            File file = new File(Nre.getNiagaraHome(), "etc" + File.separator + "brand.properties");
                            if (!file.exists()) break block17;
                            Properties brandProperties = new Properties();
                            try (FileInputStream in = new FileInputStream(file);){
                                brandProperties.load(in);
                            }
                            String stationName = Sys.getStation().getStationName();
                            this.appTitle = brandProperties.getProperty("webstart.title", !stationName.equals("") ? stationName : DEFAULT_APP_TITLE);
                            this.shortcutIcon = brandProperties.getProperty("webstart.shortcut.icon", DEFAULT_SHORTCUT_ICON);
                            this.appIcon = brandProperties.getProperty("webstart.icon", null);
                            this.brandVendor = brandProperties.getProperty("webstart.vendor", null);
                            if (this.brandVendor != null) break block17;
                            try {
                                this.brandVendor = Brand.getBrandId();
                            }
                            catch (FeatureNotLicensedException | LicenseDatabaseException throwable) {
                                // empty catch block
                            }
                            if (this.brandVendor == null) {
                                this.brandVendor = brandProperties.getProperty("brand.id", DEFAULT_VENDOR);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                WebUtil.handleServletPrivilegedException(e);
            }
        }

        private static class JnlpOptionsHolder {
            private static final JnlpOptions INSTANCE = new JnlpOptions();

            private JnlpOptionsHolder() {
            }
        }
    }
}

