/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.file.util.PxFileUtil;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.nre.util.Version;
import com.tridium.util.BISubstitutableOrdScheme;
import com.tridium.util.PxUtil;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BServletView;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebDev;
import javax.baja.web.WebOp;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.JsInfo;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ViewAllOrdServlet
extends HttpServlet {
    private static TypeInfo hxViewType = PxUtil.typeInfo((String)"hx:HxView");
    private static TypeInfo hxPxViewType = PxUtil.typeInfo((String)"hx:HxPxView");
    private static TypeInfo widgetType = PxUtil.typeInfo((String)"bajaui:Widget");
    private static TypeInfo wbViewType = PxUtil.typeInfo((String)"workbench:WbView");
    private static TypeInfo uxBuilderViewType = PxUtil.typeInfo((String)"uxBuilder:UxBuilder");
    private static final TypeInfo pxViewType = BAbstractPxView.TYPE.getTypeInfo();
    private static final String UX_MEDIA_TYPE = "uxBuilder:UxMedia";
    public static final boolean PREFER_UX_MEDIA = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.preferUxMedia"));
    private static final Version version = new Version("1");
    static final Logger LOG = Logger.getLogger("web.viewAllOrdServlet");
    public static final boolean DISABLE_HYPERLINK_ORD_SUBSTITUTION = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.hyperlink.ord.substitution.disabled"));

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RestUtil util = new RestUtil(req, resp);
        if (!util.acceptJson()) {
            resp.sendError(406);
            return;
        }
        RestUtil.Accept accept = util.getJsonAccept();
        if (!(!accept.isCustomMediaType() || accept.getCustomProtocol().equals("views") && accept.getCustomVersion().equals((Object)version))) {
            resp.sendError(406);
            return;
        }
        util.respond(accept, "application/json").respondNoCache();
        WebOp op = (WebOp)((Object)req.getAttribute("niagara.op"));
        if (op == null) {
            LOG.log(Level.SEVERE, "No WebOp available");
            resp.sendError(400);
            return;
        }
        try {
            ViewAllOrdServlet.writeViewList(op, resp.getWriter());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error in writeViewList", e);
            resp.sendError(400);
        }
    }

    public static void removeDuplicateAgents(WebOp op, AgentList list) throws Exception {
        IWebEnv env = op.getWebEnv();
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            AgentInfo agent = list.get(i);
            String agentId = agent.getAgentId();
            String translatedAgentId = env.translate(op, agent).getAgentId();
            if (translatedAgentId.equals(agentId)) continue;
            for (int j = 0; j < list.size(); ++j) {
                AgentInfo other = list.get(j);
                if (i == j || !translatedAgentId.equals(other.getAgentId())) continue;
                list.remove(agent);
                continue block0;
            }
        }
    }

    public static boolean isRegisteredUxBuilderForComponent(AgentInfo agentInfo, OrdTarget target) {
        if (agentInfo instanceof PxUtil.UxBuilder) {
            return false;
        }
        return uxBuilderViewType != null && agentInfo.getAgentType().is(uxBuilderViewType) && target.get() instanceof BComponent;
    }

    public static boolean isSelectedViewId(String viewId, AgentInfo agent) {
        if (viewId == null) {
            return false;
        }
        if (agent.getAgentId().equals(viewId)) {
            return true;
        }
        return ViewAllOrdServlet.isWbViewInAgentOns(viewId, agent);
    }

    public static boolean isWbViewInAgentOns(String viewId, AgentInfo agent) {
        for (TypeInfo typeInfo : agent.getAgentOn()) {
            if (!typeInfo.toString().equals(viewId) || !typeInfo.is(wbViewType)) continue;
            return true;
        }
        return false;
    }

    public static Writer writeViewList(WebOp op, Writer writer) throws Exception {
        HttpServletRequest req = op.getRequest();
        AgentList list = (AgentList)req.getAttribute("niagara.allViewInfos");
        if (list == null) {
            throw new Exception("No views information available");
        }
        ViewAllOrdServlet.removeDuplicateAgents(op, list);
        Optional<AgentInfo> viewInfo = Optional.ofNullable((AgentInfo)req.getAttribute("niagara.viewInfo"));
        String defViewId = viewInfo.isPresent() ? viewInfo.get().getAgentId() : "";
        BOrd base = op.getOrdWithoutViewQuery();
        return ViewAllOrdServlet.writeViewList(list, base, writer, defViewId, op.getBaseOrdTarget(), (Context)op);
    }

    public static Writer writeViewList(AgentList list, BOrd base, Writer writer, String defViewId, OrdTarget target, Context cx) {
        AgentInfo agent;
        int i;
        if (target.get() instanceof BComponent) {
            list.toBottom((AgentFilter)new UxBuilderFilter());
        }
        boolean uxPxEditable = false;
        IWebEnv env = null;
        WebOp op = null;
        ViewQuery viewQuery = null;
        if (cx instanceof WebOp) {
            op = (WebOp)cx;
            viewQuery = op.getViewQuery();
            env = op.getWebEnv();
        }
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object().key("ord").value((Object)base.toString());
        out.key("list").array();
        int defaultIndex = -1;
        for (i = 0; i < list.size(); ++i) {
            String translatedAgentId;
            agent = list.get(i);
            String agentId = agent.getAgentId();
            String string = translatedAgentId = op != null ? env.translate(op, agent).getAgentId() : agentId;
            if (viewQuery != null && viewQuery.getViewId() != null && !viewQuery.getViewId().isEmpty()) {
                if (!agentId.equals(viewQuery.getViewId()) && !translatedAgentId.equals(viewQuery.getViewId())) continue;
                defaultIndex = i;
                break;
            }
            if (!agentId.equals(defViewId) && !translatedAgentId.equals(defViewId)) continue;
            defaultIndex = i;
            break;
        }
        if (defaultIndex == -1) {
            for (i = 0; i < list.size(); ++i) {
                agent = list.get(i);
                if (viewQuery != null && viewQuery.getViewId() != null && !viewQuery.getViewId().isEmpty()) {
                    if (!ViewAllOrdServlet.isSelectedViewId(viewQuery.getViewId(), agent)) continue;
                    defaultIndex = i;
                    break;
                }
                if (!ViewAllOrdServlet.isSelectedViewId(defViewId, agent)) continue;
                defaultIndex = i;
                break;
            }
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        for (i = 0; i < list.size(); ++i) {
            AgentInfo agentInfo = list.get(i);
            if (ViewAllOrdServlet.isRegisteredUxBuilderForComponent(agentInfo, target)) {
                uxPxEditable = target.getPermissionsForTarget().hasOperatorWrite();
                continue;
            }
            ViewAllOrdServlet.writeView(out, agentInfo, base, target, i == defaultIndex, cx);
        }
        out.endArray();
        if (uxPxEditable) {
            out.key("uxPxEditable").value(true);
        }
        out.endObject();
        return writer;
    }

    private static void writeView(JSONWriter out, AgentInfo agent, BOrd base, OrdTarget target, boolean isDefault, Context cx) {
        Optional substitutableOrdScheme;
        TypeInfo typeInfo = agent.getAgentType();
        String agentId = agent.getAgentId();
        boolean hx = false;
        boolean px = false;
        boolean ux = false;
        boolean wb = false;
        boolean uxBuilder = false;
        out.object();
        out.key("displayName").value((Object)agent.getDisplayName(cx));
        out.key("moduleName").value((Object)typeInfo.getModuleName());
        out.key("typeName").value((Object)typeInfo.getTypeName());
        if (!DISABLE_HYPERLINK_ORD_SUBSTITUTION && (substitutableOrdScheme = BISubstitutableOrdScheme.findSubstitutableOrdScheme((BOrd)base)).isPresent()) {
            base = ((BISubstitutableOrdScheme)substitutableOrdScheme.get()).convertToSubstituteOrd(base, target, (Context)BISubstitutableOrdScheme.SUBSTITUTE_NAV_ORD_FACET);
        }
        BOrd ord = BOrd.make((BOrd)base, (String)("view:" + agentId)).relativizeToSession();
        out.key("uri").value((Object)WebUtil.toUri(target, "/ord/", ord));
        out.key("ord").value((Object)ord.toString());
        BIcon icon = agent.getIcon(cx);
        if (icon == null) {
            icon = BIcon.std((String)"object.png");
        }
        out.key("icon").value((Object)icon.getOrdList().encodeToString());
        if (isDefault) {
            out.key("def").value(true);
        }
        if (typeInfo.is(BServletView.TYPE)) {
            out.key("sv").value(true);
        }
        if (hxViewType != null && typeInfo.is(hxViewType)) {
            hx = true;
            if (hxPxViewType != null && typeInfo.is(hxPxViewType) && target.get() instanceof BPxFile && (PREFER_UX_MEDIA || UX_MEDIA_TYPE.equals(PxFileUtil.getMedia((BPxFile)((BPxFile)target.get()))))) {
                ux = true;
            }
        }
        if (widgetType != null && typeInfo.is(widgetType)) {
            wb = true;
        }
        if (pxViewType != null && typeInfo.is(pxViewType)) {
            px = true;
            if (UX_MEDIA_TYPE.equals(((BAbstractPxView)agent).getResolvableMediaType().toString())) {
                ux = true;
            }
        }
        if (typeInfo.is(uxBuilderViewType) && target.get() instanceof BComponent) {
            uxBuilder = true;
        }
        if (hx) {
            out.key("hx").value(true);
        }
        if (px) {
            out.key("px").value(true);
        }
        if (ux) {
            out.key("ux").value(true);
        }
        if (wb) {
            out.key("wb").value(true);
        }
        if (uxBuilder) {
            out.key("uxBuilder").value(true);
        }
        if (ux) {
            if (WebDev.get("bajaui").isEnabled()) {
                out.key("wd").value(true);
            }
        } else if (hx || px || wb) {
            if (WebDev.get("webEditors").isEnabled()) {
                out.key("wd").value(true);
            }
        } else if (typeInfo.is(BIJavaScript.TYPE) && typeInfo.is(BIFormFactorMax.TYPE) && !typeInfo.isAbstract()) {
            try {
                BIJavaScript js = (BIJavaScript)typeInfo.getInstance();
                JsInfo jsInfo = js.getJsInfo(cx);
                BIWebResource.DependencyGraph deps = jsInfo.resolveDependencies();
                if (!deps.isEmpty()) {
                    out.key("builtRjs").value((Object)deps.toJSON());
                }
                out.key("rjs").value((Object)jsInfo.getJsId());
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Unable to create JavaScript object instance", e);
            }
        }
        out.endObject();
    }

    public static class UxBuilderFilter
    extends AgentFilter {
        public boolean include(AgentInfo agent) {
            return agent instanceof PxUtil.UxBuilder;
        }
    }
}

