/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.web.CookieUtil;
import com.tridium.web.servlets.LoginSupport;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import javax.baja.web.BLoginTemplate;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PreloginServlet
extends UnauthenticatedServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LoginSupport.hasAuthenticatedSession(request)) {
            response.sendRedirect("/");
            return;
        }
        LoginSupport.handleUsernameCookie(request, response);
        LoginSupport.handleSchemeCookie(request, response);
        String query = request.getQueryString();
        if (query != null && query.contains("clear=true")) {
            NiagaraWebSession session = WebSessionUtil.getSession(request, false);
            if (session != null) {
                session.removeAttribute("username");
                session.removeAttribute("selectedScheme");
            }
            response.addCookie(CookieUtil.createCookie("niagara_userid", "", 0));
            response.addCookie(CookieUtil.createCookie("niagara_essential_session_support", "", 0));
            response.addCookie(CookieUtil.createCookie("niagara_auth_scheme", "", 0));
            response.sendRedirect("/prelogin");
            return;
        }
        String username = LoginSupport.getRequestedUsername(request);
        if (username != null) {
            response.sendRedirect("/login");
            return;
        }
        if (LoginSupport.handleSSOCookie(request, response)) {
            return;
        }
        response.setContentType("text/html; charset=utf-8");
        BLoginTemplate.getLoginTemplate().write(request, response);
        LoginSupport.cleanup(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LoginSupport.handleSSOPost(request, response)) {
            return;
        }
        LoginSupport.handleUsernameAndSchemeCookies(request, response);
    }
}

