/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BSSOConfiguration;
import com.tridium.authn.LoginFailureCause;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.PersistentSessionAttribute;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Authentication;

public class LoginSupport {
    static Logger log = Logger.getLogger("web.login");
    public static final String ORIGIN_URI_ATTR = "originURI";
    public static final String SSO_LOGIN_ATTR = "ssoLogin";
    public static final String USERNAME_ATTR = "username";
    public static final String SCHEME_ATTR = "selectedScheme";
    public static final String LOGIN_FAILURE_CAUSE_ATTR = "loginFailureCause";
    public static final Set<String> loginURIs = new HashSet<String>();

    static boolean handleSSOPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lexicon lex = Lexicon.make((String)"web");
        String ssoSchemeName = request.getParameter(SSO_LOGIN_ATTR);
        if (ssoSchemeName != null) {
            BAuthenticationService service = BAuthenticationService.getService();
            BAuthenticationScheme ssoScheme = service.getAuthenticationScheme(ssoSchemeName);
            BSSOConfiguration ssoConfiguration = service.getSsoConfiguration();
            if (!(ssoScheme instanceof BSSOAuthenticationScheme)) {
                log.warning(lex.get("login.failed.invalidAuthnScheme"));
                response.addCookie(CookieUtil.createCookie("niagara_failure_cause", LoginFailureCause.GENERIC.name(), -1));
                response.sendRedirect("/prelogin");
                return true;
            }
            String autoSSOCookieName = "niagara_sso_scheme";
            String ssoRememberOption = request.getParameter("ssoRememberOption");
            if (ssoRememberOption != null && ssoRememberOption.equals("true")) {
                Cookie cookie = CookieUtil.createCookie(autoSSOCookieName, ssoSchemeName, CookieUtil.COOKIE_AGE, true, request.isSecure());
                cookie.setDomain(ssoConfiguration.getRememberMyChoiceDomain());
                response.addCookie(cookie);
            } else if (CookieUtil.getCookieFromName(request, autoSSOCookieName) != null) {
                Cookie cookie = CookieUtil.createCookie(autoSSOCookieName, "", 0, true, request.isSecure());
                cookie.setDomain(ssoConfiguration.getRememberMyChoiceDomain());
                response.addCookie(cookie);
            }
            response.addCookie(CookieUtil.createCookie("niagara_current_sso_scheme", ssoScheme.getName(), -1, true, request.isSecure()));
            response.sendRedirect(((BSSOAuthenticationScheme)ssoScheme).getLoginRedirectURL());
            return true;
        }
        return false;
    }

    static boolean handleSSOCookie(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query = request.getQueryString();
        Cookie ssoCookie = CookieUtil.getCookieFromName(request, "niagara_sso_scheme");
        if (!(ssoCookie == null || query != null && query.contains("auth=fail"))) {
            BAuthenticationService service = BAuthenticationService.getService();
            try {
                String originURI;
                BAuthenticationScheme ssoScheme = service.getAuthenticationScheme(ssoCookie.getValue());
                if (ssoScheme instanceof BSSOAuthenticationScheme && !LoginSupport.isLoginURI(originURI = LoginSupport.getOriginUri(request))) {
                    response.addCookie(CookieUtil.createCookie("niagara_current_sso_scheme", ssoScheme.getName(), -1, true, request.isSecure()));
                    response.sendRedirect(((BSSOAuthenticationScheme)ssoScheme).getLoginRedirectURL());
                    return true;
                }
            }
            catch (AuthenticationException e) {
                response.addCookie(CookieUtil.createCookie("niagara_failure_cause", LoginFailureCause.INVALID_SSO_SCHEME.name(), -1));
                String username = (String)WebSessionUtil.getSession(request).getAttribute(USERNAME_ATTR);
                if (username != null) {
                    response.sendRedirect("/login?auth=fail");
                } else {
                    response.sendRedirect("/prelogin?auth=fail");
                }
                return true;
            }
        }
        return false;
    }

    static void handleUsernameAndSchemeCookies(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter("j_username");
        if (username != null && !username.isEmpty()) {
            BWebService webService = BWebService.getMainService();
            BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            String authScheme = null;
            if (authnService.getStrictAuthentication()) {
                authScheme = request.getParameter("scheme");
            }
            if (webService.getRememberUserIdCookie()) {
                response.addCookie(CookieUtil.createCookie("niagara_userid", username, CookieUtil.COOKIE_AGE, true, request.isSecure()));
                if (authScheme != null) {
                    response.addCookie(CookieUtil.createCookie("niagara_auth_scheme", authScheme, CookieUtil.COOKIE_AGE, true, request.isSecure()));
                }
            } else {
                if (CookieUtil.getCookieFromName(request, "niagara_userid") != null) {
                    response.addCookie(CookieUtil.createCookie("niagara_userid", "", 0, true, request.isSecure()));
                }
                if (CookieUtil.getCookieFromName(request, "niagara_auth_scheme") != null) {
                    response.addCookie(CookieUtil.createCookie("niagara_auth_scheme", "", 0, true, request.isSecure()));
                }
            }
            if (WebSessionUtil.getSession(request, false) != null) {
                LoginSupport.recreateSession(request, username, null);
            }
        }
    }

    static boolean isLoginURI(String uri) {
        return uri == null || loginURIs.contains(uri);
    }

    static void cleanup(HttpServletRequest request, HttpServletResponse response) {
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        response.addCookie(CookieUtil.createCookie("niagara_current_sso_scheme", "", 0, true, request.isSecure()));
        response.addCookie(CookieUtil.createCookie("niagara_failure_cause", "", 0, true, request.isSecure()));
        response.addCookie(CookieUtil.createCookie("niagara_failure_info", "", 0, true, request.isSecure()));
    }

    public static NiagaraWebSession recreateSession(HttpServletRequest request, String username, String originUri) {
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        if (session == null) {
            return null;
        }
        if (username == null) {
            username = (String)session.getAttribute(USERNAME_ATTR);
        }
        if (originUri == null) {
            originUri = LoginSupport.getOriginUri(request);
        }
        HashMap<String, PersistentSessionAttribute> persistentAttributes = new HashMap<String, PersistentSessionAttribute>();
        for (String string : session.getAttributeKeys()) {
            Object attribute = session.getAttribute(string);
            if (!(attribute instanceof PersistentSessionAttribute)) continue;
            persistentAttributes.put(string, (PersistentSessionAttribute)attribute);
        }
        session.invalidate();
        session = WebSessionUtil.getSession(request);
        session.setAttribute(ORIGIN_URI_ATTR, originUri);
        session.setAttribute(USERNAME_ATTR, username);
        for (Map.Entry entry : persistentAttributes.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return session;
    }

    public static void handleUsernameCookie(HttpServletRequest request, HttpServletResponse response) {
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        if (session != null && session.getAttribute(USERNAME_ATTR) != null) {
            return;
        }
        BWebService webService = BWebService.getMainService();
        Cookie cookie = CookieUtil.getCookieFromName(request, "niagara_userid");
        if (cookie != null) {
            if (session == null && !webService.getRememberUserIdCookie()) {
                session = WebSessionUtil.getSession(request, true);
            }
            if (session != null) {
                session.setAttribute(USERNAME_ATTR, cookie.getValue());
            }
            if (!webService.getRememberUserIdCookie()) {
                cookie.setMaxAge(0);
                cookie.setValue("");
                cookie.setHttpOnly(true);
                cookie.setSecure(request.isSecure());
            } else {
                cookie.setMaxAge(CookieUtil.COOKIE_AGE);
                cookie.setHttpOnly(true);
                cookie.setSecure(request.isSecure());
            }
            cookie.setPath("/");
            response.addCookie(CookieUtil.encodeCookie(cookie));
        }
    }

    public static void handleSchemeCookie(HttpServletRequest request, HttpServletResponse response) {
        BAuthenticationService authnService = BAuthenticationService.getService();
        if (!authnService.getStrictAuthentication()) {
            return;
        }
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        if (session != null && session.getAttribute(SCHEME_ATTR) != null) {
            return;
        }
        BWebService webService = BWebService.getMainService();
        Cookie cookie = CookieUtil.getCookieFromName(request, "niagara_auth_scheme");
        if (cookie != null) {
            if (session == null && !webService.getRememberUserIdCookie()) {
                session = WebSessionUtil.getSession(request, true);
            }
            if (session != null) {
                session.setAttribute(SCHEME_ATTR, cookie.getValue());
            }
            if (!webService.getRememberUserIdCookie()) {
                cookie.setMaxAge(0);
                cookie.setValue("");
            } else {
                cookie.setMaxAge(CookieUtil.COOKIE_AGE);
                cookie.setHttpOnly(true);
            }
            cookie.setPath("/");
            cookie.setHttpOnly(true);
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
        }
    }

    public static boolean hasAuthenticatedSession(HttpServletRequest request) {
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        if (session == null) {
            return false;
        }
        if (session.getAttribute("forceReset") != null || session.getAttribute("passwordExpires") != null) {
            return false;
        }
        Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        return authentication != null;
    }

    public static BAuthenticationScheme getSelectedAuthenticationScheme(HttpServletRequest request) {
        BAuthenticationScheme scheme;
        BAuthenticationService authnService;
        block8: {
            NiagaraWebSession session;
            authnService = BAuthenticationService.getService();
            scheme = null;
            String schemeName = null;
            Cookie cookie = CookieUtil.getCookieFromName(request, "niagara_auth_scheme");
            if (cookie != null) {
                schemeName = cookie.getValue();
            }
            if (schemeName == null && (session = WebSessionUtil.getSession(request, false)) != null) {
                schemeName = (String)session.getAttribute(SCHEME_ATTR);
            }
            if (schemeName != null) {
                try {
                    scheme = authnService.getAuthenticationScheme(schemeName);
                    if (scheme.getAgentOn(BILoginHTMLForm.class) == null) {
                        scheme = null;
                        log.warning(String.format("Requested authentication scheme name <%s> does not support web login. Falling back to default.", schemeName));
                    }
                    break block8;
                }
                catch (Exception e) {
                    log.warning(String.format("Requested authentication scheme name <%s> not found. Falling back to default.", schemeName));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Caused by:", e);
                    }
                    break block8;
                }
            }
            log.fine("Authentication scheme name not provided. Using default.");
        }
        if (scheme == null) {
            scheme = authnService.getDefaultSchemeWithAgent(BILoginHTMLForm.class);
            log.fine("Authenticating with default authentication scheme: " + scheme.getName());
        }
        return scheme;
    }

    public static String getRequestedUsername(HttpServletRequest request) {
        String username = request.getParameter("j_username");
        if (username != null) {
            return username;
        }
        Cookie encryptedUsernameCookie = CookieUtil.getCookieFromName(request, "niagara_essential_session_support");
        if (encryptedUsernameCookie != null) {
            try {
                return CookieUtil.getDecryptedCookieValue(encryptedUsernameCookie);
            }
            catch (IOException e) {
                log.log(Level.FINE, "Could not decrypt cookie", e);
            }
        }
        return LoginSupport.getRequestedAttributeOrCookie(request, USERNAME_ATTR, "niagara_userid");
    }

    public static String getRequestedAttributeOrCookie(HttpServletRequest request, String attributeName, String cookieName) {
        Cookie cookie;
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        String value = null;
        if (session != null) {
            value = (String)session.getAttribute(attributeName);
        }
        if (value == null && (cookie = CookieUtil.getCookieFromName(request, cookieName)) != null) {
            value = cookie.getValue();
        }
        return value;
    }

    public static String getOriginUri(HttpServletRequest request) {
        Cookie cookie;
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        String originUri = null;
        if (session != null) {
            originUri = (String)session.getAttribute(ORIGIN_URI_ATTR);
        }
        if (originUri == null && (cookie = CookieUtil.getCookieFromName(request, "niagara_origin_uri")) != null) {
            originUri = cookie.getValue();
        }
        if (originUri != null && (originUri.startsWith("http://") || originUri.startsWith("https://"))) {
            return "/ord";
        }
        return originUri;
    }

    static {
        loginURIs.add("/login");
        loginURIs.add("/prelogin");
    }
}

