/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRegistryRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BRegistryRpc.class);
    private static final Comparator<ModuleInfo> BY_PART_NAME = (o1, o2) -> o1.getModulePartName().compareTo(o2.getModulePartName());
    private static final Comparator<TypeInfo> BY_TYPE_SPEC = (t1, t2) -> t1.getTypeSpec().compareTo((Object)t2.getTypeSpec());

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray listModules(boolean withTypesOnly, boolean showInterface, boolean showAbstract, String targetType, Context cx) {
        Stream<ModuleInfo> infos = BRegistryRpc.listModules(withTypesOnly, showInterface, showAbstract, targetType);
        return BRegistryRpc.toJsonArray(infos.map(BRegistryRpc::toJson));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject listTypesForModules(List<String> moduleNames, boolean showInterface, boolean showAbstract, String targetType, Context cx) {
        JSONObject obj = new JSONObject();
        for (String module : moduleNames) {
            JSONArray arr = BRegistryRpc.listTypesForModule(module, showInterface, showAbstract, targetType, cx);
            obj.put(module, (Object)arr);
        }
        return obj;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray listTypesForModule(String moduleName, boolean showInterface, boolean showAbstract, String targetType, Context cx) {
        Stream<TypeInfo> types = Arrays.stream(Sys.getRegistry().getModules(moduleName)).map(moduleInfo -> BRegistryRpc.listTypesForModule(moduleInfo, showInterface, showAbstract, targetType)).flatMap(Function.identity()).sorted(BY_TYPE_SPEC);
        return BRegistryRpc.toJsonArray(types.map(typeInfo -> BRegistryRpc.toJson(typeInfo, cx)));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray listTypes(boolean showInterface, boolean showAbstract, String targetType, Context cx) {
        Stream<TypeInfo> types = BRegistryRpc.listTypes(showInterface, showAbstract, targetType);
        return BRegistryRpc.toJsonArray(types.map(typeInfo -> BRegistryRpc.toJson(typeInfo, cx)));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray listAdapters(String fromTypeString, String toTypeString, Context cx) {
        if (toTypeString == null) {
            throw new IllegalArgumentException("toTypeString cannot be a null");
        }
        TypeInfo toTypeInfo = Sys.getType((String)toTypeString).getTypeInfo();
        TypeInfo fromTypeInfo = fromTypeString == null || fromTypeString.isEmpty() ? null : Sys.getType((String)fromTypeString).getTypeInfo();
        Stream<TypeInfo> typeInfoStream = Arrays.stream(Sys.getRegistry().getAdapters(fromTypeInfo, toTypeInfo));
        return BRegistryRpc.toJsonArray(typeInfoStream.map(typeInfo -> BRegistryRpc.toJson(typeInfo, cx)));
    }

    public static Stream<ModuleInfo> listModules(boolean withTypesOnly, boolean showInterface, boolean showAbstract, String targetType) {
        Type type = BRegistryRpc.getTargetType(withTypesOnly, targetType);
        return Arrays.stream(Sys.getRegistry().getModules()).filter(m -> BRegistryRpc.includeModule(m, withTypesOnly, showInterface, showAbstract, type)).sorted(BY_PART_NAME);
    }

    public static Stream<TypeInfo> listTypesForModule(ModuleInfo moduleInfo, boolean showInterface, boolean showAbstract, String targetType) {
        Type type = BRegistryRpc.getTargetType(targetType);
        return Arrays.stream(moduleInfo.getTypes()).filter(t -> BRegistryRpc.includeType(t, showInterface, showAbstract, type)).sorted(BY_TYPE_SPEC);
    }

    public static Stream<TypeInfo> listTypes(boolean showInterface, boolean showAbstract, String targetType) {
        Type type = BRegistryRpc.getTargetType(targetType);
        return Arrays.stream(Sys.getRegistry().getModules()).map(ModuleInfo::getTypes).flatMap(Arrays::stream).filter(t -> BRegistryRpc.includeType(t, showInterface, showAbstract, type));
    }

    private static JSONObject toJson(ModuleInfo moduleInfo) {
        return new JSONObject().put("n", (Object)moduleInfo.getModulePartName()).put("m", (Object)moduleInfo.getModuleName()).put("rt", (Object)moduleInfo.getRuntimeProfile().toString()).put("d", (Object)moduleInfo.getDescription()).put("v", (Object)moduleInfo.getVendor()).put("vv", (Object)moduleInfo.getVendorVersion().toString());
    }

    private static JSONObject toJson(TypeInfo info, Context cx) {
        return new JSONObject().put("type", (Object)info.getTypeSpec().toString()).put("displayName", (Object)info.getDisplayName(cx));
    }

    private static JSONArray toJsonArray(Stream<JSONObject> stream) {
        JSONArray arr = new JSONArray();
        stream.forEach(arg_0 -> ((JSONArray)arr).put(arg_0));
        return arr;
    }

    private static Type getTargetType(String typeSpec) {
        return BRegistryRpc.getTargetType(true, typeSpec);
    }

    private static Type getTargetType(boolean withTypesOnly, String typeSpec) {
        return withTypesOnly && typeSpec != null && !typeSpec.isEmpty() ? Sys.getType((String)typeSpec) : null;
    }

    private static boolean includeModule(ModuleInfo module, boolean withTypesOnly, boolean showInterface, boolean showAbstract, Type targetType) {
        if (!withTypesOnly) {
            return true;
        }
        for (TypeInfo type : module.getTypes()) {
            if (!BRegistryRpc.includeType(type, showInterface, showAbstract, targetType)) continue;
            return true;
        }
        return false;
    }

    private static boolean includeType(TypeInfo type, boolean showInterface, boolean showAbstract, Type targetType) {
        return !(!showAbstract && type.isAbstract() || !showInterface && type.isInterface() || targetType != null && !type.is(targetType));
    }
}

