/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.sys.transfer.FileToFile;
import com.tridium.web.servlets.FileServlet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NotDirectoryException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BITextFile;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
public final class BFileRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileRpc.class);
    private static final LexiconModule lexicon = LexiconModule.make((String)"web");
    private static final BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String readTextFile(String ord, Context cx) throws Exception {
        return BFileRpc.readTextFile(BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx), cx);
    }

    public static String readTextFile(OrdTarget target, Context cx) throws Exception {
        if (!FileServlet.canRead(target)) {
            throw new PermissionException(lexicon.getText("fileRpc.error.cannotReadFile", cx, new Object[]{target.getOrd()}));
        }
        if (Sys.isStation()) {
            throw new PermissionException(lexicon.getText("fileRpc.error.onlyOffline", cx));
        }
        try {
            return AccessController.doPrivileged(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean exists(String ord, Context cx) {
        return fileWriter.exists(BOrd.make((String)ord), cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean isWritable(String ord, Context cx) {
        return fileWriter.isWritable(BOrd.make((String)ord), cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void writeTextFile(String ord, String contents, Context cx) throws Exception {
        BFileRpc.writeTextFile(BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx), contents, cx);
    }

    public static void writeTextFile(OrdTarget target, String contents, Context cx) throws Exception {
        if (!FileServlet.canWrite(target)) {
            throw new PermissionException(lexicon.getText("fileRpc.error.cannotWriteFile", cx, new Object[]{target.getOrd()}));
        }
        if (Sys.isStation()) {
            throw new PermissionException(lexicon.getText("fileRpc.error.onlyOffline", cx));
        }
        BITextFile file = (BITextFile)target.get();
        try {
            AccessController.doPrivileged(() -> {
                try (ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
                     OutputStream out = file.getOutputStream();){
                    FileUtil.pipe((InputStream)in, (OutputStream)out);
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void renameFile(String sourceOrd, String newFileName, Context cx) throws Exception {
        BFileRpc.renameFile(BOrd.make((String)sourceOrd).resolve((BObject)BLocalHost.INSTANCE, cx), newFileName, cx);
    }

    public static void renameFile(OrdTarget target, String newFileName, Context cx) throws Exception {
        newFileName = newFileName.trim();
        FilePath.verifyValidName((String)newFileName);
        BObject obj = target.get();
        if (!(obj instanceof BIFile && target.canRead() && target.canWrite())) {
            throw new PermissionException(lexicon.getText("fileRpc.error.cannotRenameFile", cx, new Object[]{target.getOrd()}));
        }
        BIFile file = (BIFile)obj;
        FilePath oldPath = file.getFilePath();
        FilePath newPath = new FilePath(newFileName);
        file.getFileSpace().move(oldPath, newPath, cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void deleteFile(String ord, Context cx) throws Exception {
        BFileRpc.deleteFile(BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx), cx);
    }

    public static void deleteFile(OrdTarget target, Context cx) throws Exception {
        BObject obj = target.get();
        if (!(obj instanceof BIFile && target.canRead() && target.canWrite())) {
            throw new PermissionException(lexicon.getText("fileRpc.error.cannotDeleteFile", cx, new Object[]{target.getOrd()}));
        }
        BIFile file = (BIFile)obj;
        FilePath path = file.getFilePath();
        file.getFileSpace().delete(path, cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void makeDir(String targetDirOrdString, String newDirectoryName, Context cx) throws Exception {
        BFileRpc.makeDir(BOrd.make((String)targetDirOrdString).resolve((BObject)BLocalHost.INSTANCE, cx), newDirectoryName, cx);
    }

    public static void makeDir(OrdTarget targetDirectoryOrdTarget, String newDirectoryName, Context cx) throws Exception {
        FilePath newDirectoryPath;
        BIFile targetDirectory;
        BObject targetDirectoryObj = targetDirectoryOrdTarget.get();
        FilePath.verifyValidName((String)newDirectoryName);
        if (targetDirectoryObj instanceof BIFile && targetDirectoryOrdTarget.canRead() && targetDirectoryOrdTarget.canWrite()) {
            targetDirectory = (BIFile)targetDirectoryObj;
            if (!targetDirectory.isDirectory()) {
                throw new NotDirectoryException(lexicon.getText("fileRpc.error.isNotADirectory", cx, new Object[]{targetDirectoryOrdTarget.getOrd()}));
            }
            newDirectoryPath = targetDirectory.getFilePath().merge(newDirectoryName);
            if (BFileRpc.exists(newDirectoryPath.toString(), cx)) {
                throw new FileAlreadyExistsException(lexicon.getText("fileRpc.error.alreadyExist", cx, new Object[]{newDirectoryName}));
            }
        } else {
            throw new PermissionException(lexicon.getText("fileRpc.error.cannotCreateDirectory", cx, new Object[]{newDirectoryName, targetDirectoryOrdTarget.getOrd()}));
        }
        targetDirectory.getFileSpace().makeDir(newDirectoryPath, cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getUniqueFilename(String targetDirOrdString, String suggestedName, Context cx) throws Exception {
        return BFileRpc.getUniqueFilename(BOrd.make((String)targetDirOrdString).resolve((BObject)BLocalHost.INSTANCE, cx), suggestedName, cx);
    }

    public static String getUniqueFilename(OrdTarget targetDirectoryOrdTarget, String suggestedName, Context cx) throws Exception {
        BObject targetDirectoryObj = targetDirectoryOrdTarget.get();
        if (targetDirectoryObj instanceof BDirectory && targetDirectoryOrdTarget.canRead() && targetDirectoryOrdTarget.canWrite()) {
            BDirectory targetDir = (BDirectory)targetDirectoryObj;
            return FileToFile.getUniqueFilename((BDirectory)targetDir, (String)suggestedName);
        }
        throw new PermissionException(lexicon.getText("fileRpc.error.cannotAccessDirectory", cx, new Object[]{targetDirectoryOrdTarget.getOrd()}));
    }
}

