/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters.cache;

import com.tridium.util.warmup.BWarmupConfig;
import com.tridium.web.filters.cache.FileCache;
import com.tridium.web.filters.cache.FileCacheFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import org.owasp.encoder.Encode;

public final class HeapMemoryFileCache
implements FileCache {
    private static final Map<String, Blob> cache = new ConcurrentHashMap<String, Blob>();
    public static final String CACHE_TYPE = "heapMemory";

    @Override
    public boolean has(String path) {
        return cache.containsKey(path);
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return cache.compute(path, (key, value) -> new Blob()).getOutputStream();
    }

    @Override
    public void delete(String path) throws IOException {
        cache.remove(path);
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return cache.get(path).getInputStream();
    }

    @Override
    public void clear() throws IOException {
        cache.clear();
    }

    public String toString() {
        return CACHE_TYPE;
    }

    @Override
    public void spy(SpyWriter out) {
        out.startProps("Heap Memory File Cache");
        out.startTable(true).w((Object)"<tr>").th((Object)"Path").th((Object)"Size (kb)").th((Object)"Creation Time").th((Object)"Last Read Time").w((Object)"</tr>");
        DecimalFormat df = new DecimalFormat(".##");
        BFacets timeFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        cache.forEach((path, blob) -> out.tr((Object)Encode.forHtml((String)path), (Object)df.format((double)((Blob)blob).buff.length / 1024.0), (Object)((Blob)blob).creationTime.toString((Context)timeFacets), (Object)((Blob)blob).lastReadTime.toString((Context)timeFacets)));
        out.endTable();
    }

    public Map<String, Blob> getInternalCache() {
        return Collections.unmodifiableMap(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmup(String path, String cacheName, BIFile file) throws Exception {
        if (FileCacheFilter.isWebCacheDisabled(cacheName)) {
            return;
        }
        boolean disableGzip = AccessController.doPrivileged(() -> Boolean.getBoolean("web.filecache." + cacheName + ".gzip.disable"));
        Map<String, Blob> map = cache;
        synchronized (map) {
            if (cache.get(path) != null) {
                return;
            }
            Blob blob = new Blob();
            try (InputStream in = file.getInputStream();
                 OutputStream out = disableGzip ? blob.getOutputStream() : new GZIPOutputStream(blob.getOutputStream());){
                HeapMemoryFileCache.pipeWithCheckInterrupted(in, out);
            }
            cache.put(disableGzip ? path : path + ".gz", blob);
        }
    }

    private static void pipeWithCheckInterrupted(InputStream in, OutputStream out) throws IOException {
        int len = 4096;
        byte[] buf = new byte[len];
        while (true) {
            BWarmupConfig.checkInterrupted();
            int n = in.read(buf, 0, len);
            if (n < 0) break;
            out.write(buf, 0, n);
        }
    }

    public static final class Blob {
        private static final byte[] EMPTY_BYTES = new byte[0];
        private byte[] buff = EMPTY_BYTES;
        private BAbsTime creationTime = BAbsTime.DEFAULT;
        private BAbsTime lastReadTime = BAbsTime.DEFAULT;

        public OutputStream getOutputStream() {
            this.buff = EMPTY_BYTES;
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    Blob.access$002(this, this.toByteArray());
                    creationTime = BAbsTime.now();
                }
            };
        }

        public InputStream getInputStream() {
            this.lastReadTime = BAbsTime.now();
            return new ByteArrayInputStream(this.buff);
        }

        static /* synthetic */ byte[] access$002(Blob x0, byte[] x1) {
            x0.buff = x1;
            return x1;
        }
    }
}

