/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public final class GzipServletOutputStream
extends ServletOutputStream {
    private ServletOutputStream servletOut;
    private GZIPOutputStream gzipServletOut;

    public GzipServletOutputStream(ServletOutputStream servletOut) throws IOException {
        this.servletOut = servletOut;
        this.gzipServletOut = new GZIPOutputStream((OutputStream)servletOut);
    }

    public void write(int b) throws IOException {
        this.gzipServletOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.gzipServletOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.gzipServletOut.write(b, off, len);
    }

    public void flush() throws IOException {
        this.gzipServletOut.flush();
    }

    public void close() throws IOException {
        this.gzipServletOut.close();
    }

    public boolean isReady() {
        return this.servletOut.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.servletOut.setWriteListener(writeListener);
    }
}

