/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import com.tridium.web.filters.OrdTargetFilter;
import com.tridium.web.servlets.NWebOp;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebOpFilter
implements Filter {
    private boolean redirectToHome = false;
    private BWebService service;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.service = (BWebService)Sys.getService((Type)BWebService.TYPE);
        this.redirectToHome = filterConfig != null && Boolean.parseBoolean(filterConfig.getInitParameter("redirectToHome"));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        OrdTarget target = (OrdTarget)req.getAttribute("niagara.target");
        if (target == null) {
            req.getServletContext().log("No Target available");
            resp.sendError(404);
            return;
        }
        try {
            NWebOp op = new NWebOp(target, this.service, req, resp);
            op.initWebEnv();
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = req.getQueryString();
            }
            if (pathInfo == null || pathInfo.length() <= 1) {
                BOrd homePage = op.getWebEnv().getHomePage(op);
                if (this.redirectToHome && "GET".equalsIgnoreCase(req.getMethod()) && !homePage.isNull()) {
                    try {
                        resp.sendRedirect(OrdTargetFilter.fromOrd(homePage));
                    }
                    catch (URISyntaxException e) {
                        req.getServletContext().log("URI Syntax error: " + homePage, (Throwable)e);
                        resp.sendError(400);
                    }
                } else {
                    resp.sendError(400);
                }
                return;
            }
            req.setAttribute("niagara.op", (Object)op);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        catch (Exception e) {
            req.getServletContext().log("Unable to create WebOp", (Throwable)e);
            resp.sendError(400);
        }
    }
}

