/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import com.tridium.util.PxUtil;
import com.tridium.web.PxViewFilter;
import com.tridium.web.WebUtil;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BPermissions;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ViewFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        OrdTarget target = (OrdTarget)req.getAttribute("niagara.target");
        if (target == null) {
            req.getServletContext().log("No Target available");
            resp.sendError(404);
            return;
        }
        WebOp op = (WebOp)((Object)req.getAttribute("niagara.op"));
        if (op == null) {
            req.getServletContext().log("No WebOp available");
            resp.sendError(404);
            return;
        }
        IWebEnv env = op.getWebEnv();
        AgentList unfilteredViews = env.getViews(op);
        AgentList views = ViewFilter.webOpFilter(unfilteredViews, op);
        views = views.filter(info -> ViewFilter.isValidView(info));
        req.setAttribute("niagara.allViewInfos", (Object)views);
        if (views.size() > 0) {
            BPermissions required;
            AgentInfo viewInfo = null;
            ViewQuery viewQuery = target.getViewQuery();
            if (viewQuery != null && viewQuery.getViewId() != null) {
                viewInfo = env.getView(unfilteredViews, viewQuery.getViewId());
            }
            if (viewInfo == null) {
                viewInfo = env.getDefaultView(op, views);
            }
            viewInfo = env.translate(op, viewInfo);
            BPermissions actual = op.getPermissionsForTarget();
            if (actual.has(required = viewInfo.getRequiredPermissions())) {
                req.setAttribute("niagara.viewInfo", (Object)viewInfo);
            } else {
                req.setAttribute("niagara.viewInfoRequiredPerm", (Object)required);
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public static String getViewId(WebOp op) {
        if (op == null || op.getRequest() == null) {
            return "";
        }
        Object attr = op.getRequest().getAttribute("niagara.viewInfo");
        if (!(attr instanceof AgentInfo)) {
            return "";
        }
        AgentInfo viewInfo = (AgentInfo)attr;
        if (viewInfo instanceof PxUtil.PxAgent) {
            PxUtil.PxAgent pxAgent = (PxUtil.PxAgent)viewInfo;
            return pxAgent.getPxView().getAgentId();
        }
        return viewInfo.getAgentId();
    }

    public static AgentList webOpFilter(AgentList list, WebOp op) {
        if (list.size() > 0) {
            AgentFilter hasFilter = AgentFilter.has((BPermissions)op.getPermissionsForTarget());
            WebUtil.ProfileFilter profileFilter = new WebUtil.ProfileFilter(op.getWebEnv().getWebProfile(op), op.get());
            list = list.filter(AgentFilter.and((AgentFilter)AgentFilter.and((AgentFilter)hasFilter, (AgentFilter)new PxViewFilter((OrdTarget)op)), (AgentFilter)profileFilter));
        }
        return list;
    }

    private static boolean isValidView(AgentInfo info) {
        return !info.getAgentType().is(BExporter.TYPE);
    }
}

