/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.AuthMessage;
import javax.baja.web.authn.BHttpHeaderCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"baja:HTTPBasicAuthenticationScheme"})})
public class BHttpBasicCallbackHandler
extends BHttpHeaderCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpBasicCallbackHandler.class);
    public static final int HELLO_STEP = 0;
    public static final int COMPLETE_STEP = 3;
    private int step = 0;
    private String username;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public int handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.step == 0) {
                int result = this.processHello(request, response);
                this.step = 3;
                return result;
            }
            return 3;
        }
        catch (Exception e) {
            return 3;
        }
    }

    private int processHello(HttpServletRequest request, HttpServletResponse response) {
        AuthMessage message = AuthMessage.decodeFromString(request.getHeader("Authorization"));
        this.username = new String(Base64.getUrlDecoder().decode(message.getParameter("username").getBytes()), StandardCharsets.UTF_8);
        AuthMessage respMessage = new AuthMessage();
        respMessage.setScheme("BASIC");
        response.setHeader("WWW-Authenticate", respMessage.encodeToString());
        response.setStatus(401);
        return 1;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException(null, "HTTP Basic Callback Handler does not support any callbacks.");
    }
}

