/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.servlet.http.HttpServletRequest;

@NiagaraType(agent={@AgentOn(types={"baja:DigestAuthenticationScheme"})})
public class BDigestLoginHTMLForm
extends BStruct
implements BILoginHTMLForm {
    @Generated
    public static final Type TYPE = Sys.loadType(BDigestLoginHTMLForm.class);
    private Lexicon lex = null;
    private BAuthenticationScheme authnScheme;
    private static final BOrd TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/digestLoginFormN4.vm");
    private static final BOrd RESET_TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/passwordResetFormN4.vm");
    private static final BOrd RESET_MESSAGE_TEMPLATE_ORD = BOrd.make((String)"module://web/com/tridium/web/rc/resetMessageN4.vm");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void initialize(HttpServletRequest request, BAuthenticationScheme authnScheme, Context context) {
        this.authnScheme = authnScheme;
    }

    @Override
    public String getLoginFormHTML(Context context, boolean passwordReset) throws IOException {
        if (context == null) {
            context = new BasicContext();
        }
        this.lex = Lexicon.make((String)"web", (Context)context);
        String username = this.getLabel(context, "login.username");
        String password = this.getLabel(context, "login.password");
        String login = this.getLabel(context, "login");
        String newPass = this.getLabel(context, "login.password.new");
        String confirm = this.getLabel(context, "login.password.new.retype");
        String changeuser = this.getLabel(context, "login.changeuser");
        BString initUsername = (BString)context.getFacet("initUsername");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("login", login);
        map.put("userName", username);
        map.put("password", password);
        map.put("new", newPass);
        map.put("confirm", confirm);
        map.put("changeUser", changeuser);
        if (initUsername != null) {
            map.put("initUsername", initUsername.getString());
        } else {
            map.put("initUsername", "");
        }
        String form = passwordReset ? Template.process(RESET_TEMPLATE_ORD, true) : Template.process(TEMPLATE_ORD, true);
        return Template.process(map, form);
    }

    @Override
    public String getResetMessageHTML(HttpServletRequest request, Context context) throws IOException {
        if (!(this.authnScheme instanceof BPasswordAuthenticationScheme)) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        BGlobalPasswordConfiguration config = ((BPasswordAuthenticationScheme)this.authnScheme).getGlobalPasswordConfiguration();
        BPasswordStrength strength = config.getPasswordStrength();
        Lexicon lex = Lexicon.make((String)"web", (Locale)request.getLocale());
        Lexicon bajaLex = Lexicon.make((String)"baja", (Locale)request.getLocale());
        map.put("resetTitle", lex.getHtmlSafe("login.password.reset"));
        map.put("resetMessage", lex.getHtmlSafe("login.password.reset.details"));
        map.put("strength", bajaLex.getHtmlSafeText("user.password.notStrong"));
        map.put("length", bajaLex.getHtmlSafeText("user.password.notLongEnough", new Object[]{strength.getMinimumLength() + ""}));
        map.put("digits", bajaLex.getHtmlSafeText("user.password.notEnoughDigits", new Object[]{strength.getMinimumDigits() + ""}));
        map.put("lower", bajaLex.getHtmlSafeText("user.password.notEnoughLowerCase", new Object[]{strength.getMinimumLowerCase() + ""}));
        map.put("upper", bajaLex.getHtmlSafeText("user.password.notEnoughUpperCase", new Object[]{strength.getMinimumUpperCase() + ""}));
        map.put("special", bajaLex.getHtmlSafeText("user.password.notEnoughSpecial", new Object[]{strength.getMinimumSpecial() + ""}));
        map.put("maxLength", bajaLex.getHtmlSafeText("user.password.notShortEnough", new Object[]{String.valueOf(strength.getMaximumLength())}));
        return Template.process(map, RESET_MESSAGE_TEMPLATE_ORD);
    }

    private String getLabel(Context context, String key) {
        BString bString = (BString)context.getFacet(key);
        if (bString != null) {
            return bString.getString();
        }
        return this.lex.getHtmlSafe(key);
    }
}

