/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebService;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;

public abstract class WebEnv
implements IWebEnv {
    private static final Logger viewLog = Logger.getLogger("web.view");
    public static final TypeInfo pxView = BAbstractPxView.TYPE.getTypeInfo();
    public static final TypeInfo wbView = WebEnv.typeInfo("workbench:WbView");
    public static final TypeInfo hxView = WebEnv.typeInfo("hx:HxView");
    public static final TypeInfo formFactorMax = WebEnv.typeInfo("web:IFormFactorMax");
    public static final TypeInfo wbProfile = WebEnv.typeInfo("workbench:WbWebProfile");
    protected AgentFilter filter;

    public static IWebEnv make(WebOp op) {
        BWebService webService = op.getService();
        return webService.getWebEnv(op);
    }

    @Override
    public abstract BIWebProfile getWebProfile(WebOp var1);

    @Override
    public BOrd getHomePage(WebOp op) {
        return op.getUser().getHomePage();
    }

    @Override
    public AgentList getViews(WebOp op) {
        return op.get().getAgents((Context)op).filter(this.filter);
    }

    @Override
    public AgentInfo getDefaultView(WebOp op, AgentList views) {
        return views.getDefault();
    }

    @Override
    public AgentInfo getView(AgentList allViews, String viewId) {
        return allViews.get(viewId);
    }

    @Override
    public AgentInfo translate(WebOp op, AgentInfo viewInfo) {
        return viewInfo;
    }

    public static AgentFilter add(AgentFilter filter, TypeInfo typeInfo) {
        if (typeInfo == null) {
            return filter;
        }
        if (filter == null) {
            return AgentFilter.is((TypeInfo)typeInfo);
        }
        return AgentFilter.or((AgentFilter)filter, (AgentFilter)AgentFilter.is((TypeInfo)typeInfo));
    }

    private static IWebEnv getWebEnvFromReflection(String typeSpec) {
        IWebEnv env = null;
        try {
            env = (IWebEnv)Sys.getType((String)typeSpec).getTypeClass().getMethod("webEnv", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            viewLog.warning(e.toString());
        }
        return env;
    }

    private static TypeInfo typeInfo(String typeSpec) {
        try {
            return Sys.getRegistry().getType(typeSpec);
        }
        catch (RuntimeException e) {
            viewLog.warning(e.toString());
            return null;
        }
    }

    public static IWebEnv hx() {
        return HxHolder.INSTANCE;
    }

    public static IWebEnv wb() {
        return WbHolder.INSTANCE;
    }

    static /* synthetic */ IWebEnv access$000(String x0) {
        return WebEnv.getWebEnvFromReflection(x0);
    }

    private static interface WbHolder {
        public static final IWebEnv INSTANCE = WebEnv.access$000("workbench:WbWebProfile");
    }

    private static interface HxHolder {
        public static final IWebEnv INSTANCE = WebEnv.access$000("hx:HxProfile");
    }
}

