/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;

public final class Template {
    private static final Pattern replacePattern = Pattern.compile("\\$([a-zbA-Z0-9]+)");
    private static final Map<BOrd, String> ordToTemplateMap = new HashMap<BOrd, String>();

    private Template() {
    }

    public static String process(BOrd templateFile) throws UnsupportedEncodingException, IOException {
        return Template.process(templateFile, false);
    }

    public static String process(BOrd templateFile, boolean cache) throws UnsupportedEncodingException, IOException {
        if (ordToTemplateMap.containsKey(templateFile)) {
            return ordToTemplateMap.get(templateFile);
        }
        BIFile file = (BIFile)templateFile.get();
        String template = new String(BajaFileUtil.read((InputStream)file.getInputStream(), (long)file.getSize()), "UTF-8");
        if (cache) {
            ordToTemplateMap.put(templateFile, template);
        }
        return template;
    }

    public static String process(Map<String, String> map, BOrd templateFile) throws UnsupportedEncodingException, IOException {
        return Template.process(map, Template.process(templateFile));
    }

    public static String process(Map<String, String> map, BOrd templateFile, boolean cache) throws UnsupportedEncodingException, IOException {
        return Template.process(map, Template.process(templateFile, cache));
    }

    public static String process(Map<String, String> map, String content) {
        StringBuffer buff = new StringBuffer();
        Matcher m = replacePattern.matcher(content);
        while (m.find()) {
            m.appendReplacement(buff, "");
            String key = m.group(1);
            String entry = key == null ? "$" + key : map.get(m.group(1));
            buff.append(entry == null ? "$" + key : entry);
        }
        m.appendTail(buff);
        return buff.toString();
    }
}

