/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.logging.BLoggingService;
import com.tridium.web.js.NiagaraRequireJsMapper;
import com.tridium.web.js.RequireJsMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebDev;
import javax.baja.web.js.BIRequireJsConfig;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.BJsBuild;
import javax.baja.web.js.JsInfo;

public final class RequireJsUtil {
    private final boolean useLocalWbRc;
    private final String modulePrefix;
    private final Context cx;
    public static final String initialModulePrefix = "module://";
    public static final String remoteModulePrefix = "/module/";
    public static final String wbModulePrefix = "https://workbench/module/";
    public static final String wbHostName = "workbench";
    public static final Pattern NMODULE_PATTERN = Pattern.compile("^nmodule/");
    public static final Pattern MODULE_PREFIX_PATTERN = Pattern.compile("^(/module/|https://workbench/module/)");
    private static final boolean NO_PROMISE_WARNINGS = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.noPromiseWarnings"));
    public static final boolean USE_NATIVE_PROMISES = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.useNativePromises"));
    private static final String[] EXPOSED_SYSTEM_PROPERTIES = new String[]{"bajaux.binder.disableOrdSubstitution", "bajaux.binder.disableViewQueryCoalesce", "niagara.browser.maxUndoHistory", "niagara.export.preventCSVInjection", "niagara.fileRpc.maxFileSize", "niagara.history.interpolateRefreshInterval", "niagara.license.subscriptionLicenseAllowed", "niagara.nav.touch.scanRate", "niagara.uxMedia.onError", "niagara.webChart.autoSamplingSize", "niagara.webChart.maxSamplingSize", "niagara.webChart.maxSeriesCapacity", "niagara.webTableMaxLength", "niagara.wiresheet.leaseForOutgoingStubColors"};
    private static final boolean DEBUG_ARGS = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.requirejs.debugArgs"));
    private static final boolean USE_JQUERY_STRICT_HTML_PREFILTER = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.requirejs.useJQueryStrictHtmlPrefilter"));
    private static final String URL_VERSION = String.valueOf(Sys.getRegistry().getLastBuildTime().getMillis());

    private RequireJsUtil(boolean useLocalWbRc, Context cx) {
        this.useLocalWbRc = useLocalWbRc;
        this.modulePrefix = RequireJsUtil.getModulePrefix(useLocalWbRc);
        this.cx = cx;
    }

    public static RequireJsUtil make(boolean useLocalWbRc, Context cx) {
        return new RequireJsUtil(useLocalWbRc, cx);
    }

    public void requirejs(Writer writer) throws IOException {
        this.requirejs(BOrd.NULL, writer);
    }

    public void requirejsNoHtml(Writer writer) throws IOException {
        writer.write("var require = typeof require === 'undefined' ? {} : require;\n");
        this.createRequireJs(BOrd.NULL, writer, false);
    }

    public void requirejs(BOrd mainOrd, Writer writer) throws IOException {
        writer.write("<script type='text/javascript'>var require = typeof require === 'undefined' ? {} : require;</script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    public void requirejs(BOrd mainOrd, String requireJs, Writer writer) throws IOException {
        writer.write("<script type='text/javascript'>");
        writer.write(requireJs);
        writer.write("</script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    public void requirejs(BOrd mainOrd, BOrd configFileOrd, Writer writer) throws IOException {
        writer.write("<script type='text/javascript' src='");
        writer.write(TextUtil.replace((String)configFileOrd.toString(), (String)initialModulePrefix, (String)RequireJsUtil.getModulePrefix(this.useLocalWbRc)));
        writer.write("?version=");
        writer.write(RequireJsUtil.getUrlVersion());
        writer.write("'></script>\n");
        this.createRequireJs(mainOrd, writer, true);
    }

    private void createRequireJs(BOrd main, Writer writer, boolean html) throws IOException {
        boolean isWebDevBajaScript = RequireJsUtil.isWebDevBajaScript();
        boolean isWebDevJs = RequireJsUtil.isWebDevJs();
        String urlVersion = RequireJsUtil.getUrlVersion();
        ConfigBuilder out = new ConfigBuilder(writer, urlVersion);
        if (html) {
            out.openScriptTag();
        }
        out.w("(function () {", new Object[0]);
        out.w("function rjsConfig(pathString, value) {", new Object[0]);
        out.w("  var target = require;", new Object[0]);
        out.w("  var path = pathString.split('|');", new Object[0]);
        out.w("  var prop = path.pop();", new Object[0]);
        out.w("  path.forEach(function (token) {", new Object[0]);
        out.w("    target = (target[token] = target[token] || {});", new Object[0]);
        out.w("  });", new Object[0]);
        out.w("  target[prop] = target[prop] === undefined ? value : target[prop];", new Object[0]);
        out.w("}", new Object[0]);
        out.rjsConfig("urlArgs", "'version=%s'", new Object[]{urlVersion});
        out.rjsConfig("waitSeconds", 0);
        out.rjsConfig("config|ord|useLocalWbRc", this.useLocalWbRc);
        out.rjsConfig("config|baja|webdev", isWebDevBajaScript);
        out.rjsConfig("config|baja|offline", !Sys.isStation());
        out.rjsConfig("config|lex|webdev", isWebDevJs);
        out.rjsConfig("hbs|i18n", false);
        out.rjsConfig("hbs|helpers", false);
        out.rjsConfig("hbs|fetchText", "function (uri, callback) {\n  function unmodularize(href) {\n    var res;\n    if (href) {\n      res = /^module:\\/\\/(.+)$/.exec(href);\n      if (res && res[1]) {\n        href = '/module/' + res[1];\n      }\n    }\n    return href;\n  }\n  \n  require(['baja!', 'jquery'], function (baja, $) {\n    if (baja.isOffline()) {\n      uri = /([^?]*)\\??.*/.exec(uri)[1];\n      uri = uri.replace('https://workbench/module/', 'module://');\n      baja.rpc('type:web:FileRpc', 'readTextFile', uri)\n        .then(function (text) {\n          callback(text, uri);\n        });\n    }\n    else {\n      $.ajax(unmodularize(uri)).then(function (text) {\n        callback(text, uri);\n      });\n    }\n  });\n}", new Object[0]);
        out.rjsConfig("config|nmodule/js/rc/lex/lex|storageId", "'%s'", new Object[]{urlVersion});
        out.rjsConfig("config|nmodule/js/rc/lex/lex|lang", "'%s'", new Object[]{this.cx != null ? this.cx.getLanguage() : "en"});
        JSONObject logLevels = RequireJsUtil.getLogLevelsConfig(this.cx);
        if (logLevels != null) {
            out.rjsConfig("config|nmodule/js/rc/log/Log|logLevels", logLevels.toString(), new Object[0]);
            out.rjsConfig("config|nmodule/js/rc/log/Log|logHandlers", "[ 'nmodule/js/rc/log/handlers/rpcHandler' ]", new Object[0]);
        }
        out.rjsConfig("paths|nmodule", "'%s'", new Object[]{this.modulePrefix.substring(0, this.modulePrefix.length() - 1)});
        if (USE_NATIVE_PROMISES) {
            out.map("Promise", "nmodule/js/rc/shims/Promise");
        } else {
            out.path("Promise", "js/rc/bluebird/bluebird", isWebDevJs ? "" : ".min");
        }
        if (!USE_JQUERY_STRICT_HTML_PREFILTER) {
            out.map("jquery", "nmodule/js/rc/shims/jquery/jquery" + (isWebDevJs ? "" : ".min"));
        }
        NiagaraRequireJsMapper.getInstance().eachPath((rjsId, path) -> out.path(rjsId, RequireJsMapper.stripJsAndCssExtension(path)));
        out.plugin("lex", "js/rc/lex/lexplugin").plugin("log", "js/rc/log/logPlugin");
        out.rjsConfig("shim|d3|exports", "'d3'", new Object[0]);
        out.rjsConfig("shim|jqueryContextMenu|deps", "[ 'jquery' ]", new Object[0]);
        out.rjsConfig("shim|jqueryContextMenu|exports", "'jQuery'", new Object[0]);
        out.rjsConfig("shim|nmodule/js/rc/jquery/split-pane/split-pane|deps", "[ 'jquery' ]", new Object[0]);
        for (TypeInfo type : Sys.getRegistry().getConcreteTypes(BIRequireJsConfig.TYPE.getTypeInfo())) {
            BIRequireJsConfig config = (BIRequireJsConfig)type.getInstance();
            JsInfo jsInfo = config.getJsInfo(this.cx);
            boolean webdev = isWebDevJs;
            if (null != jsInfo) {
                webdev = BJsBuild.forId(jsInfo.getBuildId()).map(BJsBuild::isWebDevEnabled).orElse(isWebDevJs);
            }
            config.write(writer, this.modulePrefix, webdev, this.cx);
        }
        out.w("}());", new Object[0]);
        if (html) {
            out.closeScriptTag();
            boolean useMinifiedRjs = !isWebDevJs;
            out.importRequireJs(main, useMinifiedRjs);
            if (isWebDevJs) {
                out.importJs("js/com/tridium/js/ext/require/xrayquire/xrayquire.js");
            }
            if (!isWebDevJs) {
                out.importJs("js/rc/js.built.min.js");
            }
            boolean debugPromises = isWebDevJs && !NO_PROMISE_WARNINGS;
            RequireJsUtil.writePromiseConfig(out, debugPromises, debugPromises);
            if (isWebDevBajaScript) {
                RequireJsUtil.exposeGlobalBajaScript(out);
            }
            out.inlineScriptTag(this.defineSystemProperties(), new Object[0]);
        }
    }

    private static void writePromiseConfig(ConfigBuilder out, boolean warnings, boolean longStackTraces) throws IOException {
        out.inlineScriptTag("require(['Promise'], function (Promise) {if (!Promise.config) { return; }Promise.config({warnings: %b,longStackTraces: %b,cancellation: false, monitoring: false});});", new Object[]{warnings, longStackTraces});
    }

    private static void exposeGlobalBajaScript(ConfigBuilder out) throws IOException {
        out.inlineScriptTag("require(['baja!'], function (baja) { window.baja = baja; });", new Object[0]);
    }

    private static JSONObject getLogLevelsConfig(Context cx) {
        return Sys.findService((Type)BLoggingService.TYPE).map(service -> {
            BLoggingService loggingService = (BLoggingService)service;
            return loggingService.getEnableRemoteLogging() ? new JSONObject(loggingService.getLevels(cx)) : null;
        }).orElse(null);
    }

    public static String getUrlVersion() {
        if (DEBUG_ARGS) {
            return String.valueOf(BAbsTime.now().getMillis());
        }
        return URL_VERSION;
    }

    public String defineSystemProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("define('niagaraSystemProperties', function () {\n");
        sb.append("  return {\n");
        sb.append("    ");
        String jsonPairs = AccessController.doPrivileged(() -> RequireJsUtil.getExposedSystemProperties().stream().map(RequireJsUtil::toJsonPair).filter(Objects::nonNull).collect(Collectors.joining(",\n    ")));
        sb.append(jsonPairs);
        sb.append("\n  };\n");
        sb.append("});\n");
        return sb.toString();
    }

    private static String toJsonPair(String propKey) {
        String propValue = System.getProperty(propKey);
        if (propValue != null) {
            propValue = propValue.replace("\\", "\\\\").replace("\"", "\\\"");
            return String.join((CharSequence)"", "\"", propKey, "\": \"", propValue, "\"");
        }
        return null;
    }

    private static List<String> getExposedSystemProperties() {
        return Arrays.asList(EXPOSED_SYSTEM_PROPERTIES);
    }

    public static String getModulePrefix(boolean useLocalWbRc) {
        return useLocalWbRc ? wbModulePrefix : remoteModulePrefix;
    }

    public static <E extends Exception> void withRequiredBuiltFiles(PrintWriter out, RunnableCanThrowException<E> doIt, BIWebResource.DependencyGraph deps) throws E {
        int i;
        JSONArray builtFileGroups = deps.toJSON();
        int steps = builtFileGroups.length();
        for (i = 0; i < steps; ++i) {
            out.write("require(");
            out.write(builtFileGroups.get(i).toString());
            out.write(", function () {\n");
        }
        doIt.run();
        if (steps > 0) {
            out.write(10);
            for (i = 0; i < steps; ++i) {
                out.write("});\n");
            }
        }
    }

    public static <E extends Exception> void withRequiredBuiltFiles(PrintWriter out, RunnableCanThrowException<E> doIt, Collection<? extends BIWebResource> deps) throws E {
        RequireJsUtil.withRequiredBuiltFiles(out, doIt, BIWebResource.resolve(deps));
    }

    public static <E extends Exception> void withRequiredBuiltFiles(PrintWriter out, RunnableCanThrowException<E> doIt, BIWebResource ... deps) throws E {
        RequireJsUtil.withRequiredBuiltFiles(out, doIt, Arrays.asList(deps));
    }

    /*
     * Exception decompiling
     */
    public static String wrapInBuiltfileRequireScript(String js, BIWebResource.DependencyGraph deps) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String wrapInBuiltfileRequireScript(String js, Collection<? extends BIWebResource> deps) {
        return RequireJsUtil.wrapInBuiltfileRequireScript(js, BIWebResource.resolve(deps));
    }

    public static String wrapInBuiltfileRequireScript(String js, BIWebResource ... deps) {
        return RequireJsUtil.wrapInBuiltfileRequireScript(js, Arrays.asList(deps));
    }

    private static boolean isWebDevJs() {
        return WebDev.get("js").isEnabled();
    }

    private static boolean isWebDevBajaScript() {
        return WebDev.get("bajaScript").isEnabled();
    }

    private static /* synthetic */ void lambda$wrapInBuiltfileRequireScript$3(HtmlWriter html, String js) throws RuntimeException {
        html.w((Object)js);
    }

    private class ConfigBuilder {
        private final Writer writer;
        private final String urlVersion;

        private ConfigBuilder(Writer writer, String urlVersion) {
            this.writer = writer;
            this.urlVersion = urlVersion;
        }

        private ConfigBuilder w(String s, Object ... objs) throws IOException {
            this.writer.write(String.format(s, objs));
            this.writer.write("\n");
            return this;
        }

        private ConfigBuilder plugin(String pluginName, String value) throws IOException {
            String rjsId = "nmodule/" + value;
            this.rjsConfig("map|*|" + pluginName, "'%s'", rjsId);
            if (RequireJsUtil.isWebDevJs()) {
                this.rjsConfig("paths|" + rjsId, "'%s%s'", RequireJsUtil.this.modulePrefix, value);
            }
            return this;
        }

        private ConfigBuilder map(String moduleName, String replacement) throws IOException {
            this.rjsConfig("map|*|" + moduleName, "'%s'", replacement);
            this.rjsConfig("map|" + replacement + '|' + moduleName, "'%s'", moduleName);
            return this;
        }

        private ConfigBuilder path(String key, String value) throws IOException {
            return this.path(key, value, "");
        }

        private ConfigBuilder path(String key, String value, String optional) throws IOException {
            return this.rjsConfig("paths|" + key, "'%s%s%s'", RequireJsUtil.this.modulePrefix, value, optional);
        }

        private ConfigBuilder rjsConfig(String path, String value, Object ... objs) throws IOException {
            return this.w("rjsConfig('" + path + "', " + value + ");", objs);
        }

        private ConfigBuilder rjsConfig(String path, int value) throws IOException {
            return this.rjsConfig(path, String.valueOf(value), new Object[0]);
        }

        private ConfigBuilder rjsConfig(String path, boolean value) throws IOException {
            return this.rjsConfig(path, String.valueOf(value), new Object[0]);
        }

        private ConfigBuilder openScriptTag() throws IOException {
            return this.w("<script type='text/javascript'>", new Object[0]);
        }

        private ConfigBuilder closeScriptTag() throws IOException {
            return this.w("</script>", new Object[0]);
        }

        private ConfigBuilder importRequireJs(BOrd main, boolean minified) throws IOException {
            return this.w("<script type='text/javascript' %s src='%sjs/com/tridium/js/ext/require/%s?version=%s'></script>", !main.isNull() ? String.format("data-main='%s'", RequireJsUtil.this.useLocalWbRc ? JsInfo.toRequireJsId(main) : TextUtil.replace((String)main.toString(), (String)RequireJsUtil.initialModulePrefix, (String)RequireJsUtil.this.modulePrefix)) : "", RequireJsUtil.this.modulePrefix, minified ? "require.min.js" : "require.js", this.urlVersion);
        }

        private ConfigBuilder importJs(String pathStartingWithModuleName) throws IOException {
            return this.w("<script type='text/javascript' src='%s%s?version=%s'></script>", RequireJsUtil.this.modulePrefix, pathStartingWithModuleName, this.urlVersion);
        }

        private ConfigBuilder inlineScriptTag(String js, Object ... args) throws IOException {
            return this.openScriptTag().w(js, args).closeScriptTag();
        }
    }
}

