/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import java.io.File;
import java.security.AccessController;
import java.util.regex.Pattern;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.space.BISpace;
import javax.baja.sys.BModule;
import javax.baja.web.WebDev;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpHeaderUtil {
    private static final Pattern FILE_NAME_REPLACE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n|\")", 8);
    public static int MAX_AGE_ONE_DAY = 86400;
    public static int MAX_AGE_THREE_DAYS = 259200;
    public static int MAX_AGE_THIRTY_DAYS = 2592000;
    public static final String H_ACCEPT_ENCODING = "accept-encoding";
    public static final String H_CACHE_CONTROL = "cache-control";
    public static final String H_CONTENT_ENCODING = "content-encoding";
    public static final String H_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String H_LAST_MODIFIED = "Last-Modified";
    public static final String H_TRANSFER_ENCODING = "transfer-encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String ADD_EXPIRES_PROPERTY = "niagara.web.addExpires";
    private static boolean ADD_EXPIRES_PROPERTY_VALUE = AccessController.doPrivileged(() -> Boolean.getBoolean(ADD_EXPIRES_PROPERTY));

    public static long getLastModified(BIFile file) {
        return file.getLastModified().getMillis() / 1000L * 1000L;
    }

    public static long getLastModified(File file) {
        return file.lastModified() / 1000L * 1000L;
    }

    public static void setLastModified(HttpServletResponse res, BIFile file) {
        long lastMod = HttpHeaderUtil.getLastModified(file);
        res.setDateHeader(H_LAST_MODIFIED, lastMod);
    }

    public static void setLastModified(HttpServletResponse res, File file) {
        long lastMod = HttpHeaderUtil.getLastModified(file);
        res.setDateHeader(H_LAST_MODIFIED, lastMod);
    }

    public static boolean isModifiedSince(HttpServletRequest req, BIFile file) {
        long lastMod = HttpHeaderUtil.getLastModified(file);
        long ifMod = req.getDateHeader(H_IF_MODIFIED_SINCE);
        return ifMod == -1L || lastMod > ifMod;
    }

    public static void cacheAndRevalidateAfter(HttpServletResponse res, int seconds) {
        res.setHeader(H_CACHE_CONTROL, "private, must-revalidate, max-age=" + seconds);
    }

    public static void cacheAndAlwaysRevalidate(HttpServletResponse res) {
        res.setHeader(H_CACHE_CONTROL, "private, must-revalidate");
    }

    public static void neverCache(HttpServletResponse res) {
        res.setHeader(H_CACHE_CONTROL, "no-cache, no-store");
    }

    public static boolean shouldAddExpires(BIFile file) {
        if (!ADD_EXPIRES_PROPERTY_VALUE) {
            return false;
        }
        BFileSpace fileSpace = file.getFileSpace();
        return fileSpace != null && BModule.isModuleFileSpace((BISpace)fileSpace);
    }

    public static boolean shouldDisableCache() {
        return WebDev.get("fileServlet").isEnabled();
    }

    public static void setCacheHeader(HttpServletResponse res, int seconds) {
        if (HttpHeaderUtil.shouldDisableCache()) {
            HttpHeaderUtil.neverCache(res);
        } else {
            HttpHeaderUtil.cacheAndRevalidateAfter(res, seconds);
        }
    }

    public static String getContentDispositionFileName(String fileName, boolean attachment) {
        String contentDisposition = attachment ? "attachment; " : "";
        fileName = FILE_NAME_REPLACE_PATTERN.matcher(fileName).replaceAll("_");
        return String.format("%sfilename=\"%s\"", contentDisposition, fileName);
    }
}

