/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.nre.util.InterfaceNetworkSettings;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="validateHostHeader", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="validHostHeaders", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BHostHeaderValidationSettings
extends BComponent
implements IPropertyValidator {
    @Generated
    public static final Property validateHostHeader = BHostHeaderValidationSettings.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property validHostHeaders = BHostHeaderValidationSettings.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BHostHeaderValidationSettings.class);
    private Set<String> mergedValidHostHeaders = null;
    private static final String SPLIT_REGEX = "\\s*[;,]\\s*";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK_IPV4 = "127.0.0.1";
    private static final String LOOPBACK_IPV6 = "::1";

    @Generated
    public boolean getValidateHostHeader() {
        return this.getBoolean(validateHostHeader);
    }

    @Generated
    public void setValidateHostHeader(boolean v) {
        this.setBoolean(validateHostHeader, v, null);
    }

    @Generated
    public String getValidHostHeaders() {
        return this.getString(validHostHeaders);
    }

    @Generated
    public void setValidHostHeaders(String v) {
        this.setString(validHostHeaders, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BWebService;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.initValidHostHeaders();
        }
        super.started();
    }

    public void stationStarted() throws Exception {
        this.initValidHostHeaders();
        super.stationStarted();
    }

    public void changed(Property property, Context context) {
        if (Sys.isStationStarted() && validHostHeaders.equals(property)) {
            this.initValidHostHeaders();
        }
        super.changed(property, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        String proposedHostHeaders = ((BString)validatable.getProposedValue(validHostHeaders)).getString();
        StringJoiner invalidHostHeaders = new StringJoiner(", ");
        for (String configuredHostHeader : proposedHostHeaders.trim().split(SPLIT_REGEX)) {
            String hostHeader = configuredHostHeader.trim();
            BInternetAddress address = null;
            try {
                address = new BInternetAddress(hostHeader);
            }
            catch (IllegalArgumentException ie) {
                invalidHostHeaders.add(hostHeader);
            }
            if (null == address || address.getHost() == null) continue;
            String hostname = address.getHost();
            if (hostname.startsWith("*.")) {
                if (IPAddressUtil.isHostname((String)hostname.substring(hostname.indexOf(46) + 1))) continue;
                invalidHostHeaders.add(hostname);
                continue;
            }
            if (this.isHostHeaderFormatValid(hostname)) continue;
            invalidHostHeaders.add(hostname);
        }
        if (invalidHostHeaders.length() > 0) {
            throw new LocalizableRuntimeException("web", "web.hostHeaderValidation.invalidHostHeader", new Object[]{invalidHostHeaders});
        }
    }

    public boolean isHostHeaderFormatValid(String hostHeader) {
        try {
            BInternetAddress address = new BInternetAddress(hostHeader);
            String hostname = address.getHost();
            if (hostname != null) {
                if (hostname.startsWith("[") && hostname.endsWith("]")) {
                    hostname = hostname.substring(1, hostname.length() - 1).trim();
                }
                if (!(IPAddressUtil.isHostname((String)hostname) || IPAddressUtil.isIpv4Address((String)hostname) || IPAddressUtil.isIpv6Address((String)hostname) || IPAddressUtil.isIpv4MappedAddress((String)hostname))) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            BWebService.log.log(Level.FINE, "Host header format could not be validated.", e);
            return false;
        }
    }

    public boolean isHostHeaderValid(String hostHeader, boolean isSecure) throws SecurityException {
        if (!this.getValidateHostHeader()) {
            return true;
        }
        try {
            String scheme = isSecure ? "https://" : "http://";
            URI uri = new URI(scheme + hostHeader);
            int port = uri.getPort();
            return this.isHostHeaderPortValid(port, isSecure) && this.isHostHeaderHostnameValid(uri.getHost(), port);
        }
        catch (Exception e) {
            BWebService.log.log(Level.FINE, "Host header could not be validated.", e);
            return false;
        }
    }

    private boolean isHostHeaderPortValid(int port, boolean isSecure) {
        int expectedPort;
        BWebService webService = (BWebService)this.getParent();
        if (webService == null) {
            BWebService.log.fine("Could not find web service to validate host header port");
            return false;
        }
        if (port == -1) {
            port = isSecure ? 443 : 80;
        }
        int n = expectedPort = isSecure ? webService.getHttpsPort().getPublicServerPort() : webService.getHttpPort().getPublicServerPort();
        if (expectedPort != port) {
            if (BWebService.log.isLoggable(Level.FINE)) {
                BWebService.log.fine("Expected host header port " + expectedPort + " but found " + port);
            }
            return false;
        }
        return true;
    }

    private boolean isHostHeaderHostnameValid(String hostHeaderHostname, int port) {
        String effectiveHostHeaderHostname = hostHeaderHostname;
        if (hostHeaderHostname.startsWith("[") && hostHeaderHostname.endsWith("]")) {
            effectiveHostHeaderHostname = hostHeaderHostname.substring(1, hostHeaderHostname.length() - 1);
        }
        if (IPAddressUtil.isIpv6AddressFormat((String)effectiveHostHeaderHostname)) {
            if (effectiveHostHeaderHostname.equals(LOOPBACK_IPV6)) {
                effectiveHostHeaderHostname = BHostHeaderValidationSettings.updateAddress(hostHeaderHostname);
            } else {
                String expandedAddress = IPAddressUtil.expandIPv6NumericString((String)effectiveHostHeaderHostname, (boolean)false);
                effectiveHostHeaderHostname = BHostHeaderValidationSettings.updateAddress(expandedAddress);
            }
        }
        for (String validHostHeader : this.getMergedValidHostHeaders()) {
            if (!TridiumHostnameVerifier.verifyHostname((String)effectiveHostHeaderHostname, (String)validHostHeader) && !TridiumHostnameVerifier.verifyHostname((String)(effectiveHostHeaderHostname + ":" + port), (String)validHostHeader)) continue;
            return true;
        }
        if (BWebService.log.isLoggable(Level.FINE)) {
            BWebService.log.fine("Host header does match configured valid host headers: " + effectiveHostHeaderHostname);
        }
        return false;
    }

    public void autoPopulateValidHostHeaders() {
        if (!this.getValidHostHeaders().isEmpty()) {
            return;
        }
        HashSet<String> validHostHeaders = new HashSet<String>();
        this.addRedirectHostname(validHostHeaders);
        this.addTcpIpPlatformServiceHostname(validHostHeaders);
        this.addInetAddressHostname(validHostHeaders);
        this.setValidHostHeaders(String.join((CharSequence)";", validHostHeaders));
    }

    private void addRedirectHostname(Set<String> validHostHeaders) {
        String hostname;
        BWebService webService = (BWebService)this.getParent();
        if (webService != null && webService.getHostnameRedirectSettings().getRedirectToHostname() && !(hostname = webService.getHostnameRedirectSettings().getHostname()).isEmpty()) {
            validHostHeaders.add(hostname);
            if (BWebService.log.isLoggable(Level.FINE)) {
                BWebService.log.fine("Added " + hostname + " from Web Service redirect settings to valid host headers");
            }
        }
    }

    private void addTcpIpPlatformServiceHostname(Set<String> validHostHeaders) {
        try {
            BComponent tcpIpPlatformService = Sys.getService((Type)BTypeSpec.make((String)"platform", (String)"TcpIpPlatformService").getResolvedType());
            AccessController.doPrivileged(() -> {
                Method loadProperties = tcpIpPlatformService.getClass().getMethod("doCheckPropertiesLoaded", new Class[0]);
                loadProperties.invoke((Object)tcpIpPlatformService, new Object[0]);
                return null;
            });
            BComponent tcpIpHostSettings = (BComponent)tcpIpPlatformService.get("settings");
            String hostname = ((BString)tcpIpHostSettings.get("hostName")).getString();
            if (!hostname.isEmpty()) {
                validHostHeaders.add(hostname);
                if (BWebService.log.isLoggable(Level.FINE)) {
                    BWebService.log.fine("Added " + hostname + " from Tcp Ip Platform Service to valid host headers");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addInetAddressHostname(Set<String> validHostHeaders) {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            if (!hostname.isEmpty()) {
                validHostHeaders.add(hostname);
                if (BWebService.log.isLoggable(Level.FINE)) {
                    BWebService.log.fine("Added " + hostname + " from InetAddress to valid host headers");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Set<String> getValidLocalIpAddresses() {
        InterfaceNetworkSettings[] settings;
        HashSet<String> validLocalIpAddresses = new HashSet<String>();
        for (InterfaceNetworkSettings setting : settings = IPAddressUtil.getLocalHostInterfaces()) {
            validLocalIpAddresses.add(BHostHeaderValidationSettings.updateAddress(setting.getInetAddress().getHostAddress()));
        }
        validLocalIpAddresses.add(LOCALHOST);
        validLocalIpAddresses.add(LOOPBACK_IPV4);
        validLocalIpAddresses.add(BHostHeaderValidationSettings.updateAddress(LOOPBACK_IPV6));
        return validLocalIpAddresses;
    }

    private static String updateAddress(String address) {
        boolean isIPv6 = IPAddressUtil.isIpv6Address((String)address);
        String updatedAddress = address;
        int index = address.indexOf("%");
        if (index >= 0) {
            updatedAddress = address.substring(0, index);
        }
        return isIPv6 && !updatedAddress.startsWith("[") && !updatedAddress.endsWith("]") ? "[" + updatedAddress + "]" : updatedAddress;
    }

    private Set<String> getMergedValidHostHeaders() {
        if (this.mergedValidHostHeaders == null) {
            this.initValidHostHeaders();
        }
        return this.mergedValidHostHeaders;
    }

    private void initValidHostHeaders() {
        this.mergedValidHostHeaders = new HashSet<String>();
        this.mergedValidHostHeaders.addAll(Arrays.asList(this.getValidHostHeaders().trim().split(SPLIT_REGEX)));
        this.mergedValidHostHeaders.addAll(BHostHeaderValidationSettings.getValidLocalIpAddresses());
        if (BWebService.log.isLoggable(Level.FINER)) {
            StringJoiner validHostHeaders = new StringJoiner(", ");
            for (String hostHeader : this.mergedValidHostHeaders) {
                validHostHeaders.add(hostHeader);
            }
            BWebService.log.finer("Found valid host headers: " + validHostHeaders);
        }
    }
}

