/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="start", type="BTime", defaultValue="BTime.make(0,0,0)", flags=0x10000000), @NiagaraProperty(name="finish", type="BTime", defaultValue="BTime.make(0,0,0)", flags=0x10000000)})
public class BTimeSchedule
extends BAbstractSchedule {
    @Generated
    public static final Property start = BTimeSchedule.newProperty((int)0x10000000, (BValue)BTime.make((int)0, (int)0, (int)0), null);
    @Generated
    public static final Property finish = BTimeSchedule.newProperty((int)0x10000000, (BValue)BTime.make((int)0, (int)0, (int)0), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeSchedule.class);

    @Generated
    public BTime getStart() {
        return (BTime)this.get(start);
    }

    @Generated
    public void setStart(BTime v) {
        this.set(start, (BValue)v, null);
    }

    @Generated
    public BTime getFinish() {
        return (BTime)this.get(finish);
    }

    @Generated
    public void setFinish(BTime v) {
        this.set(finish, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTimeSchedule() {
    }

    public BTimeSchedule(BTime start, BTime finish) {
        this.setStart(start);
        this.setFinish(finish);
    }

    public BTimeSchedule(BTime start, BTime finish, BStatusValue output) {
        this.setStart(start);
        this.setFinish(finish);
        this.setEffectiveValue(output);
    }

    @Override
    public boolean isEffective(BAbsTime at) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        return this.isEffective(at.getTimeOfDayMillis());
    }

    public boolean isEffective(BTime at) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        return this.isEffective(at.getTimeOfDayMillis());
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        long fnMs;
        long adjusted;
        if (this.getAlwaysEffective()) {
            return null;
        }
        BTime st = this.getStart();
        BTime fn = this.getFinish();
        long stMs = st.getTimeOfDayMillis();
        if (stMs >= (adjusted = this.finMillis(fnMs = fn.getTimeOfDayMillis()))) {
            return null;
        }
        BAbsTime date = after;
        BTime time = st;
        long inMs = after.getTimeOfDayMillis();
        if (inMs >= adjusted) {
            date = date.nextDay();
        } else if (inMs >= stMs) {
            if (fnMs == 0L) {
                date = date.nextDay();
            }
            time = fn;
        }
        BAbsTime returnValue = BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)time.getSecond(), (int)time.getMillisecond(), (BTimeZone)after.getTimeZone(), (Context)BFacets.make((String)"timeMode", (int)5));
        return returnValue;
    }

    public String toString(Context cx) {
        if (this.getEffectiveValue() == null) {
            return lex.getText("timeSchedule.noEffective.toString", new Object[]{this.getStart().toString(cx), this.getFinish().toString(cx)});
        }
        return lex.getText("timeSchedule.toString", new Object[]{this.getStart().toString(cx), this.getFinish().toString(cx), this.getEffectiveValue().valueToString(cx)});
    }

    private final boolean isEffective(long ms) {
        long finishMillis = this.finMillis(this.getFinish().getTimeOfDayMillis());
        return this.getStart().getTimeOfDayMillis() <= ms && ms < finishMillis;
    }

    private final long finMillis(long ms) {
        if (ms == 0L) {
            return 86400000L;
        }
        return ms;
    }
}

