/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.schedule.BYearSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="union", type="boolean", defaultValue="false", flags=0x10000000, override=true), @NiagaraProperty(name="yearSchedule", type="BYearSchedule", defaultValue="new BYearSchedule().initAlwaysEffective(true)", flags=1), @NiagaraProperty(name="monthSchedule", type="BMonthSchedule", defaultValue="new BMonthSchedule().initSingleSelection(true)", flags=1), @NiagaraProperty(name="daySchedule", type="BDayOfMonthSchedule", defaultValue="new BDayOfMonthSchedule().initSingleSelection(true)", flags=1), @NiagaraProperty(name="weekdaySchedule", type="BWeekdaySchedule", defaultValue="new BWeekdaySchedule().initSingleSelection(true)", flags=1)})
public class BDateSchedule
extends BCompositeSchedule {
    @Generated
    public static final Property union = BDateSchedule.newProperty((int)0x10000000, (boolean)false, null);
    @Generated
    public static final Property yearSchedule = BDateSchedule.newProperty((int)1, (BValue)new BYearSchedule().initAlwaysEffective(true), null);
    @Generated
    public static final Property monthSchedule = BDateSchedule.newProperty((int)1, (BValue)new BMonthSchedule().initSingleSelection(true), null);
    @Generated
    public static final Property daySchedule = BDateSchedule.newProperty((int)1, (BValue)new BDayOfMonthSchedule().initSingleSelection(true), null);
    @Generated
    public static final Property weekdaySchedule = BDateSchedule.newProperty((int)1, (BValue)new BWeekdaySchedule().initSingleSelection(true), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDateSchedule.class);

    @Generated
    public BYearSchedule getYearSchedule() {
        return (BYearSchedule)this.get(yearSchedule);
    }

    @Generated
    public void setYearSchedule(BYearSchedule v) {
        this.set(yearSchedule, (BValue)v, null);
    }

    @Generated
    public BMonthSchedule getMonthSchedule() {
        return (BMonthSchedule)this.get(monthSchedule);
    }

    @Generated
    public void setMonthSchedule(BMonthSchedule v) {
        this.set(monthSchedule, (BValue)v, null);
    }

    @Generated
    public BDayOfMonthSchedule getDaySchedule() {
        return (BDayOfMonthSchedule)this.get(daySchedule);
    }

    @Generated
    public void setDaySchedule(BDayOfMonthSchedule v) {
        this.set(daySchedule, (BValue)v, null);
    }

    @Generated
    public BWeekdaySchedule getWeekdaySchedule() {
        return (BWeekdaySchedule)this.get(weekdaySchedule);
    }

    @Generated
    public void setWeekdaySchedule(BWeekdaySchedule v) {
        this.set(weekdaySchedule, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDateSchedule() {
    }

    public BDateSchedule(int day, BMonth mo, int year) {
        this.setDay(day);
        this.setMonth(mo);
        this.setYear(year);
    }

    public int compareTo(BAbsTime arg) {
        int thisTmp = this.getYear();
        int argTmp = arg.getYear();
        if (thisTmp >= 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getMonth();
        argTmp = arg.getMonth().getOrdinal();
        if (thisTmp >= 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getDay();
        argTmp = arg.getDay();
        if (thisTmp > 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getWeekday();
        argTmp = arg.getWeekday().getOrdinal();
        if (thisTmp > 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        return 0;
    }

    public int compareTo(BDateSchedule arg) {
        int thisTmp = this.getYear();
        int argTmp = arg.getYear();
        if (thisTmp >= 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getMonth();
        argTmp = arg.getMonth();
        if (thisTmp >= 0 && argTmp >= 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getDay();
        argTmp = arg.getDay();
        if (thisTmp > 0 && argTmp > 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        thisTmp = this.getWeekday();
        argTmp = arg.getWeekday();
        if (thisTmp > 0) {
            if (thisTmp < argTmp) {
                return -1;
            }
            if (thisTmp > argTmp) {
                return 1;
            }
        }
        return 0;
    }

    public int getDay() {
        if (this.getDaySchedule().isAlwaysEffective()) {
            return -1;
        }
        return this.getDaySchedule().first();
    }

    public int getMonth() {
        if (this.getMonthSchedule().isAlwaysEffective()) {
            return -1;
        }
        return this.getMonthSchedule().first();
    }

    public int getWeekday() {
        if (this.getWeekdaySchedule().isAlwaysEffective()) {
            return -1;
        }
        return this.getWeekdaySchedule().first();
    }

    public int getYear() {
        if (this.getYearSchedule().getAlwaysEffective()) {
            return -1;
        }
        return this.getYearSchedule().getYear();
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        int year = this.getYear();
        if (year > -1) {
            int month;
            int ay = after.getYear();
            if (ay > year) {
                return null;
            }
            if (ay == year && (month = this.getMonth()) >= 0 && after.getMonth().getOrdinal() > month) {
                return null;
            }
        }
        return super.nextEvent(after);
    }

    public void setDay(int dy) {
        this.setDay(dy, null);
    }

    public void setMonth(int mo) {
        this.setMonth(mo, null);
    }

    public void setMonth(BMonth mo) {
        this.setMonth(mo, null);
    }

    public void setWeekday(int wd) {
        this.setWeekday(wd, null);
    }

    public void setYear(int yr) {
        this.setYear(yr, null);
    }

    public void setDay(int dy, Context cx) {
        if (dy < 0) {
            this.getDaySchedule().clear();
        } else {
            this.getDaySchedule().clear().add(dy, cx);
        }
    }

    public void setMonth(int mo, Context cx) {
        if (mo < 0) {
            this.getMonthSchedule().clear();
        } else {
            this.getMonthSchedule().clear().add(mo, cx);
        }
    }

    public void setMonth(BMonth mo, Context cx) {
        if (mo == null) {
            this.getMonthSchedule().clear();
        } else {
            this.getMonthSchedule().clear().add((BEnum)mo, cx);
        }
    }

    public void setWeekday(int wd, Context cx) {
        if (wd < 0) {
            this.getWeekdaySchedule().clear();
        } else {
            this.getWeekdaySchedule().clear().add(wd, cx);
        }
    }

    public void setYear(int yr, Context cx) {
        this.getYearSchedule().initYear(yr, cx).setAlwaysEffective(yr < 0);
    }

    public String toString(Context cx) {
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        return l.get("type.dateSchedule") + ": " + this.criteriaString(cx);
    }

    protected String criteriaString(Context cx) {
        boolean criteria = false;
        StringBuilder buf = new StringBuilder();
        int i = this.getWeekday();
        if (i >= 0) {
            BWeekday w = BWeekday.make((int)i);
            buf.append(w.getShortDisplayTag(cx));
            criteria = true;
        }
        if ((i = this.getDay()) >= 0) {
            if (criteria) {
                buf.append(' ');
            }
            buf.append(i);
            criteria = true;
        }
        if ((i = this.getMonth()) >= 0) {
            Lexicon l;
            if (criteria) {
                buf.append(' ');
            }
            if (i == 12) {
                l = Lexicon.make(BDateSchedule.class);
                buf.append(l.get("month.jan_mar_may_jul_sep_nov"));
            } else if (i == 13) {
                l = Lexicon.make(BDateSchedule.class);
                buf.append(l.get("month.feb_apr_jun_aug_oct_dec"));
            } else {
                BMonth m = BMonth.make((int)i);
                buf.append(m.getShortDisplayTag(cx));
            }
            criteria = true;
        }
        if ((i = this.getYear()) >= 0) {
            if (criteria) {
                buf.append(' ');
            }
            buf.append(i);
            criteria = true;
        }
        if (criteria) {
            return buf.toString();
        }
        return "*";
    }
}

