/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import java.io.Serializable;

public class SimpleSortedSet
implements Serializable {
    protected static final int DATA = 1;
    protected static final int NEXT = 0;
    private Object[] first;
    private Object[] last;
    private int size = 0;

    public boolean add(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object[] pred = this.predecessor(o);
        Object[] next = this.first;
        Object[] e = SimpleSortedSet.newEntry(o);
        if (pred != null) {
            next = SimpleSortedSet.next(pred);
        }
        e[0] = next;
        if (next == null) {
            this.last = e;
        } else if (next[1].equals(o)) {
            return false;
        }
        if (pred == null) {
            this.first = e;
        } else {
            pred[0] = e;
        }
        ++this.size;
        return true;
    }

    public Object after(Object o) {
        if (this.size == 0) {
            return null;
        }
        Object[] pred = this.predecessor(o);
        pred = pred == null ? this.first : SimpleSortedSet.next(pred);
        if (pred == null) {
            return null;
        }
        switch (this.compare(pred[1], o)) {
            case 0: {
                pred = SimpleSortedSet.next(pred);
                if (pred == null) {
                    return null;
                }
                return pred[1];
            }
        }
        return pred[1];
    }

    public Object before(Object o) {
        Object[] pred = this.predecessor(o);
        if (pred == null) {
            return null;
        }
        return pred[1];
    }

    public void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    public boolean contains(Object o) {
        Object[] pred = this.predecessor(o);
        pred = pred == null ? this.first : SimpleSortedSet.next(pred);
        if (pred == null) {
            return false;
        }
        return this.compare(pred[1], o) == 0;
    }

    public Object first() {
        if (this.first == null) {
            return null;
        }
        return this.first[1];
    }

    public Object get(int idx) {
        Object[] node = this.first;
        while (--idx >= 0) {
            node = (Object[])node[0];
        }
        return node[1];
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public Object last() {
        if (this.last == null) {
            return null;
        }
        return this.last[1];
    }

    public boolean remove(Object d) {
        Object[] pred = this.predecessor(d);
        Object[] target = null;
        target = pred == null ? this.first : SimpleSortedSet.next(pred);
        if (target == null) {
            return false;
        }
        if (this.compare(target[1], d) == 0) {
            --this.size;
            if (target == this.last) {
                this.last = pred;
            }
            if (target == this.first) {
                this.first = SimpleSortedSet.next(target);
            } else if (pred != null) {
                pred[0] = SimpleSortedSet.next(target);
            }
            target[0] = null;
            target[1] = null;
            return true;
        }
        return false;
    }

    public final int size() {
        return this.size;
    }

    public Object[] toArray(Object[] array) {
        int len = Math.min(array.length, this.size);
        Object[] o = this.first;
        for (int i = 0; i < len; ++i) {
            array[i] = o[1];
            o = SimpleSortedSet.next(o);
        }
        return array;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    protected int compare(Object o1, Object o2) {
        return String.valueOf(o1).compareTo(String.valueOf(o2));
    }

    private static final Object[] newEntry(Object data) {
        Object[] o = new Object[2];
        o[1] = data;
        return o;
    }

    private static final Object[] next(Object[] node) {
        return (Object[])node[0];
    }

    private final Object[] predecessor(Object o) {
        Object[] pred = null;
        Object[] current = this.first;
        while (current != null) {
            if (this.compare(current[1], o) >= 0) {
                return pred;
            }
            pred = current;
            current = SimpleSortedSet.next(current);
        }
        return pred;
    }

    public class Iterator {
        Object[] cur;
        Object[] next;

        public Iterator() {
            this.next = SimpleSortedSet.this.first;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            this.cur = this.next;
            this.next = (Object[])this.cur[0];
            return this.cur[1];
        }
    }
}

