/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.logging.LogSettings;
import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;

public class ScheduleSpyManager {
    private Thread standardOutPrinter;
    private TimedStackTrace greatest;
    private static Logger logger = Logger.getLogger("schedule.scheduleManager");
    private final HashMap<String, TimedStackTrace> stacks = new HashMap();
    private long count = 0L;
    private long totalCount = 0L;
    private final int CLOSED_MAX_ENTRIES = 10;
    private final LinkedHashMap<String, TimedStackTrace> closedStacks = new LinkedHashMap<String, TimedStackTrace>(10){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimedStackTrace> eldest) {
            return this.size() > 10;
        }
    };
    private BAbsTime dstFixTime;
    private String dstFixInfo;

    public ScheduleSpyManager() {
        SummaryPage summary = new SummaryPage();
        Nre.spySysManagers.add("scheduleManager", (Spy)summary);
    }

    public static String getId(Runnable runnable) {
        return "" + runnable.toString();
    }

    public void enqueueSpy(Runnable runnable) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        ++this.count;
        this.totalCount = Long.MAX_VALUE > this.totalCount ? ++this.totalCount : this.count;
        try {
            throw new Exception("EnqueueStackTrace");
        }
        catch (Exception e) {
            this.stacks.put(ScheduleSpyManager.getId(runnable), new TimedStackTrace(e, runnable));
            return;
        }
    }

    public void dequeueSpy(Runnable runnable) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        TimedStackTrace timedTrace = this.stacks.remove(ScheduleSpyManager.getId(runnable));
        if (timedTrace != null) {
            --this.count;
        } else {
            timedTrace = new TimedStackTrace(null, runnable);
        }
        try {
            throw new Exception("DequeueStackTrace");
        }
        catch (Exception e) {
            timedTrace.setClose(e);
            this.closedStacks.put(ScheduleSpyManager.getId(runnable), timedTrace);
            if (this.greatest == null || timedTrace.delta().compareTo((Object)this.greatest.delta()) > 0) {
                this.greatest = timedTrace;
            }
            return;
        }
    }

    public void daylightSavingsTimeFix(String info) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        this.dstFixTime = BAbsTime.now();
        this.dstFixInfo = info;
    }

    public static class TimedStackTrace {
        BAbsTime openTime = BAbsTime.now();
        BAbsTime closeTime;
        Exception openTrace;
        Exception closeTrace;
        Runnable runnable;

        TimedStackTrace(Exception openTrace, Runnable runnable) {
            this.openTrace = openTrace;
            this.runnable = runnable;
        }

        void setClose(Exception trace) {
            this.closeTime = BAbsTime.now();
            this.closeTrace = trace;
        }

        BRelTime delta() {
            if (this.closeTime != null) {
                return this.openTime.delta(this.closeTime);
            }
            return this.openTime.delta(BAbsTime.now());
        }
    }

    private static final class MessageSpy
    extends SpyDir {
        String message;

        private MessageSpy(String message) {
            this.message = message;
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps();
            out.propValueLink((Object)this.message, (Object)"..", (Object)"Return to Schedule Manager");
            out.endProps();
        }
    }

    public class SummaryPage
    extends SpyDir {
        public SummaryPage() {
            this.add("closed", (Spy)new ClosedSpy());
            this.add("standardOutStarter", (Spy)new StandardOutStarter());
        }

        public Spy find(String name) {
            if (name.equals("closed")) {
                return super.find("closed");
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"standardOutStarter")) {
                return super.find("standardOutStarter");
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"fine")) {
                if (!logger.isLoggable(Level.FINE)) {
                    try {
                        LogSettings logSettings = new LogSettings();
                        logSettings.setLogLevel("schedule.scheduleManager", Level.FINE);
                        LogSettings.reload((Properties)logSettings.getRawProperties());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new MessageSpy("Cannot set the log level:" + e.toString());
                    }
                }
                return new MessageSpy("Schedule Manager is now active");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) throws Exception {
            BFacets facets = BFacets.make((String)"showMilliseconds", (boolean)true);
            out.startProps();
            if (!logger.isLoggable(Level.FINE)) {
                out.prop((Object)"Schedule Manager Not Active", () -> out.mutatorButton("spy:/sysManagers/scheduleManager/fine", "Click here to save the schedule.scheduleManager Log Level as 'fine'"));
                out.endProps();
                return;
            }
            if (ScheduleSpyManager.this.standardOutPrinter != null) {
                out.prop((Object)"Standard Out Printer", () -> out.w((Object)"Running ").mutatorButton("standardOutStarter", "Stop"));
            } else {
                out.prop((Object)"Standard Out Printer", () -> out.mutatorButton("standardOutStarter", "Start"));
            }
            out.prop((Object)"Finished Queue Count", (Object)("" + (ScheduleSpyManager.this.totalCount - ScheduleSpyManager.this.count)));
            out.propValueLink((Object)"Recently Dequeued Stack Traces", (Object)"closed", (Object)"View");
            out.prop((Object)"Current Queue Size", (Object)("" + ScheduleSpyManager.this.count));
            if (ScheduleSpyManager.this.greatest != null && ScheduleSpyManager.this.greatest.delta().getMillis() > 0L) {
                out.prop((Object)"Longest Runnable", (Object)ScheduleSpyManager.getId(((ScheduleSpyManager)ScheduleSpyManager.this).greatest.runnable));
                out.prop((Object)"Longest Runnable Time", (Object)ScheduleSpyManager.this.greatest.delta());
            }
            if (ScheduleSpyManager.this.dstFixTime != null) {
                out.prop((Object)"Last Day Light Saving Time Fix Time", (Object)ScheduleSpyManager.this.dstFixTime);
                out.prop((Object)"Last Day Light Saving Time Fix Info", (Object)ScheduleSpyManager.this.dstFixInfo);
            }
            Collection collection = ScheduleSpyManager.this.stacks.values();
            Set keySet = ScheduleSpyManager.this.stacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            if (ScheduleSpyManager.this.count != (long)keys.length) {
                out.prop((Object)"Acknowledged Enqueue Count", (Object)("" + (ScheduleSpyManager.this.count - (long)keys.length)));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String name = "" + j;
                RemoveSpy removeSpy = new RemoveSpy(keys[j], name, ScheduleSpyManager.this.stacks);
                this.add(name, (Spy)removeSpy);
                out.prop((Object)("Enqueued " + j), () -> out.mutatorButton(name, "Acknowledge"));
                out.prop((Object)"Path", (Object)("" + keys[j]));
                TimedStackTrace timedTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Open Time ", (Object)timedTrace.delta());
                Exception lastStack = timedTrace.openTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }
    }

    public class StandardOutStarter
    extends SpyDir {
        private volatile boolean running = true;

        public void write(SpyWriter out) {
            if (ScheduleSpyManager.this.standardOutPrinter == null) {
                out.startProps();
                out.propValueLink((Object)"Started...", (Object)"..", (Object)"Return to Schedule Manager");
                out.endProps();
                ScheduleSpyManager.this.standardOutPrinter = new Thread(() -> {
                    this.running = true;
                    while (this.running) {
                        try {
                            Thread.sleep(10000L);
                            Collection collection = ScheduleSpyManager.this.stacks.values();
                            Set keySet = ScheduleSpyManager.this.stacks.keySet();
                            Object[] array = collection.toArray();
                            if (array.length > 0) {
                                System.out.println("***********OPEN RUNNABLES FOR SCHEDULE MANAGER****************");
                            }
                            Object[] keys = keySet.toArray();
                            for (int j = array.length - 1; j >= 0; --j) {
                                TimedStackTrace timedTrace = (TimedStackTrace)array[j];
                                System.out.println("Path:" + keys[j]);
                                System.out.println("Time Open:" + timedTrace.delta());
                                timedTrace.openTrace.printStackTrace();
                                System.out.println("*************************************************************");
                            }
                        }
                        catch (InterruptedException e) {
                            this.running = false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                ScheduleSpyManager.this.standardOutPrinter.start();
            } else {
                out.startProps();
                out.propValueLink((Object)"Stopped...", (Object)"..", (Object)"Return to Schedule Manager");
                out.endProps();
                this.running = false;
                ScheduleSpyManager.this.standardOutPrinter.interrupt();
                ScheduleSpyManager.this.standardOutPrinter = null;
            }
        }

        public String getTitle() {
            return "closed";
        }
    }

    public class ClosedSpy
    extends SpyDir {
        public ClosedSpy() {
            this.add("removeAll", (Spy)new RemoveAllSpy("removeAll", ScheduleSpyManager.this.closedStacks));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"removeAll")) {
                return super.find("removeAll");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            Collection collection = ScheduleSpyManager.this.closedStacks.values();
            Set keySet = ScheduleSpyManager.this.closedStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Recently Dequeued Stack Traces Count", (Object)("" + keys.length));
            if (array.length > 1) {
                out.prop((Object)"", (Object)out.mutatorButton("removeAll", "Acknowledge All"));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String name = "" + j;
                RemoveSpy removeSpy = new RemoveSpy(keys[j], name, ScheduleSpyManager.this.closedStacks);
                this.add(name, (Spy)removeSpy);
                out.prop((Object)("Dequeued Runnable" + j), () -> out.mutatorButton(name, "Acknowledge"));
                out.prop((Object)"Path", (Object)("" + keys[j]));
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Time In Queue ", (Object)timeTrace.delta());
                Exception lastStack = timeTrace.openTrace;
                if (lastStack == null) {
                    lastStack = timeTrace.closeTrace;
                }
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "closed";
        }
    }

    public class RemoveAllSpy
    extends SpyDir {
        private Object key;
        private final String title;
        private final HashMap<String, TimedStackTrace> hashMap;

        public RemoveAllSpy(String title, HashMap<String, TimedStackTrace> hashMap) {
            this.title = title;
            this.hashMap = hashMap;
        }

        public void write(SpyWriter out) {
            this.hashMap.clear();
            out.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                out.propValueLink((Object)"All Dequeue Stack Traces Acknowledged", (Object)"..", (Object)"Return to Dequeued Traces Summary");
            } else {
                out.propValueLink((Object)"All Enqueue Stack Traces Acknowledged", (Object)"..", (Object)"Return to Schedule Manager");
            }
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }

    public class RemoveSpy
    extends SpyDir {
        private final Object key;
        private final String title;
        private final HashMap<String, TimedStackTrace> hashMap;

        public RemoveSpy(Object key, String title, HashMap<String, TimedStackTrace> hashMap) {
            this.key = key;
            this.title = title;
            this.hashMap = hashMap;
        }

        public void write(SpyWriter out) {
            this.hashMap.remove(this.key);
            out.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Dequeued Traces Summary");
            } else {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Schedule Manager");
            }
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }
}

