/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.enums.BSnmpVariableTypeEnum;
import com.tridium.nSnmp.table.BSnmpSequence;
import com.tridium.nSnmp.table.BSnmpSequenceElement;
import com.tridium.nSnmp.table.BSnmpTable;
import com.tridium.nSnmp.table.BSnmpTableElementTypeEnum;
import com.tridium.nSnmp.ui.OidUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;

public class TableUtil {
    public static BSnmpTable makeSnmpTable(String oid, Mib mib) {
        BSnmpTable snmpTbl = new BSnmpTable();
        snmpTbl.setObjectIdentifier(oid);
        MibValueSymbol mvs = mib.getSymbolByOid(oid);
        if (!TableUtil.isSyntaxType(mvs, SequenceOfType.class)) {
            throw new BajaRuntimeException("Cannot create SnmpTable: not a sequence table");
        }
        MibValueSymbol ss = mvs.getChildren()[0];
        if (!TableUtil.isSyntaxType(ss, SequenceType.class)) {
            throw new BajaRuntimeException("Cannot create SnmpTable: not a sequenceType");
        }
        MibValueSymbol[] nds = ss.getChildren();
        BSnmpSequence seq = snmpTbl.getSequence();
        for (int i = 0; i < nds.length; ++i) {
            seq.add(SlotPath.escape((String)nds[i].getName()), (BValue)TableUtil.createSequenceElement(nds[i]));
        }
        return snmpTbl;
    }

    private static boolean isSyntaxType(MibValueSymbol mvs, Class<?> cl) {
        MibType mt = mvs.getType();
        if (!(mt instanceof SnmpObjectType)) {
            return false;
        }
        MibType syt = ((SnmpObjectType)mt).getSyntax();
        return cl.isInstance(syt);
    }

    private static BSnmpSequenceElement createSequenceElement(MibValueSymbol mvs) {
        SnmpObjectType sot = (SnmpObjectType)mvs.getType();
        BSnmpSequenceElement se = new BSnmpSequenceElement();
        se.setObjectIdentifier(mvs.getValue().toString());
        se.setElementName(mvs.getName());
        String objSyntax = TableUtil.getSyntax(sot.getSyntax());
        if (OidUtil.mibTypeValueMap.get(objSyntax) != null) {
            se.setDisplayHint(OidUtil.mibTypeValueMap.get(objSyntax));
        } else {
            se.setDisplayHint("");
        }
        boolean writable = OidUtil.getAccess(sot.getAccess()).isWriteable();
        se.setWriteable(writable);
        BSnmpVariableTypeEnum type = OidUtil.getVariableTypeFromTag(sot.getSyntax().getTag());
        se.setVariableType(type);
        BEnumRange er = null;
        MibType syn = sot.getSyntax();
        if (syn instanceof IntegerType && (er = OidUtil.getEnumRange((IntegerType)syn)) != null) {
            se.setElementType(BSnmpTableElementTypeEnum.statusEnum);
            se.setFacets(BFacets.makeEnum((BEnumRange)er));
        } else if (type.isNumeric()) {
            se.setElementType(BSnmpTableElementTypeEnum.statusNumeric);
        } else {
            se.setElementType(BSnmpTableElementTypeEnum.statusString);
        }
        return se;
    }

    private static String getSyntax(MibType syn) {
        if (syn.isPrimitive()) {
            return syn.getName();
        }
        return syn.getReferenceSymbol().getName();
    }
}

