/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.table.BSnmpSequence;
import com.tridium.nSnmp.table.BSnmpSequenceElement;
import com.tridium.nSnmp.table.BSnmpTable;
import com.tridium.nSnmp.table.BSnmpTableRow;
import com.tridium.nSnmp.ui.BSnmpMgrTable;
import com.tridium.nSnmp.ui.SnmpIcons;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"nSnmp:SnmpTable"}, requiredPermissions="r")})
public class BSnmpTableManager
extends BAbstractManager
implements SnmpIcons {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpTableManager.class);
    static Lexicon lex = UiLexicon.makeUiLexicon(BSnmpTableManager.class);
    TableColumn[] dcols = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.registerForComponentEvents((BComponent)value, 2);
        this.createColumns((BSnmpTable)value);
        super.doLoadValue(value, cx);
    }

    protected MgrModel makeModel() {
        return new SnmpTableModel(this);
    }

    protected MgrController makeController() {
        return new SnmpTableController(this);
    }

    public BImage getIcon(int col, int row) {
        if (col >= this.dcols.length) {
            return null;
        }
        return this.dcols[col].getIcon();
    }

    private void createColumns(BSnmpTable sTable) {
        BSnmpSequence seq = sTable.getSequence();
        BSnmpSequenceElement[] elems = seq.getElements();
        this.dcols = new TableColumn[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            this.dcols[i] = new TableColumn(elems[i]);
        }
    }

    static BImage getIconElem(BSnmpSequenceElement elem) {
        switch (elem.getElementType().getOrdinal()) {
            case 0: {
                return snmpNumericPointIcon;
            }
            case 2: {
                return snmpEnumPointIcon;
            }
            case 1: {
                return snmpBooleanPointIcon;
            }
        }
        return snmpStringPointIcon;
    }

    public static class IndexColumn
    extends MgrColumn {
        public IndexColumn() {
            super(lex.getText("pointManager.indexValue.title"), 0);
        }

        public Object get(Object row) {
            BSnmpTableRow tabRow = (BSnmpTableRow)row;
            int index = this.getRowIndex(tabRow);
            return index >= 0 ? lex.getText("pointManager.indexValue.displayValue", new Object[]{index + 1, tabRow.getIndex()}) : tabRow.getIndex();
        }

        public BImage getIcon() {
            return null;
        }

        private int getRowIndex(BSnmpTableRow tableRow) {
            BSnmpTable table = (BSnmpTable)tableRow.getParent();
            int index = -1;
            if (table != null) {
                BSnmpTableRow[] children = (BSnmpTableRow[])table.getChildren(BSnmpTableRow.class);
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].getIndex().equals(tableRow.getIndex())) continue;
                    index = i;
                    break;
                }
            }
            return index;
        }
    }

    public static class TableColumn
    extends MgrColumn {
        BImage icon = null;

        public TableColumn(BSnmpSequenceElement elem) {
            super(elem.getElementName(), 0);
            this.icon = BSnmpTableManager.getIconElem(elem);
        }

        public Object get(Object row) {
            BSnmpTableRow tabRow = (BSnmpTableRow)row;
            Property p = tabRow.getProperty(SlotPath.escape((String)this.getDisplayName()));
            BStatusValue svalue = (BStatusValue)tabRow.get(p);
            BFacets f = p.getFacets();
            return svalue.toString((Context)new BasicContext(this.getManager().getCurrentContext(), f));
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    class WalkMib
    extends MgrController.MgrCommand {
        private BSnmpTableManager manager;

        WalkMib(BSnmpTableManager owner) {
            super((BWidget)owner, lex, "commands.walkMib");
            this.manager = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            BSnmpTable tab = (BSnmpTable)this.manager.getCurrentValue();
            tab.walkMib();
            return null;
        }
    }

    class SnmpTableController
    extends MgrController {
        private MgrController.MgrCommand walkMib;

        public SnmpTableController(BSnmpTableManager manager) {
            super((BAbstractManager)manager);
            this.walkMib = new WalkMib(manager);
            this.walkMib.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.walkMib};
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        }
    }

    class SnmpTableModel
    extends MgrModel {
        public SnmpTableModel(BSnmpTableManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            MgrColumn[] cols = new MgrColumn[BSnmpTableManager.this.dcols.length + 1];
            System.arraycopy(BSnmpTableManager.this.dcols, 0, cols, 0, BSnmpTableManager.this.dcols.length);
            cols[cols.length - 1] = new IndexColumn();
            return cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BSnmpTableRow.TYPE};
        }

        protected BMgrTable makeTable() {
            return new BSnmpMgrTable(this);
        }
    }
}

