/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"rdbSqlServer:SqlServerDatabase"})})
public class BSqlServerDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    @Generated
    public static final Type TYPE = Sys.loadType(BSqlServerDeprecatedDialect.class);
    private static final String SELECT_DESC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT TOP %s %s, ID FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT TOP %s %s FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String SELECT_DESC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT TOP %s %s, ID FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT TOP %s %s FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_ID = "SELECT TOP 1 %s FROM %s WHERE %s %s ? ORDER BY %s %s";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_TYPE = "SELECT TOP 1 %s FROM %s WHERE %s = ? AND %s %s ? ORDER BY %s %s";
    private static boolean useBigintDataTypeForIdColumn = AccessController.doPrivileged(() -> System.getProperty("niagara.rdb.useBigintDataTypeForIdColumn", "false")).equals("true");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms db, Connection conn, String tableName) throws SQLException {
        Throwable throwable;
        String catalog = null;
        try {
            throwable = null;
            try (Statement s = conn.createStatement();){
                ResultSet r = s.executeQuery("select db_name() as current_db");
                r.next();
                catalog = r.getString("current_db");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.getLogger("rdb").severe("Unable to determine Sql Server catalog.");
        }
        throwable = null;
        try (ResultSet rs = conn.getMetaData().getTables(catalog, null, tableName, new String[]{"TABLE"});){
            boolean bl = rs.next();
            return bl;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public String makeAlterColumnTypeSql(String tableName, String columnName, BSqlType targetType, int columnSize) {
        String sql = "ALTER TABLE " + tableName + " ALTER COLUMN [" + columnName + "] " + this.getDataType(targetType) + "(" + columnSize + ")";
        return sql;
    }

    public String makeDropIndexSql(String indexName, String tableName) {
        return "DROP INDEX " + indexName + " ON " + tableName;
    }

    public String getSqlType(Type type, BFacets facets) {
        int width = this.getVarcharSize(facets);
        if (type.equals(BString.TYPE)) {
            return this.getStringType(width);
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "REAL";
        }
        if (type.equals(BDouble.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "DATETIME";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "BIT";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return this.getStringType(width);
    }

    private String getStringType(int width) {
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return "NVARCHAR(" + width + ")";
        }
        return "VARCHAR(" + width + ")";
    }

    public long getTimestampAccuracy() {
        return 10L;
    }

    public String getPrimaryKeySql() {
        if (useBigintDataTypeForIdColumn) {
            return "BIGINT IDENTITY PRIMARY KEY";
        }
        return "INT IDENTITY PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 128;
    }

    public int getMaxIndexName() {
        return 128;
    }

    public int getMaxColumnName() {
        return 128;
    }

    public int getMaxSequenceName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSequences() {
        return false;
    }

    public boolean allowsUnicode() {
        return true;
    }

    public String makeTimeQuerySql(String columns, String tableName, boolean isDescendingQuery, int limit) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_ID, limit, columns, tableName, timestampCol, timestampCol, timestampCol, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_ID, limit, columns, tableName, timestampCol, timestampCol, timestampCol, columns, timestampCol);
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_TYPE, limit, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_TYPE, limit, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, columns, timestampCol);
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }

    public String makeBoundaryRecordQuerySql(String columns, String tableName, boolean newestOrOldest) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }
}

