/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.BEncryptableTransportRdbms;
import com.tridium.rdb.jdbc.NiagaraPooledDataSource;
import com.tridium.rdb.sqlserver.BSqlServerConnector;
import com.tridium.rdb.sqlserver.BSqlServerDatabase;
import com.tridium.rdb.sqlserver.SqlServerClientTrustManager;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

@NiagaraType
public class BConnectionPool
extends BAbstractConnectionPool {
    @Generated
    public static final Type TYPE = Sys.loadType(BConnectionPool.class);
    private static final String MSSQL_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String MSSQL_BASE_URL = "jdbc:sqlserver:";
    private BasicDataSource ds;
    private final Map<String, String> connectionEncryptionProperties = new ConcurrentHashMap<String, String>();
    protected static final Logger LOGGER = Logger.getLogger("rdb");
    private static final Pattern COMPILE = Pattern.compile("\\s+");
    private static final Pattern PATTERN = Pattern.compile("(?i)useBulkCopyForBatchInsert=true");
    private static final String USE_BULK_COPY_FOR_BATCH_INSERT_PARAM = "useBulkCopyForBatchInsert";
    private static final Map<BSslTlsEnum, String> SSL_TLS_ENUM_SQL_SERVER_JDBC_STRING_MAP = new HashMap<BSslTlsEnum, String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        boolean sqlServerCertChanged;
        Optional optionalDb = CompUtil.closestAncestor((BComplex)this, BSqlServerDatabase.class);
        if (!optionalDb.isPresent()) {
            throw new BajaRuntimeException("Database not found");
        }
        BSqlServerDatabase db = (BSqlServerDatabase)((Object)optionalDb.get());
        String url = this.makeUrl(db);
        String sslTlsVersion = SSL_TLS_ENUM_SQL_SERVER_JDBC_STRING_MAP.get(db.getTlsMinProtocol());
        if (db.getUseEncryptedConnection() && sslTlsVersion == null) {
            throw new SQLException(String.format("Unsupported TLS Version specified: %s", db.getTlsMinProtocol().getDisplayTag(Context.NULL)));
        }
        String previousMinTlsVersion = this.connectionEncryptionProperties.put(BEncryptableTransportRdbms.tlsMinProtocol.getName(), db.getTlsMinProtocol().getTag());
        boolean minTlsVersionChanged = !db.getTlsMinProtocol().getTag().equals(previousMinTlsVersion);
        String previousVerifyHostnameInCertificateValue = this.connectionEncryptionProperties.put(BEncryptableTransportRdbms.verifySubjectInCertificate.getName(), String.valueOf(db.getVerifySubjectInCertificate()));
        boolean verifyHostnameInCertificateChanged = db.getVerifySubjectInCertificate() != Boolean.parseBoolean(previousVerifyHostnameInCertificateValue);
        String previousSqlServerCertAlias = this.connectionEncryptionProperties.put(BSqlServerDatabase.sqlServerCert.getName(), db.getSqlServerCert());
        boolean bl = sqlServerCertChanged = !db.getSqlServerCert().equals(previousSqlServerCertAlias);
        if (this.ds == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("initializing connection pool for " + url);
            }
            this.ds = this.makeDataSource(url, userName, password);
        } else {
            boolean passwordChanged;
            boolean bl2 = passwordChanged = !this.ds.getPassword().equals(password);
            if (!this.ds.getUrl().equals(url) || !this.ds.getUserName().equals(userName) || passwordChanged || minTlsVersionChanged || verifyHostnameInCertificateChanged || sqlServerCertChanged) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("re-initializing connection pool for " + url);
                }
                this.ds.close();
                this.ds = this.makeDataSource(url, userName, password);
            }
        }
        ClassLoader rsbSqlServerClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            return AccessController.doPrivileged(() -> {
                try {
                    Thread.currentThread().setContextClassLoader(rsbSqlServerClassLoader);
                    Connection connection = this.ds.getConnection();
                    return connection;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
            });
        }
        catch (Exception pae) {
            if (pae.getCause() instanceof SQLException) {
                throw (SQLException)pae.getCause();
            }
            throw new SQLException(pae.getCause());
        }
    }

    private BasicDataSource makeDataSource(String url, String userName, String password) {
        NiagaraPooledDataSource dataSource = new NiagaraPooledDataSource((BAbstractConnectionPool)this);
        dataSource.setDriverClassName(MSSQL_DRIVER);
        dataSource.setUrl(url);
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setMaxTotal(this.getMaxActive());
        dataSource.setMaxIdle(this.getMaxIdle());
        dataSource.setMaxWait(Duration.ofMillis(this.getMaxWait()));
        return dataSource;
    }

    private String makeUrl(BSqlServerDatabase db) {
        BValue val;
        String instanceName;
        BSqlServerConnector connector = db.getConnector();
        if (connector == null) {
            connector = BSqlServerConnector.mssql;
            db.setConnector(connector);
        }
        StringBuilder url = new StringBuilder();
        url.append(MSSQL_BASE_URL);
        url.append("//").append(db.getHostname());
        if (db.getPort() != 0) {
            url.append(':').append(db.getPort());
        }
        if (!(instanceName = db.getInstanceName()).isEmpty()) {
            url.append(";databaseName=").append(instanceName);
        }
        String extra = "";
        BComplex parent = this.getParent();
        if (parent != null && (val = parent.get("extraConnectionProperties")) instanceof BString) {
            extra = val.toString();
        }
        if (!extra.isEmpty()) {
            String[] parameters;
            url.append(';');
            StringJoiner joiner = new StringJoiner(";");
            for (String param : parameters = extra.split(";")) {
                if ((param = param.trim()).regionMatches(true, 0, USE_BULK_COPY_FOR_BATCH_INSERT_PARAM, 0, USE_BULK_COPY_FOR_BATCH_INSERT_PARAM.length())) {
                    String param1 = COMPILE.matcher(param).replaceAll("");
                    Matcher matcher = PATTERN.matcher(param1);
                    if (matcher.matches()) {
                        String param2 = matcher.replaceAll("useBulkCopyForBatchInsert=false");
                        joiner.add(param2);
                        if (this.ds != null || !LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.warning("Ignoring the 'useBulkCopyForBatchInsert=true' parameter in the Extra Connection Properties of" + db.toPathString() + ". Currently, this setting cannot be used.");
                        continue;
                    }
                    joiner.add(param1);
                    continue;
                }
                joiner.add(param);
            }
            url.append(joiner);
        }
        url.append(";encrypt=" + db.getUseEncryptedConnection());
        url.append(";trustServerCertificate=").append(false);
        url.append(";hostNameInCertificate=").append(BConnectionPool.sanitize(db.getServerCertificateSubjectIdentifier()));
        url.append(";trustManagerClass=").append(SqlServerClientTrustManager.class.getCanonicalName());
        url.append(";trustManagerConstructorArg=" + db.getAbsoluteOrd().encodeToString());
        String urlStr = url.toString();
        if (!db.getUseUnicodeEncodingScheme() && !urlStr.toLowerCase().contains("sendstringparametersasunicode")) {
            url.append(";sendStringParametersAsUnicode=false");
            urlStr = url.toString();
        }
        return urlStr;
    }

    private static String sanitize(String property) {
        if (property == null) {
            return "";
        }
        property = property.replaceAll("}", "}}");
        return '{' + property + '}';
    }

    static {
        SSL_TLS_ENUM_SQL_SERVER_JDBC_STRING_MAP.put(BSslTlsEnum.tlsv1, "TLSv1");
        SSL_TLS_ENUM_SQL_SERVER_JDBC_STRING_MAP.put(BSslTlsEnum.tlsv1_1, "TLSv1.1");
        SSL_TLS_ENUM_SQL_SERVER_JDBC_STRING_MAP.put(BSslTlsEnum.tlsv1_2, "TLSv1.2");
    }
}

