/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFileChooserPane
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileChooserPane.class);
    private FileChooserModel model;
    private BFileChooserListView listView;
    private BTreeView treeView;
    private IFilePathFilter selectionPathFilter;
    private IFileFilter selectionFileFilter;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private Array<Listener> listeners = new Array(Listener.class);
    private static final Lexicon LEX = Lexicon.make((String)"platform");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileChooserPane() {
        throw new UnsupportedOperationException();
    }

    public BFileChooserPane(BIFile initialDir, IFileFilter displayFilter, IFileFilter selectionFileFilter, IFilePathFilter selectionPathFilter, BFileChooserListView.ListModel listModel, boolean selectMulti, boolean showTextField, String defTextFieldContents) {
        this(initialDir, null, displayFilter, selectionFileFilter, selectionPathFilter, listModel, selectMulti, showTextField, defTextFieldContents);
    }

    public BFileChooserPane(BIFile initialDir, BIFile initialSelection, IFileFilter displayFilter, IFileFilter selectionFileFilter, IFilePathFilter selectionPathFilter, BFileChooserListView.ListModel listModel, boolean selectMulti, boolean showTextField, String defTextFieldContents) {
        this.model = initialDir == null ? new FileChooserModel((BSpace)BFileSystem.INSTANCE) : new FileChooserModel((BSpace)initialDir.getFileSpace());
        if (initialSelection != null) {
            this.model.select(initialSelection);
        }
        this.model.setFilter(displayFilter);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BFileChooserListView(this.model);
        if (listModel == null) {
            this.listView.setDetailsView();
        } else {
            this.listView.setView(listModel, true);
        }
        this.listView.setMultipleSelection(selectMulti);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        this.selectionPathFilter = selectionPathFilter == null ? p -> true : selectionPathFilter;
        this.selectionFileFilter = selectionFileFilter == null ? new IFileFilter(){

            public boolean accept(BIFile f) {
                return true;
            }

            public String getDescription(Context c) {
                return "";
            }
        } : selectionFileFilter;
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(33.0);
        split.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane toolFlow = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        toolFlow.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar tools = new BToolBar();
        tools.add(null, (BValue)new BSeparator());
        tools.add(null, (Command)new HomeCommand());
        tools.add(null, (Command)new UpLevelCommand());
        toolFlow.add(null, (BValue)tools);
        BEdgePane fileNamePane = null;
        this.fileNameTextField = new BTextField("", 32);
        this.fileNameTextField.setModel(new TextModel(){

            protected void textModified() {
                BFileChooserPane.this.notifyFileSelected();
            }
        });
        if (showTextField) {
            fileNamePane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)new BLabel(LEX.getText("FileChooserPane.fileName")), BInsets.make((double)4.0, (double)4.0, (double)0.0, (double)0.0)), null, (BWidget)new BBorderPane((BWidget)this.fileNameTextField, BInsets.make((double)4.0, (double)0.0, (double)0.0, (double)0.0)));
        }
        split.setWidget2((BWidget)new BEdgePane((BWidget)toolFlow, fileNamePane, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)split, 6.0, 4.0, 4.0, 4.0));
        pane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)pane);
        if (initialDir != null && initialDir.isDirectory()) {
            this.model.setDirectory((BINavNode)initialDir);
            this.treeView.scrollToVisible((BINavNode)initialDir);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)initialDir.getNavIcon()));
            this.currentDirectoryLabel.setText(initialDir.getNavDisplayName(null));
        }
        if (defTextFieldContents != null) {
            this.fileNameTextField.setText(defTextFieldContents);
        }
    }

    public BIFile[] getSelectedFiles() {
        return this.model.getSelectedFiles();
    }

    public FilePath getSelectedFilePath() {
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText());
    }

    public BIFile getSelectedFile() {
        BIFile[] selection = this.getSelectedFiles();
        return selection.length == 0 ? null : selection[0];
    }

    public BDirectory getDirectory() {
        BINavNode d = this.model.getDirectory();
        return d instanceof BDirectory ? (BDirectory)d : null;
    }

    public void started() {
        this.notifyFileSelected();
    }

    public void addListener(Listener value) {
        this.listeners.add((Object)value);
    }

    public void removeListener(Listener value) {
        this.listeners.remove((Object)value);
    }

    public void notifyFileSelected() {
        boolean validFileSelected = this.fileNameTextField.getText().trim().length() > 0 && this.model.getDirectory() != null && this.model.getDirectory() instanceof BDirectory && this.selectionPathFilter.accept(((BDirectory)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText().trim()));
        this.listeners.forEach(l -> l.fileSelected(validFileSelected));
    }

    public class Controller
    extends TreeController {
        protected void mouseSelection(TreeNode target, BMouseEvent evt) {
            super.mouseSelection(target, evt);
            BFileChooserPane.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BINavNode navNode = BFileChooserPane.this.treeView.getFileForNode(target);
            if (navNode != null) {
                BFileChooserPane.this.model.setDirectory(navNode);
            }
        }
    }

    public class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BFileChooserPane.this, TYPE.getModule(), "FileChooserPane.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory dir = BFileSystem.INSTANCE.getSysHome();
                BFileChooserPane.this.model.setDirectory((BINavNode)dir);
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    public class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BFileChooserPane.this, TYPE.getModule(), "FileChooserPane.upLevel");
        }

        public CommandArtifact doInvoke() {
            try {
                BFileChooserPane.this.model.moveUpDirectory();
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    public static interface Listener {
        public void fileSelected(boolean var1);
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BFileChooserPane.this.listView.populateChildren();
            BFileChooserPane.this.listView.relayout();
            BIFile dir = (BIFile)BFileChooserPane.this.model.getDirectory();
            if (dir != null) {
                BFileChooserPane.this.treeView.scrollToVisible((BINavNode)dir);
                BFileChooserPane.this.currentDirectoryLabel.setImage(BImage.make((BIcon)dir.getNavIcon()));
                BFileChooserPane.this.currentDirectoryLabel.setText(dir.getNavDisplayName(null));
                BFileChooserPane.this.currentDirectoryLabel.relayout();
            }
            BFileChooserPane.this.model.deselectAll();
            BFileChooserPane.this.listView.getSelection().deselectAll();
            BFileChooserPane.this.notifyFileSelected();
        }

        public void selectionModified() {
            BIFile[] selectedFiles = BFileChooserPane.this.model.getSelectedFiles();
            if (selectedFiles.length == 0) {
                BFileChooserPane.this.notifyFileSelected();
                return;
            }
            BFileChooserPane.this.treeView.getSelection().deselectAll();
            for (BIFile selectedFile : selectedFiles) {
                if (BFileChooserPane.this.selectionPathFilter.accept(selectedFile.getFilePath()) && BFileChooserPane.this.selectionFileFilter.accept(selectedFile)) continue;
                BFileChooserPane.this.notifyFileSelected();
                return;
            }
            BFileChooserPane.this.fileNameTextField.setText(selectedFiles[0].getFileName());
            BFileChooserPane.this.notifyFileSelected();
        }

        public void chooseSelectedFiles() {
        }
    }
}

