/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.tcpip.BIpHostVectorFE;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraAction(name="setEnabledStates", flags=4)
public class BTcpIpAdapterEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BTcpIpAdapterEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTcpIpAdapterEditor.class);
    private static boolean SUPPRESS_ERROR_DIALOG = false;
    private BLabel interfaceIdLabel = null;
    private BLabel interfaceDescLabel = null;
    private BLabel macAddressLabel = null;
    private boolean usesAdapterLevelSettings = false;
    boolean isAdapterReadonly = false;
    private boolean canDisableAdapter = false;
    private boolean canUseDhcp = false;
    BCheckBox dhcpdEnabledCheckBox = null;
    BCheckBox dhcpEnabledCheckBox = null;
    BCheckBox adapterEnabledCheckBox = null;
    private BTextField domainTextField = null;
    private BIpHostFE gatewayFE = null;
    private BIpHostVectorFE dnsHostEditor = null;
    private BIpHostFE ipAddressFE = null;
    private BIpHostFE subnetMaskFE = null;
    private BLabel dhcpHostLabel = null;
    private BLabel dhcpLeaseGrantedLabel = null;
    private BLabel dhcpLeaseExpiresLabel = null;
    private boolean isIPv6Readonly = true;
    private BLabel ipv6DhcpHostLabel = null;
    private BLabel ipv6DhcpLeaseGrantedLabel = null;
    private BLabel ipv6DhcpLeaseExpiresLabel = null;
    private BLabel ipv6SupportedLabel = null;
    private BWbFieldEditor ipv6SubnetPrefixLengthFE = null;
    private boolean canDisableIpv6 = false;
    private boolean isIpv6Supported = false;
    private boolean canUseIpv6Dhcp = false;
    private BCheckBox ipv6EnabledCheckBox = null;
    BCheckBox ipv6DhcpEnabledCheckBox = null;
    private BIpHostFE ipv6AddressFE = null;
    private BIpHostFE ipv6GatewayFE = null;
    private BIpHostVectorFE ipv6DnsHostEditor = null;
    private boolean canUseDhcpdv4 = false;
    private boolean dhcpdSettingsReadonly = false;
    private BWbFieldEditor dhcpdLeaseTimeFieldFE = null;
    private BWbFieldEditor dhcpdMaxLeaseTimeFieldFE = null;
    private BIpHostFE dhcpdSubnetFieldFE = null;
    private BIpHostFE dhcpdNetmaskFieldFE = null;
    private BIpHostFE dhcpdRangeStartFieldFE = null;
    private BIntegerFE dhcpdRangeSizeFE = null;
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        boolean readonly;
        BasicContext feContext;
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)value;
        BEdgePane mainPane = new BEdgePane();
        BGridPane genericPane = new BGridPane(2);
        genericPane.setColumnAlign(BHalign.left);
        genericPane.setHalign(BHalign.left);
        genericPane.setValign(BValign.top);
        genericPane.setRowAlign(BValign.top);
        genericPane.setColumnGap(10.0);
        genericPane.setRowGap(6.0);
        genericPane.setColorRows(false);
        adapter.getHostSettings().lease();
        this.isAdapterReadonly = adapter.getIsAdapterReadonly() || adapter.getHostSettings().getIsReadonly();
        this.canDisableAdapter = !this.isAdapterReadonly && adapter.getCanDisableAdapter();
        this.interfaceIdLabel = new BLabel(adapter.getAdapterId());
        LabelUtil.addLabelWidgetPair((BPane)genericPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceId"), (BWidget)this.interfaceIdLabel);
        this.interfaceDescLabel = new BLabel(adapter.getDescription());
        LabelUtil.addLabelWidgetPair((BPane)genericPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceDesc"), (BWidget)this.interfaceDescLabel);
        this.macAddressLabel = new BLabel(adapter.getMediaAccessControlAddress());
        LabelUtil.addLabelWidgetPair((BPane)genericPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.macAddress"), (BWidget)this.macAddressLabel);
        this.adapterEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.adapterEnabled.value"));
        LabelUtil.addLabelWidgetPair((BPane)genericPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isAdapterEnabled"), (BWidget)this.adapterEnabledCheckBox);
        this.adapterEnabledCheckBox.setSelected(adapter.getIsAdapterEnabled());
        this.linkTo(null, (BComponent)this.adapterEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.adapterEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        mainPane.setTop((BWidget)genericPane);
        BTabbedPane protocolsPane = new BTabbedPane();
        BGridPane IPv4pane = new BGridPane(2);
        IPv4pane.setHalign(BHalign.left);
        IPv4pane.setValign(BValign.top);
        IPv4pane.setRowAlign(BValign.top);
        IPv4pane.setColumnGap(10.0);
        IPv4pane.setRowGap(6.0);
        IPv4pane.setColorRows(false);
        this.usesAdapterLevelSettings = adapter.getUsesAdapterLevelSettings();
        this.canUseDhcp = adapter.getCanUseDhcp();
        if (this.canUseDhcp) {
            this.dhcpEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isDhcpEnabled.value"));
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isDhcpEnabled"), (BWidget)this.dhcpEnabledCheckBox);
            this.dhcpEnabledCheckBox.setSelected(adapter.getIsDhcpEnabled());
            this.linkTo(null, (BComponent)this.dhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            this.linkTo(null, (BComponent)this.dhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        } else {
            this.dhcpEnabledCheckBox = null;
        }
        if (this.usesAdapterLevelSettings) {
            this.domainTextField = new BTextField(adapter.getDomain(), 32);
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.domain"), (BWidget)this.domainTextField);
            this.linkTo(null, (BComponent)this.domainTextField, (Slot)BTextField.textModified, (Slot)setModified);
        } else {
            this.domainTextField = null;
        }
        this.ipAddressFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipAddress"), (BWidget)this.ipAddressFE);
        this.ipAddressFE.loadValue((BObject)BString.make((String)adapter.getIpAddress()), cx);
        this.linkTo(null, (BComponent)this.ipAddressFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.subnetMaskFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.subnetMask"), (BWidget)this.subnetMaskFE);
        this.subnetMaskFE.loadValue((BObject)BString.make((String)adapter.getSubnetMask()), cx);
        this.linkTo(null, (BComponent)this.subnetMaskFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        if (this.usesAdapterLevelSettings) {
            this.gatewayFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.gateway"), (BWidget)this.gatewayFE);
            this.gatewayFE.loadValue((BObject)BString.make((String)adapter.getDefaultGateway()), cx);
            this.linkTo(null, (BComponent)this.gatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        } else {
            this.gatewayFE = null;
        }
        if (this.canUseDhcp) {
            this.dhcpHostLabel = new BLabel(adapter.getDhcpHost().trim());
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpHost"), (BWidget)this.dhcpHostLabel);
            this.dhcpLeaseGrantedLabel = new BLabel(adapter.getDhcpLeaseGranted());
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseGranted"), (BWidget)this.dhcpLeaseGrantedLabel);
            this.dhcpLeaseExpiresLabel = new BLabel(adapter.getDhcpLeaseExpires());
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseExpires"), (BWidget)this.dhcpLeaseExpiresLabel);
        } else {
            this.dhcpHostLabel = null;
            this.dhcpLeaseGrantedLabel = null;
            this.dhcpLeaseExpiresLabel = null;
        }
        if (this.usesAdapterLevelSettings) {
            this.dnsHostEditor = new BIpHostVectorFE();
            LabelUtil.addLabelWidgetPair((BPane)IPv4pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)this.dnsHostEditor);
            this.dnsHostEditor.setUseMaxHostsForPreferredHeight(true);
            BasicContext feContext2 = new BasicContext(cx, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)adapter.getMaxDnsHosts())));
            this.dnsHostEditor.loadValue((BObject)adapter.getDnsHosts(), (Context)feContext2);
            this.linkTo(null, (BComponent)this.dnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
        } else {
            this.dnsHostEditor = null;
        }
        protocolsPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"connection.png")), LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.IPv4Settings").getText(cx), BOLD_TEXT_FONT), (BWidget)new BBorderPane((BWidget)IPv4pane));
        BGridPane IPv6pane = new BGridPane(2);
        IPv6pane.setHalign(BHalign.left);
        IPv6pane.setValign(BValign.top);
        IPv6pane.setRowAlign(BValign.top);
        IPv6pane.setColumnGap(10.0);
        IPv6pane.setRowGap(6.0);
        IPv6pane.setColorRows(false);
        adapter.getHostSettings().lease();
        this.isIpv6Supported = adapter.getIsIpv6Supported();
        boolean isIpv6Enabled = this.isIpv6Supported && adapter.getIsIpv6Enabled();
        this.canDisableIpv6 = !this.isAdapterReadonly && adapter.getCanDisableIpv6();
        this.canUseIpv6Dhcp = adapter.getCanUseIpv6Dhcp();
        this.isIPv6Readonly = this.isAdapterReadonly || adapter.getHostSettings().getIsIPv6Readonly();
        String supportText = this.isIpv6Supported ? this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Supported.true") : this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Supported.false");
        this.ipv6SupportedLabel = new BLabel(supportText);
        LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Supported"), (BWidget)this.ipv6SupportedLabel);
        if (this.isIpv6Supported) {
            this.ipv6EnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Enabled.value"));
            LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Enabled"), (BWidget)this.ipv6EnabledCheckBox);
            this.ipv6EnabledCheckBox.setSelected(this.isIpv6Supported && isIpv6Enabled);
            this.linkTo(null, (BComponent)this.ipv6EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            this.linkTo(null, (BComponent)this.ipv6EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        } else {
            this.ipv6EnabledCheckBox = null;
        }
        if (this.isIpv6Supported && !isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && isIpv6Enabled) {
            if (this.canUseIpv6Dhcp) {
                this.ipv6DhcpEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isIpv6DhcpEnabled.value"));
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled"), (BWidget)this.ipv6DhcpEnabledCheckBox);
                this.ipv6DhcpEnabledCheckBox.setSelected(adapter.getIsIpv6DhcpEnabled());
                this.linkTo(null, (BComponent)this.ipv6DhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                this.linkTo(null, (BComponent)this.ipv6DhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            } else {
                this.ipv6DhcpEnabledCheckBox = null;
            }
            this.ipv6AddressFE = new BIpHostFE(true);
            LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Address"), (BWidget)this.ipv6AddressFE);
            this.ipv6AddressFE.loadValue((BObject)BString.make((String)adapter.getIpv6Address()), cx);
            this.linkTo(null, (BComponent)this.ipv6AddressFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.ipv6SubnetPrefixLengthFE = BWbFieldEditor.makeFor((BObject)BInteger.make((int)1), (Context)BTcpIpAdapterSettings.ipv6SubnetPrefixLength.getFacets());
            LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength"), (BWidget)this.ipv6SubnetPrefixLengthFE);
            feContext = new BasicContext(cx, BTcpIpAdapterSettings.ipv6SubnetPrefixLength.getFacets());
            this.ipv6SubnetPrefixLengthFE.loadValue((BObject)BInteger.make((int)adapter.getIpv6SubnetPrefixLength()), (Context)feContext);
            this.linkTo(null, (BComponent)this.ipv6SubnetPrefixLengthFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
            if (this.usesAdapterLevelSettings) {
                this.ipv6GatewayFE = new BIpHostFE(true);
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)this.ipv6GatewayFE);
                this.ipv6GatewayFE.loadValue((BObject)BString.make((String)adapter.getIpv6DefaultGateway()), cx);
                this.linkTo(null, (BComponent)this.ipv6GatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            } else {
                this.ipv6GatewayFE = null;
            }
        } else {
            this.ipv6DhcpEnabledCheckBox = null;
            this.ipv6AddressFE = null;
            this.ipv6GatewayFE = null;
            this.ipv6SubnetPrefixLengthFE = null;
        }
        if ((this.isIpv6Supported && !isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && isIpv6Enabled) && this.canUseIpv6Dhcp) {
            this.ipv6DhcpHostLabel = new BLabel(adapter.getIpv6DhcpHost().trim());
            this.ipv6DhcpLeaseGrantedLabel = new BLabel(adapter.getIpv6DhcpLeaseGranted());
            this.ipv6DhcpLeaseExpiresLabel = new BLabel(adapter.getIpv6DhcpLeaseExpires());
            if (!adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("n/a") && !adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("")) {
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpHost"), (BWidget)this.ipv6DhcpHostLabel);
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseGranted"), (BWidget)this.ipv6DhcpLeaseGrantedLabel);
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseExpires"), (BWidget)this.ipv6DhcpLeaseExpiresLabel);
            }
        } else {
            this.ipv6DhcpHostLabel = null;
            this.ipv6DhcpLeaseGrantedLabel = null;
            this.ipv6DhcpLeaseExpiresLabel = null;
        }
        if (this.usesAdapterLevelSettings) {
            if (this.isIpv6Supported && !isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && isIpv6Enabled) {
                this.ipv6DnsHostEditor = new BIpHostVectorFE(true);
                LabelUtil.addLabelWidgetPair((BPane)IPv6pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)this.ipv6DnsHostEditor);
                this.ipv6DnsHostEditor.setUseMaxHostsForPreferredHeight(true);
                feContext = new BasicContext(cx, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)adapter.getMaxDnsHosts())));
                this.ipv6DnsHostEditor.loadValue((BObject)adapter.getIpv6DnsHosts(), (Context)feContext);
                this.linkTo(null, (BComponent)this.ipv6DnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
            } else {
                this.ipv6DnsHostEditor = null;
            }
        } else {
            this.ipv6DnsHostEditor = null;
        }
        protocolsPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"connections.png")), LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.IPv6Settings").getText(cx), BOLD_TEXT_FONT), (BWidget)new BBorderPane((BWidget)IPv6pane));
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings");
        if (dhcpdAdapterSettings != null) {
            BGridPane dhcpdSettingsPane = new BGridPane(2);
            dhcpdSettingsPane.setHalign(BHalign.left);
            dhcpdSettingsPane.setValign(BValign.top);
            dhcpdSettingsPane.setRowAlign(BValign.top);
            dhcpdSettingsPane.setColumnGap(10.0);
            dhcpdSettingsPane.setRowGap(6.0);
            dhcpdSettingsPane.setColorRows(false);
            this.dhcpdLoadValue(dhcpdSettingsPane, dhcpdAdapterSettings, cx);
            protocolsPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"deviceData.png")), LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.label").getText(cx), BOLD_TEXT_FONT), (BWidget)new BBorderPane((BWidget)dhcpdSettingsPane));
        }
        BBorderPane spacer = new BBorderPane((BWidget)protocolsPane);
        spacer.setBorder(BBorder.none);
        spacer.setMargin(BInsets.make((double)8.0, (double)0.0, (double)0.0, (double)0.0));
        spacer.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        mainPane.setCenter((BWidget)spacer);
        boolean bl = readonly = this.isReadonly() || this.isAdapterReadonly || adapter.getHostSettings().getIsReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
        this.setContent((BWidget)mainPane);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.isAdapterReadonly) {
            return value;
        }
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)value;
        boolean adapterEnabled = this.adapterEnabledCheckBox.isSelected();
        if (this.canDisableAdapter) {
            adapter.setIsAdapterEnabled(this.adapterEnabledCheckBox.isSelected());
        }
        if (adapterEnabled) {
            BDhcpdAdapterSettings dhcpdAdapterSettings;
            String ipAddress = ((BString)this.ipAddressFE.saveValue(cx)).getString().trim();
            String subnetMask = ((BString)this.subnetMaskFE.saveValue(cx)).getString().trim();
            if (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) {
                if (ipAddress.isEmpty()) {
                    this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.nullIpAddress");
                }
                if (subnetMask.isEmpty()) {
                    this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.nullSubnetMask");
                }
                if (!IPAddressUtil.isIpv4Address((String)ipAddress)) {
                    this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.invalidIpAddressValue");
                }
                if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
                    this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.invalidSubnetMaskValue");
                }
            }
            if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                String ipv6Address = ((BString)this.ipv6AddressFE.saveValue(cx)).getString().trim();
                if (this.ipv6DhcpEnabledCheckBox == null || !this.ipv6DhcpEnabledCheckBox.isSelected()) {
                    if (ipv6Address.isEmpty()) {
                        this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.nullIpv6Address");
                    }
                    if (!IPAddressUtil.isIpv6AddressFormat((String)ipv6Address)) {
                        this.saveError(adapter.getAdapterId(), "TcpIpAdapterEditor.invalidIpv6AddressValue");
                    }
                }
            }
            if (this.usesAdapterLevelSettings) {
                adapter.setDefaultGateway(this.gatewayFE.saveValue(cx).toString().trim());
                adapter.setDomain(this.domainTextField.getText().trim());
                adapter.setDnsHosts((BVector)this.dnsHostEditor.saveValue(cx));
                if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                    adapter.setIpv6DefaultGateway(this.ipv6GatewayFE.saveValue(cx).toString().trim());
                    adapter.setIpv6DnsHosts((BVector)this.ipv6DnsHostEditor.saveValue(cx));
                }
            }
            if (adapter.getCanUseDhcp()) {
                adapter.setIsDhcpEnabled(this.dhcpEnabledCheckBox != null && this.dhcpEnabledCheckBox.isSelected());
            } else {
                adapter.setIsDhcpEnabled(false);
            }
            if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                if (adapter.getCanUseIpv6Dhcp()) {
                    adapter.setIsIpv6DhcpEnabled(this.ipv6DhcpEnabledCheckBox != null && this.ipv6DhcpEnabledCheckBox.isSelected());
                } else {
                    adapter.setIsIpv6DhcpEnabled(false);
                }
            }
            if (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) {
                adapter.setIpAddress(this.ipAddressFE.saveValue(cx).toString().trim());
                adapter.setSubnetMask(this.subnetMaskFE.saveValue(cx).toString().trim());
            }
            if (this.isIpv6Supported) {
                if (adapter.getCanDisableIpv6()) {
                    adapter.setIsIpv6Enabled(this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected());
                }
                if (this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && (this.ipv6DhcpEnabledCheckBox == null || !this.ipv6DhcpEnabledCheckBox.isSelected())) {
                    adapter.setIpv6Address(this.ipv6AddressFE.saveValue(cx).toString().trim());
                    try {
                        adapter.setIpv6SubnetPrefixLength(((BInteger)this.ipv6SubnetPrefixLengthFE.saveValue(cx)).getInt());
                    }
                    catch (Exception e) {
                        this.saveError(this.getAdapter().getAdapterId(), "TcpIpAdapterEditor.invalidIpv6SubnetPrefixLength");
                    }
                }
            }
            if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings")) != null) {
                this.doSaveValueDhcpd(adapter, cx);
            }
        }
        return adapter;
    }

    private void saveError(String interfaceId, String messageTag) throws CannotSaveException {
        if (!SUPPRESS_ERROR_DIALOG) {
            BDialog.error((BWidget)this, (String)this.getLexicon().getText("TcpIpAdapterEditor.invalidDataTitle"), (Object)("Interface ID " + interfaceId + ": " + this.getLexicon().getText(messageTag)));
        }
        CannotSaveException cse = new CannotSaveException("Interface ID " + interfaceId + ": " + this.getLexicon().getText(messageTag));
        cse.setSilent(true);
        throw cse;
    }

    public BTcpIpAdapterSettings getAdapter() {
        return (BTcpIpAdapterSettings)this.getCurrentValue();
    }

    public boolean isAdapterEnabledSelected() {
        return this.adapterEnabledCheckBox.isSelected();
    }

    public boolean isIpv6EnabledSelected() {
        return this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected();
    }

    public boolean isDhcpEnabledSelected() {
        return this.dhcpEnabledCheckBox != null && this.dhcpEnabledCheckBox.isSelected();
    }

    public boolean isDhcpdv4EnabledSelected() {
        return this.dhcpdEnabledCheckBox != null && this.dhcpdEnabledCheckBox.isSelected();
    }

    public boolean isIpv6AutoconfigurationSelected() {
        return this.ipv6DhcpEnabledCheckBox != null && this.ipv6DhcpEnabledCheckBox.isSelected();
    }

    protected void doSetReadonly(boolean readonly) {
        this.doSetEnabledStates();
    }

    public void doSetEnabledStates() {
        boolean enabled = !this.isReadonly() && !this.isAdapterReadonly && this.canDisableAdapter;
        this.adapterEnabledCheckBox.setEnabled(enabled);
        if (this.ipv6EnabledCheckBox != null) {
            enabled = this.adapterEnabledCheckBox.isSelected() && this.isIpv6Supported && !this.isReadonly() && !this.isAdapterReadonly && this.canDisableIpv6 && !this.isIPv6Readonly;
            this.ipv6EnabledCheckBox.setEnabled(enabled);
        }
        if (this.dhcpEnabledCheckBox != null) {
            enabled = this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly && this.canUseDhcp;
            enabled = enabled && (this.dhcpdEnabledCheckBox == null || !this.isDhcpdEnabledSelected());
            this.dhcpEnabledCheckBox.setEnabled(enabled);
        }
        if (this.ipAddressFE != null) {
            enabled = (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly;
            this.ipAddressFE.setEnabled(enabled);
            this.ipAddressFE.setReadonly(!enabled);
        }
        if (this.subnetMaskFE != null) {
            enabled = (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly;
            this.subnetMaskFE.setEnabled(enabled);
            this.subnetMaskFE.setReadonly(!enabled);
        }
        if (this.gatewayFE != null) {
            enabled = (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly;
            this.gatewayFE.setEnabled(enabled);
            this.gatewayFE.setReadonly(!enabled);
        }
        if (this.dnsHostEditor != null) {
            enabled = (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly;
            this.dnsHostEditor.setEnabled(enabled);
            this.dnsHostEditor.setReadonly(!enabled);
        }
        if (this.domainTextField != null) {
            enabled = (this.dhcpEnabledCheckBox == null || !this.dhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isAdapterReadonly;
            this.domainTextField.setEditable(enabled);
            this.domainTextField.setEnabled(enabled);
        }
        if (this.isIpv6Supported) {
            if (this.ipv6EnabledCheckBox != null) {
                enabled = this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly && this.canDisableIpv6;
                this.ipv6EnabledCheckBox.setEnabled(enabled);
            }
            if (this.ipv6DhcpEnabledCheckBox != null) {
                enabled = this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && this.canUseIpv6Dhcp && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly;
                this.ipv6DhcpEnabledCheckBox.setEnabled(enabled);
            }
            if (this.ipv6DnsHostEditor != null) {
                enabled = this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly;
                this.ipv6DnsHostEditor.setEnabled(enabled);
                this.ipv6DnsHostEditor.setReadonly(!enabled);
            }
            if (this.ipv6AddressFE != null) {
                enabled = (this.ipv6DhcpEnabledCheckBox == null || !this.ipv6DhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly;
                this.ipv6AddressFE.setEnabled(enabled);
                this.ipv6AddressFE.setReadonly(!enabled);
            }
            if (this.ipv6SubnetPrefixLengthFE != null) {
                enabled = (this.ipv6DhcpEnabledCheckBox == null || !this.ipv6DhcpEnabledCheckBox.isSelected()) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly;
                this.ipv6SubnetPrefixLengthFE.setEnabled(enabled);
                this.ipv6SubnetPrefixLengthFE.setReadonly(!enabled);
            }
            if (this.ipv6GatewayFE != null) {
                enabled = this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly && !this.isAdapterReadonly;
                this.ipv6GatewayFE.setEnabled(enabled);
                this.ipv6GatewayFE.setReadonly(!enabled);
            }
        }
        this.doSetDhcpdEnabledStates();
    }

    private void dhcpdLoadValue(BGridPane dhcpdPane, BDhcpdAdapterSettings dhcpdAdapterSettings, Context cx) {
        this.dhcpdSettingsReadonly = dhcpdAdapterSettings.getIsReadOnly();
        this.dhcpdEnabledCheckBox = null;
        this.dhcpdLeaseTimeFieldFE = null;
        this.dhcpdMaxLeaseTimeFieldFE = null;
        this.dhcpdSubnetFieldFE = null;
        this.dhcpdNetmaskFieldFE = null;
        this.dhcpdRangeStartFieldFE = null;
        this.dhcpdRangeSizeFE = null;
        this.canUseDhcpdv4 = dhcpdAdapterSettings.getIsDhcpdIpv4Supported();
        if (this.canUseDhcpdv4) {
            this.dhcpdEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditorDhcpd.isDhcpdEnabled.value"));
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.isDhcpdEnabled"), (BWidget)this.dhcpdEnabledCheckBox);
            this.dhcpdEnabledCheckBox.setSelected(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled());
            this.linkTo(null, (BComponent)this.dhcpdEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            this.linkTo(null, (BComponent)this.dhcpdEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            this.dhcpdLeaseTimeFieldFE = BWbFieldEditor.makeFor((BObject)BRelTime.DEFAULT, (Context)BDhcpdAdapterSettings.defaultLeaseTime.getFacets());
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.defaultLeaseTime.label"), (BWidget)this.dhcpdLeaseTimeFieldFE);
            BasicContext feContext = new BasicContext(cx, BDhcpdAdapterSettings.defaultLeaseTime.getFacets());
            this.dhcpdLeaseTimeFieldFE.loadValue((BObject)dhcpdAdapterSettings.getDefaultLeaseTime(), (Context)feContext);
            this.linkTo(null, (BComponent)this.dhcpdLeaseTimeFieldFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
            this.dhcpdMaxLeaseTimeFieldFE = BWbFieldEditor.makeFor((BObject)BRelTime.DEFAULT, (Context)BDhcpdAdapterSettings.maxLeaseTime.getFacets());
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.maxLeaseTime.label"), (BWidget)this.dhcpdMaxLeaseTimeFieldFE);
            feContext = new BasicContext(cx, BDhcpdAdapterSettings.maxLeaseTime.getFacets());
            this.dhcpdMaxLeaseTimeFieldFE.loadValue((BObject)dhcpdAdapterSettings.getMaxLeaseTime(), (Context)feContext);
            this.linkTo(null, (BComponent)this.dhcpdMaxLeaseTimeFieldFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
            this.dhcpdSubnetFieldFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.subnet.label"), (BWidget)this.dhcpdSubnetFieldFE);
            this.dhcpdSubnetFieldFE.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getSubnet()), cx);
            this.linkTo(null, (BComponent)this.dhcpdSubnetFieldFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.dhcpdNetmaskFieldFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.netmask.label"), (BWidget)this.dhcpdNetmaskFieldFE);
            this.dhcpdNetmaskFieldFE.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getSubnetMask()), cx);
            this.linkTo(null, (BComponent)this.dhcpdNetmaskFieldFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.dhcpdRangeStartFieldFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.rangestart.label"), (BWidget)this.dhcpdRangeStartFieldFE);
            this.dhcpdRangeStartFieldFE.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getStartClientAddress()), cx);
            this.linkTo(null, (BComponent)this.dhcpdRangeStartFieldFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.dhcpdRangeSizeFE = new BIntegerFE();
            LabelUtil.addLabelWidgetPair((BPane)dhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.rangesize.label"), (BWidget)this.dhcpdRangeSizeFE);
            this.linkTo(null, (BComponent)this.dhcpdRangeSizeFE, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
            BasicContext rangeContext = new BasicContext(cx, BDhcpdAdapterSettings.range.getFacets());
            this.dhcpdRangeSizeFE.loadValue((BObject)BInteger.make((int)dhcpdAdapterSettings.getRange()), (Context)rangeContext);
        }
    }

    private void doSaveValueDhcpd(BTcpIpAdapterSettings adapter, Context context) throws Exception {
        if (adapter == null) {
            return;
        }
        if (this.isReadonly()) {
            return;
        }
        if (!this.isModified()) {
            return;
        }
        if (!this.canUseDhcpdv4) {
            return;
        }
        if (this.dhcpdSettingsReadonly) {
            return;
        }
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings");
        if (dhcpdAdapterSettings == null) {
            return;
        }
        dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(this.dhcpdEnabledCheckBox.isSelected());
        try {
            dhcpdAdapterSettings.setDefaultLeaseTime((BRelTime)this.dhcpdLeaseTimeFieldFE.saveValue(context));
            dhcpdAdapterSettings.setMaxLeaseTime((BRelTime)this.dhcpdMaxLeaseTimeFieldFE.saveValue(context));
            dhcpdAdapterSettings.setSubnet(((BString)this.dhcpdSubnetFieldFE.saveValue(context)).getString().trim());
            String dhcpdMask = ((BString)this.dhcpdNetmaskFieldFE.saveValue(context)).getString().trim();
            dhcpdAdapterSettings.setSubnetMask(dhcpdMask);
            String startDhcpStr = ((BString)this.dhcpdRangeStartFieldFE.saveValue(context)).getString().trim();
            dhcpdAdapterSettings.setStartClientAddress(startDhcpStr);
            int range = ((BInteger)this.dhcpdRangeSizeFE.saveValue(context)).getInt();
            dhcpdAdapterSettings.setRange(range);
            DhcpdUtil.validateDhcpdAdapterSettings((BDhcpdAdapterSettings)dhcpdAdapterSettings, (String)adapter.getIpAddress(), (String)adapter.getSubnetMask(), (int)1, (int)240);
        }
        catch (Exception exception) {
            switch (exception.getMessage()) {
                case "TcpIpAdapterEditorDhcpdError.rangeTooSmall": {
                    dhcpdAdapterSettings.setRange(1);
                    break;
                }
                case "TcpIpAdapterEditorDhcpdError.rangeTooBig": {
                    dhcpdAdapterSettings.setRange(240);
                }
            }
            this.saveError(adapter.getAdapterId(), exception.getMessage());
        }
    }

    private void doSetDhcpdEnabledStates() {
        boolean dhcpdSettingsEnabled;
        boolean dhcpdCheckBoxEnabled;
        boolean bl = dhcpdCheckBoxEnabled = !this.isReadonly() && !this.isAdapterReadonly && this.isAdapterEnabledSelected() && !this.dhcpdSettingsReadonly && this.canUseDhcpdv4 && !this.isDhcpEnabledSelected();
        if (this.dhcpdEnabledCheckBox != null) {
            this.dhcpdEnabledCheckBox.setEnabled(dhcpdCheckBoxEnabled);
        }
        boolean bl2 = dhcpdSettingsEnabled = dhcpdCheckBoxEnabled && this.dhcpdEnabledCheckBox != null && this.dhcpdEnabledCheckBox.isSelected();
        if (this.dhcpdLeaseTimeFieldFE != null) {
            this.dhcpdLeaseTimeFieldFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdLeaseTimeFieldFE.setEnabled(dhcpdSettingsEnabled);
        }
        if (this.dhcpdMaxLeaseTimeFieldFE != null) {
            this.dhcpdMaxLeaseTimeFieldFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdMaxLeaseTimeFieldFE.setEnabled(dhcpdSettingsEnabled);
        }
        if (this.dhcpdRangeStartFieldFE != null) {
            this.dhcpdRangeStartFieldFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdRangeStartFieldFE.setEnabled(dhcpdSettingsEnabled);
        }
        if (this.dhcpdRangeSizeFE != null) {
            this.dhcpdRangeSizeFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdRangeSizeFE.setEnabled(dhcpdSettingsEnabled);
        }
        if (this.dhcpdSubnetFieldFE != null) {
            this.dhcpdSubnetFieldFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdSubnetFieldFE.setEnabled(dhcpdSettingsEnabled);
        }
        if (this.dhcpdNetmaskFieldFE != null) {
            this.dhcpdNetmaskFieldFE.setReadonly(!dhcpdSettingsEnabled);
            this.dhcpdNetmaskFieldFE.setEnabled(dhcpdSettingsEnabled);
        }
    }

    public boolean isDhcpdEnabledSelected() {
        return this.dhcpdEnabledCheckBox != null && this.dhcpdEnabledCheckBox.isSelected();
    }

    public void processComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BTcpIpAdapterSettings) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)evt.getSourceComponent();
            Property property = evt.getSlot().asProperty();
            BValue propertyValue = adapter.get(property);
            if (property == BTcpIpAdapterSettings.isAdapterEnabled) {
                this.adapterEnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                this.doSetEnabledStates();
            } else if (property == BTcpIpAdapterSettings.adapterId) {
                this.interfaceIdLabel.setText(propertyValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.description) {
                this.interfaceDescLabel.setText(propertyValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.mediaAccessControlAddress) {
                this.macAddressLabel.setText(propertyValue.toString().trim());
            } else if (this.canUseDhcp && property == BTcpIpAdapterSettings.isDhcpEnabled) {
                this.dhcpEnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                this.doSetEnabledStates();
            } else if (this.canUseDhcp && property == BTcpIpAdapterSettings.dhcpHost) {
                this.dhcpHostLabel.setText(propertyValue.toString().trim());
            } else if (this.canUseDhcp && property == BTcpIpAdapterSettings.dhcpLeaseGranted) {
                this.dhcpLeaseGrantedLabel.setText(propertyValue.toString().trim());
            } else if (this.canUseDhcp && property == BTcpIpAdapterSettings.dhcpLeaseExpires) {
                this.dhcpLeaseExpiresLabel.setText(propertyValue.toString().trim());
            } else if (this.usesAdapterLevelSettings && property == BTcpIpAdapterSettings.domain) {
                this.domainTextField.setText(propertyValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.ipAddress) {
                this.ipAddressFE.loadValue((BObject)((BString)propertyValue));
            } else if (property == BTcpIpAdapterSettings.subnetMask) {
                this.subnetMaskFE.loadValue((BObject)((BString)propertyValue));
            } else if (this.usesAdapterLevelSettings && property == BTcpIpAdapterSettings.defaultGateway) {
                this.gatewayFE.loadValue((BObject)((BString)propertyValue));
            } else if (this.usesAdapterLevelSettings && property == BTcpIpAdapterSettings.dnsHosts) {
                this.dnsHostEditor.loadValue((BObject)((BVector)propertyValue));
            } else if (property == BTcpIpAdapterSettings.isIpv6Supported) {
                if (this.ipv6SupportedLabel != null) {
                    this.ipv6SupportedLabel.setText(propertyValue.toString().trim());
                    this.doSetEnabledStates();
                }
            } else if (this.isIpv6Supported && property == BTcpIpAdapterSettings.isIpv6Enabled) {
                if (this.ipv6EnabledCheckBox != null) {
                    this.ipv6EnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                    this.doSetEnabledStates();
                }
            } else if (this.isIpv6Supported && property == BTcpIpAdapterSettings.ipv6Address) {
                if (this.ipv6AddressFE != null) {
                    this.ipv6AddressFE.loadValue((BObject)((BString)propertyValue));
                }
            } else if (this.isIpv6Supported && property == BTcpIpAdapterSettings.ipv6SubnetPrefixLength) {
                if (this.ipv6SubnetPrefixLengthFE != null) {
                    this.ipv6SubnetPrefixLengthFE.loadValue((BObject)((BInteger)propertyValue), (Context)BTcpIpAdapterSettings.ipv6SubnetPrefixLength.getFacets());
                }
            } else if (this.usesAdapterLevelSettings && this.isIpv6Supported && property == BTcpIpAdapterSettings.ipv6DefaultGateway) {
                if (this.ipv6GatewayFE != null) {
                    this.ipv6GatewayFE.loadValue((BObject)((BString)propertyValue));
                }
            } else if (this.usesAdapterLevelSettings && this.isIpv6Supported && property == BTcpIpAdapterSettings.ipv6DnsHosts) {
                if (this.ipv6DnsHostEditor != null) {
                    this.ipv6DnsHostEditor.loadValue((BObject)((BVector)propertyValue));
                }
            } else if (this.isIpv6Supported && this.canUseIpv6Dhcp && property == BTcpIpAdapterSettings.isIpv6DhcpEnabled) {
                if (this.ipv6DhcpEnabledCheckBox != null) {
                    this.ipv6DhcpEnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                    this.doSetEnabledStates();
                }
            } else if (this.isIpv6Supported && this.canUseIpv6Dhcp && property == BTcpIpAdapterSettings.ipv6DhcpHost) {
                if (this.ipv6DhcpHostLabel != null) {
                    this.ipv6DhcpHostLabel.setText(propertyValue.toString().trim());
                }
            } else if (this.isIpv6Supported && this.canUseIpv6Dhcp && property == BTcpIpAdapterSettings.ipv6DhcpLeaseExpires) {
                if (this.ipv6DhcpLeaseExpiresLabel != null) {
                    this.ipv6DhcpLeaseExpiresLabel.setText(propertyValue.toString().trim());
                }
            } else if (this.isIpv6Supported && this.canUseIpv6Dhcp && property == BTcpIpAdapterSettings.ipv6DhcpLeaseGranted) {
                if (this.ipv6DhcpLeaseGrantedLabel != null) {
                    this.ipv6DhcpLeaseGrantedLabel.setText(propertyValue.toString().trim());
                }
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.isDhcpdIpv4Enabled) {
                this.dhcpdEnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                this.doSetEnabledStates();
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.defaultLeaseTime) {
                this.dhcpdLeaseTimeFieldFE.loadValue((BObject)((BRelTime)propertyValue), (Context)BDhcpdAdapterSettings.defaultLeaseTime.getFacets());
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.maxLeaseTime) {
                this.dhcpdMaxLeaseTimeFieldFE.loadValue((BObject)((BRelTime)propertyValue), (Context)BDhcpdAdapterSettings.maxLeaseTime.getFacets());
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.subnet) {
                this.dhcpdSubnetFieldFE.loadValue((BObject)((BString)propertyValue));
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.subnetMask) {
                this.dhcpdNetmaskFieldFE.loadValue((BObject)((BString)propertyValue));
            } else if (this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.startClientAddress || this.canUseDhcpdv4 && property == BDhcpdAdapterSettings.range) {
                BString startAddress;
                BInteger currentRange = (BInteger)this.dhcpdRangeSizeFE.getCurrentValue();
                if (property == BDhcpdAdapterSettings.startClientAddress) {
                    startAddress = (BString)propertyValue;
                } else {
                    startAddress = (BString)this.dhcpdRangeStartFieldFE.getCurrentValue();
                    currentRange = (BInteger)propertyValue;
                }
                this.dhcpdRangeStartFieldFE.loadValue((BObject)startAddress);
                this.dhcpdRangeSizeFE.loadValue((BObject)currentRange, (Context)BDhcpdAdapterSettings.range.getFacets());
            }
        }
    }
}

