/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.platform.ui.license.FileInfoListModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;

@NiagaraType
public class BFileInfoList
extends BList {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileInfoList.class);
    private IFileFilter dragOverFilter;
    private IFileFilter dropFilter;
    private Command deleteCommand;
    private Command viewCommand;
    private ListTransfer listTransfer;
    private static Logger log = Logger.getLogger("platform");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileInfoList() {
        throw new UnsupportedOperationException();
    }

    public BFileInfoList(FileInfoListModel model, IFileFilter dragOverFilter, ListTransfer listTransfer) {
        this(model, dragOverFilter, dragOverFilter, listTransfer);
    }

    public BFileInfoList(FileInfoListModel model, IFileFilter dragOverFilter, IFileFilter dropFilter, ListTransfer listTransfer) {
        super((ListModel)model);
        this.dragOverFilter = dragOverFilter;
        this.dropFilter = dropFilter;
        this.listTransfer = listTransfer;
        this.setPasteEnabled(true);
        this.deleteCommand = new DeleteFileCommand();
        this.viewCommand = new ViewFileCommand();
    }

    public FileInfoListModel getFileInfoListModel() {
        return (FileInfoListModel)this.getModel();
    }

    public CommandArtifact doDelete() throws Exception {
        this.deleteCommand.invoke();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        BObject[] vals;
        Mark mark = Mark.getCurrent();
        if (mark != null && (vals = mark.getValues())[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)vals[0]) && this.dropFilter.accept((BIFile)vals[0])) {
            this.listTransfer.processFile((BIFile)vals[0]);
        }
        return null;
    }

    public int dragOver(TransferContext cx) {
        Mark mark;
        if (cx.getEnvelope().supports(TransferFormat.mark) && (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)mark.getValues()[0])) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        if (mark.getValues()[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)mark.getValues()[0]) && this.dropFilter.accept((BIFile)mark.getValues()[0])) {
            this.listTransfer.processFile((BIFile)mark.getValues()[0]);
        }
        return null;
    }

    public Command getDeleteCommand() {
        return this.deleteCommand;
    }

    public Command getViewCommand() {
        return this.viewCommand;
    }

    public static interface ListTransfer {
        public void processFile(BIFile var1) throws Exception;
    }

    private class ViewFileCommand
    extends Command {
        public ViewFileCommand() {
            super((BWidget)BFileInfoList.this, TYPE.getModule(), "FileList.view");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                FileInfoListModel model = (FileInfoListModel)BFileInfoList.this.getModel();
                int ix = BFileInfoList.this.getSelectedIndex();
                BDialog.message((BWidget)BFileInfoList.this, (String)model.getFileName(ix), (Object)new BTextEditorPane(model.getFileContents(ix), 20, 80, false));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error reading contents of file", e);
            }
            return null;
        }
    }

    private class DeleteFileCommand
    extends Command {
        public DeleteFileCommand() {
            super((BWidget)BFileInfoList.this, TYPE.getModule(), "FileList.delete");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            FileInfoListModel model = (FileInfoListModel)BFileInfoList.this.getModel();
            int[] ix = BFileInfoList.this.getSelectedIndices();
            if (4 == BDialog.confirm((BWidget)BFileInfoList.this, (String)BFileInfoList.this.getLexicon().getText("FileList.delete.confirmTitle"), (Object)BFileInfoList.this.getLexicon().getText("FileList.delete.confirmMessage"))) {
                model.deleteFiles(ix);
            }
            BFileInfoList.this.getSelection().deselectAll();
            return null;
        }
    }
}

