/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.hx.util.SimpleValidator;
import java.util.ArrayList;
import java.util.List;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;

public class HxStringListHelper
extends HxViewHelper {
    private List<SimpleValidator> itemValidators = new ArrayList<SimpleValidator>();

    protected HxStringListHelper(String fieldName, SimpleValidator[] itemValidators, Context cx) {
        super(fieldName, (BHxView)BHxFieldEditor.makeFor((BObject)BString.DEFAULT, (Context)cx), cx == null ? BFacets.NULL : cx.getFacets());
    }

    public static HxViewHelper makeFE(String fieldName, Context cx) {
        return HxStringListHelper.makeFE(fieldName, (SimpleValidator[])null, cx);
    }

    public static HxViewHelper makeFE(String fieldName, SimpleValidator itemValidator, Context cx) {
        return HxStringListHelper.makeFE(fieldName, new SimpleValidator[]{itemValidator}, cx);
    }

    public static HxViewHelper makeFE(String fieldName, SimpleValidator[] itemValidators, Context cx) {
        return new HxStringListHelper(fieldName, itemValidators == null ? new SimpleValidator[]{} : itemValidators, cx);
    }

    public void addItemValidator(SimpleValidator value) {
        this.itemValidators.add(value);
    }

    @Override
    public void write(BObject value, HxOp op) throws Exception {
        StringBuilder concat = new StringBuilder();
        SlotCursor c = ((BComponent)value).loadSlots().getProperties();
        while (c.next()) {
            if (concat.length() > 0) {
                concat.append(',');
            }
            concat.append(c.get().toString());
        }
        super.write((BObject)BString.make((String)concat.toString()), op);
    }

    @Override
    public BObject save(BObject value, HxOp op) throws Exception {
        BString splitMe = (BString)super.save(value, op);
        String[] items = TextUtil.splitAndTrim((String)splitMe.toString(), (char)',');
        BComponent comp = (BComponent)value;
        comp.removeAll();
        for (String item : items) {
            BString itemValue = BString.make((String)item);
            for (SimpleValidator itemValidator : this.itemValidators) {
                itemValidator.checkValid(this.fieldName, (BSimple)itemValue, (Context)op);
            }
            comp.add(SlotPath.escape((String)item), (BValue)itemValue);
        }
        return comp;
    }

    @Override
    public boolean isFormValueAvailable(HxOp op) {
        return !this.isReadonly() && op.make(this.fieldName, (OrdTarget)op).getUnsafeFormValue("value") != null;
    }

    @Override
    public void validate(BObject value, HxOp op) throws Exception {
        String[] items;
        BString splitMe = (BString)super.save(value, op);
        for (String item : items = TextUtil.splitAndTrim((String)splitMe.toString(), (char)',')) {
            BString itemValue = BString.make((String)item);
            for (SimpleValidator itemValidator : this.itemValidators) {
                itemValidator.checkValid(this.fieldName, (BSimple)itemValue, (Context)op);
            }
        }
    }
}

