/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.hx.util.HostAddressValidator;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxButtonHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxStringHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.syslog.BSyslogFacilityEnum;
import com.tridium.platform.syslog.BSyslogLevelEnum;
import com.tridium.platform.syslog.BSyslogPlatformService;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import com.tridium.platform.ui.syslog.BSyslogPlatformServicePlugin;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"platform:SyslogPlatformServicePlugin"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxSyslogPlatformServiceEditor
extends BHxView {
    @Generated
    public static final BHxSyslogPlatformServiceEditor INSTANCE = new BHxSyslogPlatformServiceEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSyslogPlatformServiceEditor.class);
    private final HxViewHelper enabledFE;
    private final HxViewHelper serverHostFE;
    private final HxViewHelper serverPortFE;
    private final HxViewHelper transportProtocolFE;
    private final HxViewHelper certificateAliasFE;
    private final HxViewHelper certificatePasswordFE;
    private final HxViewHelper platformLogFE;
    private final HxViewHelper stationLogFE;
    private final HxViewHelper stationAuditFE;
    private final HxViewHelper securityAuditFE;
    private final HxViewHelper facilityFE;
    private final HxViewHelper queueSizeFE;
    private final HxViewHelper logLevelFilterFE;
    private final HxViewHelper syslogServerConnectionAlarmFE;
    private final HxViewHelper syslogMessageQueueAlarmFE;
    private final HxButtonHelper refreshButton;
    private final HxButtonHelper saveButton;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSyslogPlatformServiceEditor() {
        BFacets booleanFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:SyslogPlatformServicePlugin.enabled.label)%"), BString.make((String)"%lexicon(platform:SyslogPlatformServicePlugin.disabled.label)%")});
        this.enabledFE = HxBooleanHelper.makeFE("enabled", (Context)booleanFacets);
        this.serverHostFE = HxStringHelper.makeFE("serverHost", HostAddressValidator.INSTANCE, null);
        this.serverPortFE = HxViewHelper.makeFE("serverPort", (BObject)BInteger.DEFAULT, (Context)BSyslogSettings.serverPort.getFacets());
        this.transportProtocolFE = HxViewHelper.makeFE("transportProtocol", (BObject)BSyslogTransportProtocolEnum.DEFAULT, (Context)BSyslogSettings.transportProtocol.getFacets());
        this.certificateAliasFE = HxViewHelper.makeFE("alias", (BObject)BCertificateAliasAndPassword.DEFAULT, (Context)BCertificateAliasAndPassword.alias.getFacets());
        this.certificatePasswordFE = HxViewHelper.makeFE("password", (BObject)BCertificateAliasAndPassword.DEFAULT, (Context)BCertificateAliasAndPassword.password.getFacets());
        this.platformLogFE = HxBooleanHelper.makeFE("platformLogEnabled", (Context)booleanFacets);
        this.stationLogFE = HxBooleanHelper.makeFE("stationLogEnabled", (Context)booleanFacets);
        this.logLevelFilterFE = HxViewHelper.makeFE("logLevelFilter", (BObject)BSyslogLevelEnum.DEFAULT, (Context)BSyslogSettings.logLevelFilter.getFacets());
        this.stationAuditFE = HxBooleanHelper.makeFE("stationAuditEnabled", (Context)booleanFacets);
        this.securityAuditFE = HxBooleanHelper.makeFE("securityAuditEnabled", (Context)booleanFacets);
        this.facilityFE = HxViewHelper.makeFE("facility", (BObject)BSyslogFacilityEnum.DEFAULT, (Context)BSyslogSettings.facility.getFacets());
        this.queueSizeFE = HxViewHelper.makeFE("queueSize", (BObject)BInteger.DEFAULT, (Context)BSyslogSettings.queueSize.getFacets());
        this.syslogServerConnectionAlarmFE = HxBooleanHelper.makeFE("syslogServerConnectionAlarmEnabled", (Context)booleanFacets);
        this.syslogMessageQueueAlarmFE = HxBooleanHelper.makeFE("syslogMessageQueueAlarmSupport", (Context)booleanFacets);
        this.refreshButton = HxButtonHelper.makeRefresh();
        this.saveButton = HxButtonHelper.makeSave();
    }

    public void write(HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)"module://platform/lib/BHxSyslogPlatformServiceEditor.js");
        op.addJavaScript(ord);
        BSyslogPlatformService service = (BSyslogPlatformService)op.get();
        service.checkPropertiesLoaded();
        service.poll();
        BSyslogSettings settings = service.getSyslogSettings();
        HtmlWriter out = op.getHtmlWriter();
        HxMessageHelper.writeMessage("SyslogPlatformServiceEditor", op);
        boolean isSettingsReadonly = settings.getIsReadonly();
        this.enabledFE.setReadonly(isSettingsReadonly);
        this.serverHostFE.setReadonly(isSettingsReadonly);
        this.serverPortFE.setReadonly(isSettingsReadonly);
        this.transportProtocolFE.setReadonly(isSettingsReadonly);
        this.certificateAliasFE.setReadonly(isSettingsReadonly);
        this.certificatePasswordFE.setReadonly(isSettingsReadonly);
        this.platformLogFE.setReadonly(isSettingsReadonly);
        this.stationLogFE.setReadonly(isSettingsReadonly);
        this.logLevelFilterFE.setReadonly(isSettingsReadonly);
        this.stationAuditFE.setReadonly(isSettingsReadonly);
        this.securityAuditFE.setReadonly(isSettingsReadonly);
        this.facilityFE.setReadonly(isSettingsReadonly);
        this.queueSizeFE.setReadonly(isSettingsReadonly);
        this.saveButton.setReadonly(isSettingsReadonly);
        out.println("<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.enabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.enabledFE.write((BObject)BBoolean.make((boolean)settings.getEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.serverHost, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.serverHostFE.write((BObject)BString.make((String)settings.getServerHost()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.serverPort, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.serverPortFE.write((BObject)BInteger.make((int)settings.getServerPort()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.messageType, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(settings.getMessageType().toString(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.transportProtocol, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.transportProtocolFE.write((BObject)settings.getTransportProtocol(), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getClientAliasAndPassword().getDisplayName((Slot)BCertificateAliasAndPassword.alias, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.certificateAliasFE.write((BObject)BString.make((String)settings.getClientAliasAndPassword().getAlias()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getClientAliasAndPassword().getDisplayName((Slot)BCertificateAliasAndPassword.password, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.certificatePasswordFE.write((BObject)settings.getClientAliasAndPassword().getPassword(), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.platformLogEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.platformLogFE.write((BObject)BBoolean.make((boolean)settings.getPlatformLogEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.stationLogEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.stationLogFE.write((BObject)BBoolean.make((boolean)settings.getStationLogEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.logLevelFilter, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.logLevelFilterFE.write((BObject)settings.getLogLevelFilter(), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.stationAuditEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.stationAuditFE.write((BObject)BBoolean.make((boolean)settings.getStationAuditEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.securityAuditEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.securityAuditFE.write((BObject)BBoolean.make((boolean)settings.getSecurityAuditEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.facility, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.facilityFE.write((BObject)settings.getFacility(), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(settings.getDisplayName((Slot)BSyslogSettings.queueSize, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.queueSizeFE.write((BObject)BInteger.make((int)settings.getQueueSize()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.stationServerStatus, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(BSyslogPlatformServicePlugin.makeServerStatusString(service.getStationServerStatus(), (Context)op), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.stationServerFaultCause, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(service.getStationServerFaultCause(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.queueFullPercentStation, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(service.getQueueFullPercentStation() + "%", false);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.platformServerStatus, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(BSyslogPlatformServicePlugin.makeServerStatusString(service.getPlatformServerStatus(), (Context)op), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.platformServerFaultCause, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(service.getPlatformServerFaultCause(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.queueFullPercentPlatform, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(service.getQueueFullPercentPlatform() + "%", false);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.syslogServerConnectionAlarmEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.syslogServerConnectionAlarmFE.write((BObject)BBoolean.make((boolean)service.getSyslogServerConnectionAlarmEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").safe(service.getDisplayName((Slot)BSyslogPlatformService.syslogMessageQueueAlarmEnabled, (Context)op), false).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.syslogMessageQueueAlarmFE.write((BObject)BBoolean.make((boolean)service.getSyslogMessageQueueAlarmEnabled()), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("<div style='padding:10px; text-align:center;'>");
        this.refreshButton.write(op);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("onclick", "onSyslogPlatformServiceSave(\"" + op.scope("submit") + "\")");
        this.saveButton.write(op, attrs);
        out.println("</div>");
    }

    public BObject save(HxOp op) throws Exception {
        BSyslogPlatformService syslogPlatformService = (BSyslogPlatformService)op.get();
        BSyslogSettings settings = syslogPlatformService.getSyslogSettings();
        if (!settings.getIsReadonly()) {
            settings.setEnabled(((BIBoolean)this.enabledFE.save((BObject)settings.get(BSyslogSettings.enabled), op)).getBoolean());
            settings.setServerHost(this.serverHostFE.save((BObject)settings.get(BSyslogSettings.serverHost), op).toString());
            settings.setServerPort(((BNumber)this.serverPortFE.save((BObject)settings.get(BSyslogSettings.serverPort), op)).getInt());
            settings.setTransportProtocol((BSyslogTransportProtocolEnum)this.transportProtocolFE.save((BObject)settings.getTransportProtocol(), op));
            settings.getClientAliasAndPassword().setAlias(this.certificateAliasFE.save((BObject)BString.make((String)settings.getClientAliasAndPassword().getAlias()), op).toString());
            settings.getClientAliasAndPassword().setPassword((BPassword)this.certificatePasswordFE.save((BObject)settings.getClientAliasAndPassword().getPassword(), op));
            settings.setPlatformLogEnabled(((BIBoolean)this.platformLogFE.save((BObject)settings.get(BSyslogSettings.platformLogEnabled), op)).getBoolean());
            settings.setStationLogEnabled(((BIBoolean)this.stationLogFE.save((BObject)settings.get(BSyslogSettings.stationLogEnabled), op)).getBoolean());
            settings.setLogLevelFilter((BSyslogLevelEnum)this.logLevelFilterFE.save((BObject)settings.get(BSyslogSettings.logLevelFilter), op));
            settings.setStationAuditEnabled(((BIBoolean)this.stationAuditFE.save((BObject)settings.get(BSyslogSettings.stationAuditEnabled), op)).getBoolean());
            settings.setSecurityAuditEnabled(((BIBoolean)this.securityAuditFE.save((BObject)settings.get(BSyslogSettings.securityAuditEnabled), op)).getBoolean());
            settings.setFacility((BSyslogFacilityEnum)this.facilityFE.save((BObject)settings.get(BSyslogSettings.facility), op));
            settings.setQueueSize(((BNumber)this.queueSizeFE.save((BObject)settings.get(BSyslogSettings.queueSize), op)).getInt());
            syslogPlatformService.setSyslogSettings(settings);
        }
        syslogPlatformService.setSyslogServerConnectionAlarmEnabled(((BIBoolean)this.syslogServerConnectionAlarmFE.save((BObject)syslogPlatformService.get(BSyslogPlatformService.syslogServerConnectionAlarmEnabled), op)).getBoolean());
        syslogPlatformService.setSyslogMessageQueueAlarmEnabled(((BIBoolean)this.syslogMessageQueueAlarmFE.save((BObject)syslogPlatformService.get(BSyslogPlatformService.syslogMessageQueueAlarmEnabled), op)).getBoolean());
        syslogPlatformService.savePlatformServiceProperties();
        return syslogPlatformService;
    }
}

