/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.BLocalizableLabel;
import com.tridium.ui.UiEnv;
import java.util.Optional;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="textFormat", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="backgroundImage", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="hyperlink", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="hoverTextFormat", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="statusTextFormat", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="showHandCursor", type="boolean", defaultValue="true"), @NiagaraProperty(name="confirmRequired", type="boolean", defaultValue="false"), @NiagaraProperty(name="text", type="String", defaultValue="BString.DEFAULT", flags=1, override=true)})
public class BLocalizableButton
extends BButton {
    @Generated
    public static final Property textFormat = BLocalizableButton.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property backgroundImage = BLocalizableButton.newProperty((int)0, (BValue)BImage.NULL, null);
    @Generated
    public static final Property hyperlink = BLocalizableButton.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property hoverTextFormat = BLocalizableButton.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property statusTextFormat = BLocalizableButton.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property showHandCursor = BLocalizableButton.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property confirmRequired = BLocalizableButton.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property text = BLocalizableButton.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalizableButton.class);

    @Generated
    public BFormat getTextFormat() {
        return (BFormat)this.get(textFormat);
    }

    @Generated
    public void setTextFormat(BFormat v) {
        this.set(textFormat, (BValue)v, null);
    }

    @Generated
    public BImage getBackgroundImage() {
        return (BImage)this.get(backgroundImage);
    }

    @Generated
    public void setBackgroundImage(BImage v) {
        this.set(backgroundImage, (BValue)v, null);
    }

    @Generated
    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    @Generated
    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    @Generated
    public BFormat getHoverTextFormat() {
        return (BFormat)this.get(hoverTextFormat);
    }

    @Generated
    public void setHoverTextFormat(BFormat v) {
        this.set(hoverTextFormat, (BValue)v, null);
    }

    @Generated
    public BFormat getStatusTextFormat() {
        return (BFormat)this.get(statusTextFormat);
    }

    @Generated
    public void setStatusTextFormat(BFormat v) {
        this.set(statusTextFormat, (BValue)v, null);
    }

    @Generated
    public boolean getShowHandCursor() {
        return this.getBoolean(showHandCursor);
    }

    @Generated
    public void setShowHandCursor(boolean v) {
        this.setBoolean(showHandCursor, v, null);
    }

    @Generated
    public boolean getConfirmRequired() {
        return this.getBoolean(confirmRequired);
    }

    @Generated
    public void setConfirmRequired(boolean v) {
        this.setBoolean(confirmRequired, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doInvokeAction(CommandEvent event) {
        try {
            BWidgetShell shell = this.getShell();
            BOrd ord = this.getHyperlink();
            if (ord != null && !ord.isNull() && shell instanceof BIHyperlinkShell) {
                String hyperlinkTo;
                if (this.getConfirmRequired() && !this.confirm(hyperlinkTo = UiLexicon.bajaui().getText("hyperlinkTo"), hyperlinkTo + ": " + ord.toString())) {
                    return;
                }
                ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
        BImage image = this.getBackgroundImage();
        if (image != null && !image.isNull()) {
            if (!this.isEnabled()) {
                image = image.getDisabledImage();
            }
            double imageX = (this.getWidth() - image.getWidth()) / 2.0;
            double imageY = (this.getHeight() - image.getHeight()) / 2.0;
            this.paintIcon(g, image, imageX, imageY);
        }
    }

    public String getText() {
        return BLocalizableLabel.getDisplayText((BWidget)this);
    }

    public void mouseEntered(BMouseEvent event) {
        super.mouseEntered(event);
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            BOrd ord = this.getHyperlink();
            if (this.getShowHandCursor() || ord != null && !ord.isNull() && shell instanceof BIHyperlinkShell) {
                this.setMouseCursor(MouseCursor.hand);
            }
            this.formatStatusText().ifPresent(arg_0 -> ((BWidgetShell)shell).showStatus(arg_0));
        }
    }

    public void mouseHover(BMouseEvent event) {
        if (this.getButtonStyle() == BButtonStyle.toolBar) {
            this.formatHoverText().ifPresent(hoverText -> {
                double x = event.getX();
                double y = event.getY();
                y = Math.max(this.getHeight() + 1.0, y + 16.0);
                UiEnv.get().openBubbleHelp((BWidget)this, x, y, hoverText);
            });
        }
    }

    public boolean canInvokeAction(BComponent comp, String actionName) {
        try {
            Action action;
            int flags;
            BPermissions permissions = BPermissions.all;
            if (comp != null) {
                permissions = comp.getPermissions(null);
            }
            if (((flags = comp.getFlags((Slot)(action = comp.getAction(actionName)))) & 0x100) != 0) {
                return permissions.has(4);
            }
            return permissions.has(64);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean confirm(String title, String msg) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            int dlgResponse = BDialog.confirm((BWidget)shell, (String)title, (Object)msg);
            return dlgResponse == 4;
        }
        return false;
    }

    private Optional<String> formatHoverText() {
        return this.formatText(this.getHoverTextFormat(), BLocalizableButton.getDefaultContext());
    }

    private Optional<String> formatStatusText() {
        return this.formatText(this.getStatusTextFormat(), BLocalizableButton.getDefaultContext());
    }

    public Optional<String> formatText(BFormat format, Context cx) {
        if (format.equals((Object)BFormat.DEFAULT)) {
            return Optional.empty();
        }
        return Optional.of(format.format((Object)this, cx));
    }

    private static Context getDefaultContext() {
        return BUser.getCurrentAuthenticatedUser();
    }
}

