/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.JavaTypeVariable;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModifierDoc;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.TopicDoc;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;

public class ClassDoc
extends ModifierDoc {
    public static final ClassDoc[] none = new ClassDoc[0];
    public static final int INTERFACE = 1;
    public static final int EXCEPTION = 2;
    public static final int BAJA_TYPE = 4;
    public static final int ENUM = 8;
    public static final int ANNOTATION_TYPE = 16;
    public static final BIcon defaultIcon = BIcon.std((String)"object.png");
    protected String module;
    protected String profile;
    protected String name;
    protected String qualifiedName;
    protected String packageName;
    protected String docModule;
    protected JavaType superClass;
    protected JavaType[] interfaces;
    protected JavaType[] ancestors;
    protected JavaType[] extenders;
    protected JavaType[] implementors;
    protected JavaTypeVariable[] typeParams;
    protected ConstructorDoc[] constructors;
    protected MethodDoc[] methods;
    protected FieldDoc[] fields;
    protected FieldDoc[] enumConstants;
    protected ClassDoc[] innerClasses;
    protected PropertyDoc[] properties;
    protected ActionDoc[] actions;
    protected TopicDoc[] topics;
    protected int classCategory;
    protected boolean isInnerClass;
    protected BIcon icon;
    private MethodDoc[] methodsSorted;
    private FieldDoc[] fieldsSorted;
    private FieldDoc[] enumConstantsSorted;
    private PropertyDoc[] propertiesSorted;
    private ActionDoc[] actionsSorted;
    private TopicDoc[] topicsSorted;

    public ClassDoc(String module, String profile, String name, String packageName, String docModule, int modifiers, JavaType superClass, JavaType[] interfaces, JavaTypeVariable[] typeParams, JavaType[] ancestors, JavaType[] extenders, JavaType[] implementors, PropertyDoc[] properties, ActionDoc[] actions, TopicDoc[] topics, FieldDoc[] fields, FieldDoc[] enumConstants, ConstructorDoc[] constructors, MethodDoc[] methods, ClassDoc[] innerClasses, int classCategory, boolean isInnerClass, DescriptionPart[] description, Tag[] tags, Annotation[] annotations) {
        super(modifiers, description, tags, annotations);
        this.module = module;
        this.profile = profile;
        this.name = name;
        this.packageName = packageName;
        this.qualifiedName = packageName + '.' + name.replace('.', '$');
        this.docModule = docModule;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.ancestors = ancestors;
        this.extenders = extenders;
        this.implementors = implementors;
        this.typeParams = typeParams;
        this.properties = properties;
        this.initDeclaring(properties);
        this.actions = actions;
        this.initDeclaring(actions);
        this.topics = topics;
        this.initDeclaring(topics);
        this.fields = fields;
        this.initDeclaring(fields);
        this.enumConstants = enumConstants;
        this.initDeclaring(enumConstants);
        this.constructors = constructors;
        this.initDeclaring(constructors);
        this.methods = methods;
        this.initDeclaring(methods);
        this.innerClasses = innerClasses;
        this.classCategory = classCategory;
        this.isInnerClass = isInnerClass;
        this.icon = defaultIcon;
    }

    private void initDeclaring(MemberDoc[] members) {
        for (MemberDoc m : members) {
            if (m.declaringClass != null) continue;
            m.declaringClass = this;
        }
    }

    public String module() {
        return this.module;
    }

    public String profile() {
        return this.profile;
    }

    public String modulePart() {
        return this.module + '-' + this.profile;
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public String packageName() {
        return this.packageName;
    }

    public String docModule() {
        return this.docModule;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public JavaType superClass() {
        return this.superClass;
    }

    public JavaType[] interfaces() {
        return this.interfaces;
    }

    public JavaType[] ancestors() {
        return this.ancestors;
    }

    public JavaType[] extenders() {
        return this.extenders;
    }

    public JavaType[] implementors() {
        return this.implementors;
    }

    public JavaTypeVariable[] typeParams() {
        return this.typeParams;
    }

    public PropertyDoc[] properties() {
        return this.properties;
    }

    public ActionDoc[] actions() {
        return this.actions;
    }

    public TopicDoc[] topics() {
        return this.topics;
    }

    public FieldDoc[] fields() {
        return this.fields;
    }

    public FieldDoc[] enumConstants() {
        return this.enumConstants;
    }

    public ConstructorDoc[] constructors() {
        return this.constructors;
    }

    public MethodDoc[] methods() {
        return this.methods;
    }

    public ClassDoc[] innerClasses() {
        return this.innerClasses;
    }

    @Override
    public BIcon icon() {
        return this.icon;
    }

    public ClassSummary classSummary() {
        return new ClassSummary(this.name, this.packageName, this.classCategory, this.summary());
    }

    public String explicitModifiersToString() {
        int modifiers = this.modifiers();
        if (this.isInterface() || this.isAnnotationType()) {
            modifiers &= 0xFFFFFBFF;
        } else if (this.isEnum()) {
            modifiers &= 0xFFFFFFEF;
            if (this.isInnerClass()) {
                modifiers &= 0xFFFFFFF7;
            }
        }
        return ModifierDoc.modifiersToString(modifiers);
    }

    public int classCategory() {
        return this.classCategory;
    }

    public boolean isBajaType() {
        return (this.classCategory & 4) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.classCategory & 1) != 0;
    }

    public boolean isException() {
        return (this.classCategory & 2) != 0;
    }

    public boolean isEnum() {
        return (this.classCategory & 8) != 0;
    }

    public boolean isAnnotationType() {
        return (this.classCategory & 0x10) != 0;
    }

    public static String categoryToString(int c) {
        if ((c & 1) != 0) {
            return "interface";
        }
        if ((c & 2) != 0) {
            return "exception";
        }
        if ((c & 8) != 0) {
            return "enum";
        }
        if ((c & 0x10) != 0) {
            return "annotation";
        }
        return null;
    }

    public static int stringToCategory(String s) {
        if ("interface".equals(s)) {
            return 1;
        }
        if ("exception".equals(s)) {
            return 2;
        }
        if ("enum".equals(s)) {
            return 8;
        }
        if ("annotation".equals(s)) {
            return 16;
        }
        return 0;
    }

    public PropertyDoc[] propertiesSorted() {
        if (this.propertiesSorted == null) {
            this.propertiesSorted = new PropertyDoc[this.properties.length];
            ClassDoc.sort(this.properties, this.propertiesSorted);
        }
        return this.propertiesSorted;
    }

    public ActionDoc[] actionsSorted() {
        if (this.actionsSorted == null) {
            this.actionsSorted = new ActionDoc[this.actions.length];
            ClassDoc.sort(this.actions, this.actionsSorted);
        }
        return this.actionsSorted;
    }

    public TopicDoc[] topicsSorted() {
        if (this.topicsSorted == null) {
            this.topicsSorted = new TopicDoc[this.topics.length];
            ClassDoc.sort(this.topics, this.topicsSorted);
        }
        return this.topicsSorted;
    }

    public MethodDoc[] methodsSorted() {
        if (this.methodsSorted == null) {
            this.methodsSorted = new MethodDoc[this.methods.length];
            ClassDoc.sort(this.methods, this.methodsSorted);
        }
        return this.methodsSorted;
    }

    public FieldDoc[] fieldsSorted() {
        if (this.fieldsSorted == null) {
            this.fieldsSorted = new FieldDoc[this.fields.length];
            ClassDoc.sort(this.fields, this.fieldsSorted);
        }
        return this.fieldsSorted;
    }

    public FieldDoc[] enumConstantsSorted() {
        if (this.enumConstantsSorted == null) {
            this.enumConstantsSorted = new FieldDoc[this.enumConstants.length];
            ClassDoc.sort(this.enumConstants, this.enumConstantsSorted);
        }
        return this.enumConstantsSorted;
    }

    protected static void sort(MemberDoc[] orig, MemberDoc[] sorted) {
        int len = orig.length;
        Object[] keys = new String[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = orig[i].name();
            sorted[i] = orig[i];
        }
        SortUtil.sort((Object[])keys, (Object[])sorted);
    }

    private static String getClassTypeDeclarationString(int c) {
        if ((c & 1) != 0) {
            return "interface";
        }
        if ((c & 2) != 0) {
            return "exception";
        }
        if ((c & 8) != 0) {
            return "enum";
        }
        if ((c & 0x10) != 0) {
            return "@interface";
        }
        return "class";
    }

    public String toString() {
        return ClassDoc.getClassTypeDeclarationString(this.classCategory) + ' ' + this.qualifiedName();
    }

    public void dump() {
        if (this.annotations.length > 0) {
            for (int i = 0; i < this.annotations.length; ++i) {
                System.out.println(this.annotations[i].toString());
            }
        }
        String clsType = ClassDoc.getClassTypeDeclarationString(this.classCategory);
        System.out.println(this.modifiersToString() + ' ' + clsType + ' ' + this.qualifiedName);
        System.out.println("  extends " + this.superClass);
        if (this.interfaces.length > 0) {
            System.out.println("  implements " + this.interfaces[0]);
            for (int i = 1; i < this.interfaces.length; ++i) {
                System.out.println("             " + this.interfaces[i]);
            }
        }
        System.out.println("{");
        if (this.constructors.length > 0) {
            System.out.println();
            System.out.println("// Constructors");
            for (ConstructorDoc constructorDoc : this.constructors) {
                System.out.println("  " + constructorDoc);
            }
        }
        if (this.methods.length > 0) {
            System.out.println();
            System.out.println("// Methods");
            for (MethodDoc methodDoc : this.methods) {
                System.out.println("  " + methodDoc);
            }
        }
        if (this.fields.length > 0) {
            System.out.println();
            System.out.println("// Fields");
            for (FieldDoc fieldDoc : this.fields) {
                System.out.println("  " + fieldDoc);
            }
        }
        for (ClassDoc classDoc : this.innerClasses) {
            System.out.println();
            System.out.println("//////////////////////////////////////////////");
            System.out.println("// Inner Class " + classDoc.name());
            classDoc.dump();
            System.out.println("// Inner Class " + classDoc.name());
            System.out.println("//////////////////////////////////////////////");
            System.out.println();
        }
        System.out.println("}");
    }
}

