/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class Hierarchy {
    private static Hierarchy h;
    static final File FILE;
    private boolean depersisted;
    private Map<Entry, XElem> entryHash;

    private Hierarchy() {
    }

    public static synchronized Hierarchy instance() {
        if (h == null) {
            h = new Hierarchy();
        }
        return h;
    }

    private void loadEntryHash(XElem rootElem, XElem elm) {
        XElem[] kidElms;
        if (!elm.equals((Object)rootElem)) {
            Entry entry = Hierarchy.toEntry(elm);
            this.entryHash.put(entry, elm);
        }
        for (XElem kid : kidElms = elm.elems()) {
            this.loadEntryHash(rootElem, kid);
        }
    }

    private static Entry toEntry(XElem elm) {
        int m = elm.attrIndex("m");
        int p = elm.attrIndex("p");
        int n = elm.attrIndex("n");
        return new Entry(elm.attrValue(m).intern(), elm.attrValue(p).intern(), elm.attrValue(n).intern());
    }

    public synchronized void ensureDepersisted() throws Exception {
        if (!this.depersisted) {
            this.depersist();
        }
    }

    synchronized void helpCreated() {
        if (this.depersisted) {
            this.entryHash.clear();
            this.depersisted = false;
        }
    }

    private void depersist() throws Exception {
        AccessController.doPrivileged(() -> {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(FILE));){
                this.depersist(in);
            }
            return null;
        });
    }

    private void depersist(InputStream in) throws Exception {
        XElem rootElem = XParser.make((InputStream)in).parse();
        this.entryHash = new HashMap<Entry, XElem>();
        this.loadEntryHash(rootElem, rootElem);
        this.depersisted = true;
    }

    public void htmlCompilerDepersist(InputStream in) throws Exception {
        this.depersist(in);
    }

    public synchronized boolean available() {
        return this.depersisted;
    }

    public boolean hasSubEntries(Entry look) {
        try {
            this.ensureDepersisted();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        XElem found = this.entryHash.get(look);
        if (found == null) {
            return false;
        }
        return found.elems().length > 0;
    }

    public Entry[] getSubEntries(Entry look) {
        try {
            this.ensureDepersisted();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        XElem found = this.entryHash.get(look);
        XElem[] kidElms = found.elems();
        Entry[] entries = new Entry[kidElms.length];
        for (int i = 0; i < kidElms.length; ++i) {
            entries[i] = Hierarchy.toEntry(kidElms[i]);
        }
        return entries;
    }

    static {
        FILE = AccessController.doPrivileged(() -> new File(HelpSystem.HELP, "hierarchy.xml"));
    }

    public static class Entry
    implements Comparable<Entry> {
        boolean isRoot;
        String modulePart;
        String pkg;
        String name;

        Entry() {
            this.isRoot = true;
        }

        public Entry(String modulePart, String pkg, String name) {
            this.modulePart = modulePart == null ? "" : modulePart;
            this.pkg = pkg == null ? "" : pkg;
            this.name = name;
            this.isRoot = false;
        }

        public String toString() {
            return this.modulePart + ':' + this.pkg + '.' + this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            Entry e = (Entry)obj;
            if (this.isRoot) {
                return e.isRoot;
            }
            if (e.isRoot) {
                return false;
            }
            return this.modulePart.equals(e.modulePart) && this.pkg.equals(e.pkg) && this.name.equals(e.name);
        }

        public int hashCode() {
            if (this.isRoot) {
                return 0;
            }
            return Objects.hash(this.modulePart, this.pkg, this.name);
        }

        @Override
        public int compareTo(Entry e) {
            if (this.isRoot) {
                return e.isRoot ? 0 : -1;
            }
            if (e.isRoot) {
                return 1;
            }
            int n = this.modulePart.compareTo(e.modulePart);
            if (n != 0) {
                return n;
            }
            n = this.pkg.compareTo(e.pkg);
            if (n != 0) {
                return n;
            }
            return this.name.compareTo(e.name);
        }

        public String modulePart() {
            return this.modulePart;
        }

        public String packageName() {
            return this.pkg;
        }

        public String name() {
            return this.name;
        }

        public String qualifiedName() {
            return this.pkg + '.' + this.name;
        }
    }
}

