/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.util.ObjectUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;

public abstract class HelpVerifier {
    private static void checkModule(ModuleInfo module, TypeInfo isType) {
        TypeInfo[] types = module.getTypes();
        for (int i = 0; i < types.length; ++i) {
            TypeInfo type = types[i];
            if (type.isAbstract() || !type.is(isType)) continue;
            BOrd ord = ObjectUtil.getGuideHelpOrd((TypeInfo)type);
            String status = "OK     ";
            try {
                ord.resolve();
            }
            catch (UnresolvedException e) {
                status = "missing";
            }
            System.out.println(status + "  " + type);
        }
    }

    private static void usage() throws Exception {
        System.out.println("usage: ");
        System.out.println("  HelpVerifier <module> <isType>");
        System.out.println("  use 'all' to check every module");
        System.out.println("example:");
        System.out.println("  HelpVerifier all workbench:WbView");
        System.exit(-1);
    }

    public static void main(String[] args) {
        System.out.println();
        if (args.length != 2) {
            try {
                HelpVerifier.usage();
                Registry reg = Sys.getRegistry();
                TypeInfo isType = reg.getType(args[1]);
                if (args[0].equals("all")) {
                    ModuleInfo[] modules = reg.getModules();
                    for (int i = 0; i < modules.length; ++i) {
                        HelpVerifier.checkModule(modules[i], isType);
                    }
                } else {
                    for (ModuleInfo mi : reg.getModules(args[0])) {
                        HelpVerifier.checkModule(mi, isType);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

