/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.BDdfPointDeviceExt;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;
import com.tridium.ddf.ui.DdfMgrUtil;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.device.BIDdfDeviceMgrAgent;
import com.tridium.ddf.ui.device.DdfDeviceManagerLexicon;
import com.tridium.ddf.ui.point.BDdfPointManager;
import com.tridium.ddf.ui.point.BIDdfPointMgrAgent;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;

public class DdfMgrControllerUtil
implements IDdfFacetConst {
    protected DdfMgrControllerUtil() {
    }

    public static CommandArtifact doDiscover(BAbstractManager mgr, Context cx) throws Exception {
        BIDdfDiscoveryHost discoveryHost = DdfMgrUtil.findDiscoveryHost(mgr);
        return DdfMgrControllerUtil.doDiscover(mgr, discoveryHost);
    }

    protected static CommandArtifact doDiscover(BAbstractManager mgr, BIDdfDiscoveryHost discoveryHost) throws Exception {
        mgr.getController().learnMode.setSelected(true);
        BDdfAutoDiscoveryPreferences discoveryJobPrefsDefault = (BDdfAutoDiscoveryPreferences)discoveryHost.getDiscoveryPreferences().newCopy();
        if (discoveryJobPrefsDefault.getNeedsJob()) {
            BDdfAutoDiscoveryPreferences discoveryJobPrefs;
            BDdfAutoDiscoveryPreferences bDdfAutoDiscoveryPreferences = discoveryJobPrefs = discoveryJobPrefsDefault.getDoNotAskAgain() ? discoveryJobPrefsDefault : (BDdfAutoDiscoveryPreferences)BWbFieldEditor.dialog((BWidget)mgr, (String)DdfDeviceManagerLexicon.discoveryParameters, (BObject)discoveryJobPrefsDefault);
            if (discoveryJobPrefs != null) {
                mgr.getLearn().setJob(discoveryHost.submitDiscoveryJob(discoveryJobPrefs));
            }
        }
        return null;
    }

    public static final MgrController.IMgrCommand[] makeCommands(MgrController.IMgrCommand[] superCommands, BDdfDeviceManager mgr) {
        BDdfNetwork network = DdfMgrUtil.findDdfNetwork((BAbstractManager)mgr);
        Array deviceMgrCmdAgents = new Array(MgrController.IMgrCommand.class);
        AgentList ddfDeviceMgrAgentList = network.getAgents().filter(AgentFilter.is((Type)BIDdfDeviceMgrAgent.TYPE));
        AgentInfo[] ddfDeviceMgrAgents = ddfDeviceMgrAgentList.list();
        for (int i = 0; i < ddfDeviceMgrAgents.length; ++i) {
            BIDdfDeviceMgrAgent ddfDeviceMgrAgent = (BIDdfDeviceMgrAgent)ddfDeviceMgrAgents[i].getInstance();
            deviceMgrCmdAgents.add((Object)DdfDeviceMgrAgentCommand.make((BAbstractManager)mgr, ddfDeviceMgrAgent));
        }
        return MgrController.append((MgrController.IMgrCommand[])superCommands, (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])deviceMgrCmdAgents.trim()));
    }

    public static final MgrController.IMgrCommand[] makeCommands(MgrController.IMgrCommand[] superCommands, BDdfPointManager mgr) {
        Array pointMgrCmdAgents = new Array(MgrController.IMgrCommand.class);
        BDdfDevice device = DdfMgrUtil.findDdfDevice((BAbstractManager)mgr);
        AgentList ddfPointMgrAgentListOnDevice = device.getAgents().filter(AgentFilter.is((Type)BIDdfPointMgrAgent.TYPE));
        AgentInfo[] ddfPointMgrAgentsOnDevice = ddfPointMgrAgentListOnDevice.list();
        for (int i = 0; i < ddfPointMgrAgentsOnDevice.length; ++i) {
            BIDdfPointMgrAgent ddfPointMgrAgent = (BIDdfPointMgrAgent)ddfPointMgrAgentsOnDevice[i].getInstance();
            pointMgrCmdAgents.add((Object)DdfPointMgrAgentCommand.make((BAbstractManager)mgr, ddfPointMgrAgent));
        }
        BDdfPointDeviceExt ptDevExt = DdfMgrUtil.findDdfPointDeviceExt((BAbstractManager)mgr);
        AgentList ddfPointMgrAgentListOnPtDevExt = ptDevExt.getAgents().filter(AgentFilter.is((Type)BIDdfPointMgrAgent.TYPE));
        AgentInfo[] ddfPointMgrAgentsOnPtDevExt = ddfPointMgrAgentListOnPtDevExt.list();
        for (int i = 0; i < ddfPointMgrAgentsOnPtDevExt.length; ++i) {
            BIDdfPointMgrAgent ddfPointMgrAgent = (BIDdfPointMgrAgent)ddfPointMgrAgentsOnPtDevExt[i].getInstance();
            pointMgrCmdAgents.add((Object)DdfPointMgrAgentCommand.make((BAbstractManager)mgr, ddfPointMgrAgent));
        }
        return MgrController.append((MgrController.IMgrCommand[])superCommands, (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])pointMgrCmdAgents.trim()));
    }

    public static void updateCommands(BAbstractManager mgr) {
        MgrController.IMgrCommand[] mgrCommands = mgr.getController().getCommands();
        for (int i = 0; i < mgrCommands.length; ++i) {
            if (mgrCommands[i] instanceof DdfDeviceMgrAgentCommand) {
                DdfDeviceMgrAgentCommand ddfDeviceMgrCommand = (DdfDeviceMgrAgentCommand)mgrCommands[i];
                ddfDeviceMgrCommand.agent.update((BDdfDeviceManager)mgr, ddfDeviceMgrCommand);
                continue;
            }
            if (!(mgrCommands[i] instanceof DdfPointMgrAgentCommand)) continue;
            DdfPointMgrAgentCommand ddfPointMgrCommand = (DdfPointMgrAgentCommand)mgrCommands[i];
            ddfPointMgrCommand.agent.update((BDdfPointManager)mgr, ddfPointMgrCommand);
        }
    }

    public static class DdfPointMgrAgentCommand
    extends MgrController.MgrCommand {
        BIDdfPointMgrAgent agent;

        public static final DdfPointMgrAgentCommand make(BAbstractManager manager, BIDdfPointMgrAgent ddfAgent) {
            String uiName = ddfAgent.getUiName();
            if (uiName == null) {
                return new DdfPointMgrAgentCommand(manager, ddfAgent, "??");
            }
            Lexicon lex = Sys.loadModule((String)ddfAgent.getType().getTypeSpec().getModuleName()).getLexicon();
            if (lex == null) {
                return new DdfPointMgrAgentCommand(manager, ddfAgent, uiName);
            }
            String lexLabel = lex.get(uiName + ".label");
            if (lexLabel == null) {
                return new DdfPointMgrAgentCommand(manager, ddfAgent, lex.getText(uiName));
            }
            return new DdfPointMgrAgentCommand(manager, lex, ddfAgent);
        }

        DdfPointMgrAgentCommand(BAbstractManager manager, BIDdfPointMgrAgent ddfAgent, String label) {
            super((BWidget)manager, label);
            this.agent = ddfAgent;
            this.setFlags(ddfAgent.getFlags());
        }

        DdfPointMgrAgentCommand(BAbstractManager manager, Lexicon lex, BIDdfPointMgrAgent ddfAgent) {
            super((BWidget)manager, lex, ddfAgent.getUiName());
            this.agent = ddfAgent;
            this.setFlags(ddfAgent.getFlags());
        }

        public CommandArtifact doInvoke() throws Exception {
            BDdfPointManager ddfPointMgr = (BDdfPointManager)this.getOwner();
            CommandArtifact retVal = this.agent.doInvoke(ddfPointMgr, DdfMgrUtil.findDdfNetwork((BAbstractManager)ddfPointMgr), DdfMgrUtil.findDdfDevice((BAbstractManager)ddfPointMgr), DdfMgrUtil.findDdfPointDeviceExt((BAbstractManager)ddfPointMgr));
            ddfPointMgr.getController().updateCommands();
            return retVal;
        }
    }

    public static class DdfDeviceMgrAgentCommand
    extends MgrController.MgrCommand {
        BIDdfDeviceMgrAgent agent;

        public static final DdfDeviceMgrAgentCommand make(BAbstractManager manager, BIDdfDeviceMgrAgent ddfAgent) {
            String uiName = ddfAgent.getUiName();
            if (uiName == null) {
                return new DdfDeviceMgrAgentCommand(manager, ddfAgent, "??");
            }
            Lexicon lex = Sys.loadModule((String)ddfAgent.getType().getTypeSpec().getModuleName()).getLexicon();
            if (lex == null) {
                return new DdfDeviceMgrAgentCommand(manager, ddfAgent, uiName);
            }
            String lexLabel = lex.get(uiName + ".label");
            if (lexLabel == null) {
                return new DdfDeviceMgrAgentCommand(manager, ddfAgent, lex.getText(uiName));
            }
            return new DdfDeviceMgrAgentCommand(manager, lex, ddfAgent);
        }

        DdfDeviceMgrAgentCommand(BAbstractManager manager, BIDdfDeviceMgrAgent ddfAgent, String label) {
            super((BWidget)manager, label);
            this.agent = ddfAgent;
            this.setFlags(ddfAgent.getFlags());
        }

        DdfDeviceMgrAgentCommand(BAbstractManager manager, Lexicon lex, BIDdfDeviceMgrAgent ddfAgent) {
            super((BWidget)manager, lex, ddfAgent.getUiName());
            this.agent = ddfAgent;
            this.setFlags(this.agent.getFlags());
        }

        public CommandArtifact doInvoke() throws Exception {
            BDdfDeviceManager ddfDeviceMgr = (BDdfDeviceManager)this.getOwner();
            CommandArtifact retVal = this.agent.doInvoke(ddfDeviceMgr, DdfMgrUtil.findDdfNetwork((BAbstractManager)ddfDeviceMgr));
            ddfDeviceMgr.getController().updateCommands();
            return retVal;
        }

        public BIDdfDeviceMgrAgent getAgent() {
            return this.agent;
        }
    }
}

