/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import com.tridium.security.AxPasswordUtil;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BUserSyncChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BUserSyncChannel.class);
    static final Lexicon lex = Lexicon.make(BUserSyncChannel.class);
    public static Logger log = Logger.getLogger("niagara.users");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUserSyncChannel() {
        super("usersync");
    }

    public void checkProcess(FoxRequest req) throws Throwable {
        if (this.getConnection().session().isLegacyConnection() && (req.command.equals("startSync") && req.getBoolean("outgoing") || req.command.equals("getOutOfSync") || req.command.equals("updateUsers"))) {
            throw new IncompatibleVersionException(lex.getText("userSync.error.incompatibleAxSyncOut"));
        }
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
        if (this.getConnection().session().isLegacyConnection() && (req.command.equals("startSync") && !req.getBoolean("outgoing") || req.command.equals("getUserStatus") || req.command.equals("updateUsersFromServer"))) {
            throw new IncompatibleVersionException(lex.getText("userSync.error.incompatibleAxSyncIn"));
        }
        super.checkSendRequest(req);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "startSync") {
            return this.startSync(request);
        }
        if (command == "endSync") {
            return this.endSync(request);
        }
        if (command == "getUserStatus") {
            return this.getUserStatus(request);
        }
        if (command == "getOutOfSync") {
            return this.getOutOfSync(request);
        }
        if (command == "updateUsers") {
            return this.updateUsers(request);
        }
        if (command == "updateUsersFromServer") {
            return this.updateUsersFromServer(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        throw new InvalidCommandException(command);
    }

    private boolean supportsPasswordHashing(Version v) {
        if (v == null) {
            log.warning("Could not determine remote baja version (app.hello)");
            return false;
        }
        int major = v.major();
        int minor = v.minor();
        int build = v.build();
        if (major < 3) {
            return false;
        }
        if (major == 3) {
            if (minor <= 4) {
                return false;
            }
            if (minor == 5) {
                return build >= 400;
            }
            if (minor == 6) {
                return build >= 400;
            }
            if (minor == 7) {
                return build >= 100;
            }
            if (minor >= 8) {
                return true;
            }
        }
        return major > 3;
    }

    private Version getServerBajaVersion() throws Exception {
        return this.getServerConnection().getRemoteVersion();
    }

    private Version getClientBajaVersion() throws Exception {
        return this.getClientConnection().getRemoteVersion();
    }

    private boolean serverSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getServerBajaVersion());
    }

    private boolean clientSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getClientBajaVersion());
    }

    public BNiagaraUserDeviceExt getUserDeviceExt() {
        BFoxConnection conn = this.getConnection();
        Optional station = conn.getConnectionTarget(BNiagaraStation.class);
        return station.isPresent() ? ((BNiagaraStation)station.get()).getUsers() : null;
    }

    public void checkStatus(FoxResponse resp) throws Exception {
        String rc = resp.getString("status");
        if (!rc.equals("ok")) {
            throw new UserSyncException(resp.getString("msg"));
        }
    }

    public void startSync(boolean outgoing) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("client.startSync: outgoing=" + outgoing);
        }
        FoxRequest req = this.makeRequest("startSync");
        if (outgoing && !this.clientSupportsPasswordHashing()) {
            throw new Exception(lex.getText("userSync.error.passwordHashMismatch"));
        }
        req.add("outgoing", outgoing);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse startSync(FoxRequest req) throws Exception {
        boolean outgoing = req.getBoolean("outgoing");
        if (log.isLoggable(Level.FINE)) {
            log.fine("server.startSync: outgoing=" + outgoing);
        }
        FoxResponse resp = new FoxResponse(req);
        BNiagaraUserDeviceExt ext = this.getUserDeviceExt();
        if (!outgoing && !this.serverSupportsPasswordHashing()) {
            resp.add("status", "error");
            resp.add("msg", lex.getText("userSync.error.passwordHashMismatch"));
        } else if (outgoing && !ext.getSyncInEnabled()) {
            resp.add("status", "error");
            resp.add("msg", lex.getText("userSync.error.syncOutDisabled"));
        } else if (!outgoing && !ext.getSyncOutEnabled()) {
            resp.add("status", "error");
            resp.add("msg", lex.getText("userSync.error.syncInDisabled"));
        } else if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", lex.getText("userSync.error.disabled"));
        } else {
            resp.add("status", "ok");
        }
        return resp;
    }

    public void endSync() throws Exception {
        FoxRequest req = this.makeRequest("endSync");
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse endSync(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BNiagaraUserDeviceExt ext = this.getUserDeviceExt();
        if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", lex.getText("userSync.error.disabled"));
        } else {
            ext.syncComplete();
            resp.add("status", "ok");
        }
        return resp;
    }

    public UserStatus[] getUserStatus(String[] protoNames) throws Exception {
        FoxRequest req = this.makeRequest("getUserStatus");
        for (int i = 0; i < protoNames.length; ++i) {
            req.add("p", protoNames[i]);
        }
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        FoxTuple[] result = resp.list("u");
        if (result == null) {
            return new UserStatus[0];
        }
        UserStatus[] users = new UserStatus[result.length];
        for (int i = 0; i < users.length; ++i) {
            FoxMessage msg = (FoxMessage)result[i];
            users[i] = new UserStatus(msg.getString("n"), msg.getString("p"), msg.getString("v"));
        }
        return users;
    }

    public FoxResponse getUserStatus(FoxRequest req) throws IOException {
        FoxTuple[] inProtos = req.list("p");
        String[] protoNames = new String[inProtos.length];
        for (int i = 0; i < inProtos.length; ++i) {
            protoNames[i] = ((FoxString)inProtos[i]).value;
        }
        BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
        UserStatus[] users = deviceExt.getUserStatus(protoNames);
        FoxResponse resp = new FoxResponse(req);
        resp.add("status", "ok");
        for (int i = 0; i < users.length; ++i) {
            FoxMessage user = new FoxMessage("u");
            user.add("n", users[i].getUserName());
            user.add("p", users[i].getPrototypeName());
            user.add("v", users[i].getVersion());
            resp.add((FoxTuple)user);
        }
        return resp;
    }

    public UserStatus[] getOutOfSync(UserStatus[] localUsers) throws Exception {
        FoxRequest req = this.makeRequest("getOutOfSync");
        for (int i = 0; i < localUsers.length; ++i) {
            FoxMessage user = new FoxMessage("u");
            user.add("n", localUsers[i].getUserName());
            user.add("p", localUsers[i].getPrototypeName());
            user.add("v", localUsers[i].getVersion());
            req.add((FoxTuple)user);
        }
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        FoxTuple[] result = resp.list("u");
        if (result == null) {
            return new UserStatus[0];
        }
        UserStatus[] outOfDate = new UserStatus[result.length];
        for (int i = 0; i < outOfDate.length; ++i) {
            FoxMessage msg = (FoxMessage)result[i];
            outOfDate[i] = new UserStatus(msg.getString("n"), msg.getString("p"), msg.getString("v"));
        }
        return outOfDate;
    }

    public FoxResponse getOutOfSync(FoxRequest req) throws IOException {
        try {
            FoxTuple[] remoteStatus = req.list("u");
            UserStatus[] remoteUsers = new UserStatus[remoteStatus.length];
            for (int i = 0; i < remoteStatus.length; ++i) {
                FoxMessage status = (FoxMessage)remoteStatus[i];
                String userName = status.getString("n");
                String prototypeName = status.getString("p");
                String version = status.getString("v");
                remoteUsers[i] = new UserStatus(userName, prototypeName, version);
            }
            BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
            UserStatus[] outOfSync = deviceExt.getOutOfSync(remoteUsers);
            FoxResponse resp = new FoxResponse(req);
            resp.add("status", "ok");
            for (int i = 0; i < outOfSync.length; ++i) {
                FoxMessage user = new FoxMessage("u");
                user.add("n", outOfSync[i].getUserName());
                user.add("p", outOfSync[i].getPrototypeName());
                user.add("v", outOfSync[i].getVersion());
                resp.add((FoxTuple)user);
            }
            return resp;
        }
        catch (UserSyncException ex) {
            log.log(Level.SEVERE, "Error", (Throwable)((Object)ex));
            FoxResponse resp = new FoxResponse(req);
            resp.add("status", "error");
            resp.add("msg", ex.getMessage());
            return resp;
        }
    }

    public void updateUsers(BUser[] users) throws Exception {
        int i;
        BComponent batch = new BComponent();
        for (i = 0; i < users.length; ++i) {
            batch.add(users[i].getName(), (BValue)this.prepareCopy(users[i]));
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < users.length; ++i) {
                log.fine("sending update for: " + users[i].getName());
            }
        }
        FoxRequest req = this.makeRequest("updateUsers");
        req.add("bog", this.getConnection().session().isLegacyConnection() ? AxPasswordUtil.marshalBog((BValue)batch) : ValueDocEncoder.marshal((BValue)batch));
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        if (!resp.getString("status").equals("ok")) {
            throw new UserSyncException(resp.getString("msg"));
        }
    }

    public FoxResponse updateUsers(FoxRequest req) throws Exception {
        log.fine("update users");
        BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
        String bog = req.getString("bog");
        if (log.isLoggable(Level.FINE)) {
            log.fine("users to update:\n" + bog);
        }
        BComponent batch = (BComponent)ValueDocDecoder.unmarshal((String)bog);
        Array users = new Array(BUser.class);
        FoxResponse resp = new FoxResponse(req);
        SlotCursor c = batch.getProperties();
        while (c.next(BUser.class)) {
            BUser syncUser = (BUser)c.get();
            try {
                syncUser.getAuthenticationScheme();
            }
            catch (Exception e) {
                resp.add("status", "error");
                resp.add("msg", lex.getText("userSync.error.authSchemeMismatch", new Object[]{syncUser.getName(), e.getMessage() != null ? e.getMessage() : e.toString()}));
                return resp;
            }
            users.add((Object)syncUser);
        }
        for (int i = 0; i < users.size(); ++i) {
            BUser syncUser = (BUser)users.get(i);
            String userName = syncUser.getName();
            batch.remove(userName);
            deviceExt.syncUser(userName, syncUser);
        }
        resp.add("status", "ok");
        return resp;
    }

    public void updateUsersFromServer(UserStatus[] outOfSync) throws Exception {
        BNiagaraUserDeviceExt deviceExt = this.getUserDeviceExt();
        FoxRequest req = this.makeRequest("updateUsersFromServer");
        for (int i = 0; i < outOfSync.length; ++i) {
            FoxMessage user = new FoxMessage("u");
            user.add("n", outOfSync[i].getUserName());
            user.add("p", outOfSync[i].getPrototypeName());
            user.add("v", outOfSync[i].getVersion());
            req.add((FoxTuple)user);
        }
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        String bog = resp.getString("bog");
        if (log.isLoggable(Level.FINE)) {
            log.fine("users to update:\n" + bog);
        }
        BComponent batch = (BComponent)ValueDocDecoder.unmarshal((String)bog);
        Array users = new Array(BUser.class);
        SlotCursor c = batch.getProperties();
        while (c.next(BUser.class)) {
            BUser syncUser = (BUser)c.get();
            try {
                syncUser.getAuthenticationScheme();
            }
            catch (Exception e) {
                throw new UserSyncException(lex.getText("userSync.error.authSchemeMismatch", new Object[]{syncUser.getName(), e.getMessage() != null ? e.getMessage() : e.toString()}));
            }
            users.add((Object)syncUser);
        }
        for (int i = 0; i < users.size(); ++i) {
            BUser syncUser = (BUser)users.get(i);
            String userName = syncUser.getName();
            batch.remove(userName);
            deviceExt.syncUser(userName, syncUser);
        }
    }

    public FoxResponse updateUsersFromServer(FoxRequest req) throws Exception {
        log.fine("update request");
        FoxTuple[] tuples = req.list("u");
        UserStatus[] users = new UserStatus[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            FoxMessage status = (FoxMessage)tuples[i];
            String userName = status.getString("n");
            String prototypeName = status.getString("p");
            String version = status.getString("v");
            users[i] = new UserStatus(userName, prototypeName, version);
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        FoxResponse resp = new FoxResponse(req);
        BComponent batch = new BComponent();
        for (int i = 0; i < users.length; ++i) {
            BUser user = (BUser)userService.get(users[i].getUserName());
            if (user == null) continue;
            try {
                batch.add(user.getName(), (BValue)this.prepareCopy(user));
                continue;
            }
            catch (UserSyncException e) {
                resp.add("status", "error");
                resp.add("msg", e.getMessage());
            }
        }
        resp.add("status", "ok");
        resp.add("bog", ValueDocEncoder.marshal((BValue)batch));
        return resp;
    }

    private BUser prepareCopy(BUser user) throws Exception {
        if (user.getAuthenticationScheme().supportsRemoteUsers()) {
            throw new UserSyncException(lex.getText("userSync.error.incompatibleRemoteUser", new Object[]{user.getName()}));
        }
        BUser userCopy = (BUser)user.newCopy();
        if (this.getConnection().session().isLegacyConnection()) {
            BAbstractAuthenticator auth = userCopy.getAuthenticator();
            if (auth.getType().is(BPasswordAuthenticator.TYPE)) {
                userCopy.add("password", ((BPasswordAuthenticator)auth).getPassword().newCopy(), 256);
            } else {
                throw new UserSyncException(lex.getText("userSync.error.incompatibleAxPassword", new Object[]{user.getName()}));
            }
        }
        return userCopy;
    }
}

