/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.util.ObjectUtil;
import java.io.IOException;
import java.util.List;
import java.util.StringJoiner;
import java.util.TreeMap;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class SpyReachableStations
extends SpyDir {
    public static final String SPY_NAME = "reachableStations";
    private static final BFacets SHOW_MILLIS_FACET = BFacets.make((String)"showMilliseconds", (boolean)true);
    private final BNiagaraNetwork network;

    public SpyReachableStations(BNiagaraNetwork network) {
        this.network = network;
        this.add("noForceUpdateIncludeUnoperationalIncludeVirtualDisabled", new SpyReachable(network, false, true, true));
        this.add("noForceUpdateIncludeUnoperationalExcludeVirtualDisabled", new SpyReachable(network, false, true, false));
        this.add("noForceUpdateExcludeUnoperationalIncludeVirtualDisabled", new SpyReachable(network, false, false, true));
        this.add("noForceUpdateExcludeUnoperationalExcludeVirtualDisabled", new SpyReachable(network, false, false, false));
        this.add("forceUpdateIncludeUnoperationalIncludeVirtualDisabled", new SpyReachable(network, true, true, true));
        this.add("forceUpdateIncludeUnoperationalExcludeVirtualDisabled", new SpyReachable(network, true, true, false));
        this.add("forceUpdateExcludeUnoperationalIncludeVirtualDisabled", new SpyReachable(network, true, false, true));
        this.add("forceUpdateExcludeUnoperationalExcludeVirtualDisabled", new SpyReachable(network, true, false, false));
        this.add("removeAllPersistedReachableStations", new SpyRemoveAllReachableStations(network));
    }

    public Spy find(String name) {
        String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
        if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
            return super.find(namePart);
        }
        return null;
    }

    public void write(SpyWriter out) throws Exception {
        out.w((Object)"<p>WARNING: Selecting any of the 'Force Update' links below can cause").w((Object)" new reachable station routing information to be added and persisted in").w((Object)" the station. It may also take some time to complete since it will crawl").w((Object)" downstream NiagaraNetwork station connections looking for routes to").w((Object)" reachable stations. Also, the 'Remove All Persisted Reachable Stations'").w((Object)" link will clear any persisted reachable station routing information from").w((Object)" the station, so use it with caution (you may want to perform a ").w((Object)" 'Force Update' as a followup to that operation to repopulate with ").w((Object)" current routing information).<hr>");
        out.w((Object)"<ul>");
        for (String name : this.list()) {
            Spy spy = super.find(name);
            out.w((Object)"<li>").mutatorButton(name, spy.getTitle()).w((Object)"</li>");
        }
        out.w((Object)"</ul>");
    }

    private static class SpyRemoveAllReachableStations
    extends Spy {
        private final BNiagaraNetwork network;

        public SpyRemoveAllReachableStations(BNiagaraNetwork network) {
            this.network = network;
        }

        public String getTitle() {
            return "Remove All Persisted Reachable Stations";
        }

        public void write(SpyWriter out) throws IOException {
            BReachableStations.removeAllPersistedReachableStations((BObject)this.network, null);
            out.startProps("Removed All Persisted Reachable Stations");
            out.propValueLink((Object)"", (Object)"..", (Object)"Return");
            out.endProps();
        }
    }

    private static class SpyReachable
    extends Spy {
        private final BNiagaraNetwork network;
        private final boolean forceUpdate;
        private final boolean includeUnoperational;
        private final boolean includeVirtualDisabled;

        public SpyReachable(BNiagaraNetwork network, boolean forceUpdate, boolean includeUnoperational, boolean includeVirtualDisabled) {
            this.network = network;
            this.forceUpdate = forceUpdate;
            this.includeUnoperational = includeUnoperational;
            this.includeVirtualDisabled = includeVirtualDisabled;
        }

        public String getTitle() {
            StringJoiner result = new StringJoiner(", ", "Get Reachable Stations, ", "");
            if (this.forceUpdate) {
                result.add("Force Update Routes");
            } else {
                result.add("No Force Update Routes");
            }
            if (this.includeUnoperational) {
                result.add("Include Unoperational Routes");
            } else {
                result.add("Exclude Unoperational Routes");
            }
            if (this.includeVirtualDisabled) {
                result.add("Include Virtual Disabled Routes");
            } else {
                result.add("Exclude Virtual Disabled Routes");
            }
            return result.toString();
        }

        public void write(SpyWriter out) throws IOException {
            TreeMap<String, List<BReachableStationInfo>> reachableStationInfos = new TreeMap<String, List<BReachableStationInfo>>(BReachableStations.findAllReachableStations((BObject)this.network, this.forceUpdate, this.includeUnoperational, this.includeVirtualDisabled, null, new String[0]));
            out.startTable(true);
            out.tr();
            out.thTitle((Object)"Reachable Station");
            out.thTitle((Object)"Version");
            out.thTitle((Object)"Route To Reachable Station");
            out.thTitle((Object)"Route Preference (0 = primary)");
            out.thTitle((Object)"Route Enabled");
            out.thTitle((Object)"Min Version Along Route");
            out.thTitle((Object)"Time To Reach");
            out.thTitle((Object)"Container Status");
            out.thTitle((Object)"Virtual Space ORD (null means virtuals not enabled along route)");
            out.endTr();
            for (List infos : reachableStationInfos.values()) {
                for (int i = 0; i < infos.size(); ++i) {
                    BReachableStationInfo info = (BReachableStationInfo)((Object)infos.get(i));
                    out.tr();
                    out.td().a(String.valueOf(ObjectUtil.toSpyRelative((BObject)info)), (Object)info.getStationName()).endTd();
                    out.td((Object)info.getStationVersion());
                    out.td((Object)info.getRouteToStation().replace(";", " -> "));
                    out.td((Object)i);
                    out.td().a(info.getNavOrd().relativizeToSession().toString(), (Object)info.getRouteEnabled()).endTd();
                    out.td((Object)info.getMinVersionAlongRoute());
                    out.td((Object)info.getTimeToReach().toString((Context)SHOW_MILLIS_FACET));
                    out.td().a(info.getParent().asComponent().getNavOrd().relativizeToSession().toString(), (Object)info.getParent().get("status")).endTd();
                    if (info.getVirtualSpaceOrd().isNull()) {
                        out.td((Object)info.getVirtualSpaceOrd());
                    } else {
                        out.td().a(String.valueOf(info.getVirtualSpaceOrd()), (Object)info.getVirtualSpaceOrd()).endTd();
                    }
                    out.endTr();
                }
            }
            out.endTable();
        }
    }
}

