/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.schedule;

import com.tridium.collection.BEmptyTable;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.nd.schedule.BNiagaraScheduleLearnResult;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceExt;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNiagaraScheduleLearnJob
extends BJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraScheduleLearnJob.class);
    private boolean canceled = false;
    private BNiagaraScheduleDeviceExt schedules;
    private BNiagaraStation station = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraScheduleLearnJob() {
    }

    public BNiagaraScheduleLearnJob(BNiagaraScheduleDeviceExt schedules) {
        this.schedules = schedules;
    }

    public BNiagaraScheduleLearnJob(BNiagaraStation station) {
        this.station = station;
    }

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    public void doRun(Context cx) {
        this.canceled = false;
        this.progress(25);
        try {
            BITable table = null;
            if (this.station != null) {
                BFoxSession session = (BFoxSession)this.station.getSession();
                BOrd ord = BOrd.make((String)"station:|slot:/|bql: select name,slotPathOrd,type from schedule:AbstractSchedule stop");
                BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
                table = (BITable)channel.discover((BDeviceExt)this.station.getSchedules(), ord);
            } else {
                table = this.schedules.discover();
            }
            if (this.canceled) {
                this.canceled();
                return;
            }
            this.progress(75);
            if (!(table instanceof BEmptyTable)) {
                ColumnList l = table.getColumns();
                Column name = l.get(0);
                Column id = l.get(1);
                Column typ = l.get(2);
                try (TableCursor c = table.cursor();){
                    while (c.next()) {
                        BNiagaraScheduleLearnResult lr = new BNiagaraScheduleLearnResult();
                        lr.setSupervisorId(c.cell(id).toString());
                        lr.setTypeStr(c.cell(typ).toString());
                        this.add(c.cell(name) + "?", (BValue)lr);
                    }
                }
            }
            this.progress(100);
            this.success();
        }
        catch (Exception x) {
            this.failed(x);
        }
    }
}

