/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.file;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileDescriptor;
import com.tridium.nd.file.BNiagaraFileTypeImportHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import javax.baja.driver.util.BDescriptor;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.history.BHistoryId;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"webChart:ChartFile"})})
@NiagaraSingleton
public final class BChartFileImportHandler
extends BNiagaraFileTypeImportHandler {
    @Generated
    public static final BChartFileImportHandler INSTANCE = new BChartFileImportHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BChartFileImportHandler.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isAcceptableOverwritePolicy(BFileOverwritePolicy policy) {
        return BFileOverwritePolicy.lastModified.equals((Object)policy);
    }

    @Override
    public void pipeFileData(BDescriptor importDescriptor, BIFile remoteSrcFile, BIFile localDestFile) throws IOException {
        boolean rewriteJSON;
        block30: {
            rewriteJSON = false;
            String remoteStationName = importDescriptor.getDevice().getName();
            try (InputStreamReader reader = new InputStreamReader(remoteSrcFile.getInputStream());){
                JSONObject root = new JSONObject(new JSONTokener((Reader)reader));
                JSONObject model = root.getJSONObject("model");
                JSONArray seriesArray = model.getJSONArray("series");
                for (int i = 0; i < seriesArray.length(); ++i) {
                    JSONObject series = seriesArray.getJSONObject(i);
                    BOrd ord = BOrd.make((String)JSONUtil.getString((JSONObject)series, (String)"ord"));
                    OrdQuery[] queries = ord.parse();
                    boolean replaceOrd = false;
                    for (int j = 0; j < queries.length; ++j) {
                        BHistoryId historyId;
                        if (!(queries[j] instanceof HistoryQuery) || (historyId = ((HistoryQuery)queries[j]).getHistoryId()) == null || !historyId.isShorthand()) continue;
                        BHistoryId absHistoryId = historyId.fromShorthand(remoteStationName);
                        String newHistoryQuery = queries[j].getBody().replace(historyId.encodeToString(), absHistoryId.encodeToString());
                        queries[j] = new HistoryQuery(queries[j].getScheme(), newHistoryQuery);
                        replaceOrd = true;
                    }
                    if (!replaceOrd) continue;
                    series.put("ord", (Object)BOrd.make((OrdQuery[])queries).encodeToString());
                    rewriteJSON = true;
                }
                if (!rewriteJSON) break block30;
                try (OutputStreamWriter writer = new OutputStreamWriter(localDestFile.getOutputStream());){
                    root.write((Writer)writer);
                }
            }
            catch (Exception e) {
                if (BNiagaraFileDescriptor.LOG.isLoggable(Level.WARNING)) {
                    BNiagaraFileDescriptor.LOG.log(Level.WARNING, "Failed in special handling while importing remote chart file " + remoteSrcFile.getFilePath() + " from station '" + remoteStationName + "' to local file " + localDestFile.getFilePath() + ". Reverting to default file import with no special handling for shorthand history ORDS", e);
                }
                rewriteJSON = false;
            }
        }
        if (!rewriteJSON) {
            BajaFileUtil.pipe((BIFile)remoteSrcFile, (BIFile)localDestFile);
        }
    }
}

