/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.discover;

import com.tridium.driver.util.DriverUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.discover.BNiagaraPointLearnBase;
import com.tridium.nd.discover.HistoryDeviceLearnNodeInfo;
import com.tridium.nd.discover.PointLearnNodeInfo;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nv.BSlotInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.function.SupplierCanThrowException;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;

public final class NiagaraLearnUtil {
    private static final BSlotInfo[] EMPTY_SLOT_INFO_ARRAY = new BSlotInfo[0];
    private static final BOrd FIND_NETWORKS_AND_DEVICES = BOrd.make((String)"station:|slot:/|bql:select name, navDisplayName, navOrd, icon.encodeToString from driver:DeviceNetwork, driver:DeviceFolder, driver:Device");
    private static final BIcon STATION_ICON = new BStation().getNavIcon();
    private static final BOrd STATION_ROOT_ORD = BOrd.make((String)"station:|slot:/");
    private static final LexiconModule BAJA_LEX = LexiconModule.make((String)"baja");
    private static final Version VER_3_7 = new Version("3.7");
    private static final Version VER_4_4 = new Version("4.4");
    private static final Version VER_4_9U1 = new Version("4.9.1.29");
    private static final Logger LOG = Logger.getLogger("niagaraDriver");
    private static final BqlDiscoverer DISCOVER_WORKBENCH_TO_SUPERVISOR = NiagaraLearnUtil::bqlDiscoverViaProxyExt;
    private static final BqlDiscoverer DISCOVER_SUPERVISOR_TO_SUBORDINATE = NiagaraLearnUtil::bqlDiscoverViaLocalExt;

    private NiagaraLearnUtil() {
    }

    public static BINavNode discoverPointRootsViaProxyExt(BDeviceExt proxyExt, Context cx) throws Exception {
        return NiagaraLearnUtil.discoverPointRoots(proxyExt, DISCOVER_WORKBENCH_TO_SUPERVISOR, cx);
    }

    public static BINavNode discoverPointRootsViaLocalExt(BDeviceExt localExt, Context cx) throws Exception {
        return NiagaraLearnUtil.discoverPointRoots(localExt, DISCOVER_SUPERVISOR_TO_SUBORDINATE, cx);
    }

    public static HistoryDeviceLearnNodeInfo[] discoverHistoriesViaProxyExt(BDeviceExt deviceExt, Context cx) throws Exception {
        BFoxSession session = (BFoxSession)deviceExt.getSession();
        String supervisorStationName = session.getStationName();
        return NiagaraLearnUtil.discoverHistories(deviceExt, supervisorStationName, DISCOVER_WORKBENCH_TO_SUPERVISOR, cx);
    }

    public static HistoryDeviceLearnNodeInfo[] discoverHistoriesViaLocalExt(BDeviceExt deviceExt, Context cx) throws Exception {
        String supervisorStationName = Sys.getStation().getStationName();
        return NiagaraLearnUtil.discoverHistories(deviceExt, supervisorStationName, DISCOVER_SUPERVISOR_TO_SUBORDINATE, cx);
    }

    private static HistoryDeviceLearnNodeInfo[] discoverHistories(BDeviceExt deviceExt, String supervisorStationName, BqlDiscoverer discoverer, Context cx) throws Exception {
        BOrd ord = BOrd.make((String)"history:|bql:select id.encodeToString, systemTags.encodeToString from sys.histories order by id.encodeToString asc");
        BITable remoteHistories = (BITable)discoverer.bqlDiscover(deviceExt, ord);
        HashMap<String, HistoryDeviceLearnNodeInfo> deviceMap = new HashMap<String, HistoryDeviceLearnNodeInfo>();
        ColumnList cols = remoteHistories.getColumns();
        try (TableCursor c = remoteHistories.cursor();){
            while (c.next()) {
                try {
                    BHistoryId id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(c.cell(cols.get(0)).toString());
                    BNameList systemTags = (BNameList)BNameList.DEFAULT.decodeFromString(c.cell(cols.get(1)).toString());
                    String deviceName = id.getDeviceName();
                    if (deviceName.equals(supervisorStationName)) continue;
                    HistoryDeviceLearnNodeInfo dev = deviceMap.computeIfAbsent(deviceName, HistoryDeviceLearnNodeInfo::new);
                    dev.addDiscoveredHistory(id, systemTags);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Encountered error while processing discovered history " + c.get(), e);
                }
            }
        }
        Object[] devs = deviceMap.values().toArray(new HistoryDeviceLearnNodeInfo[0]);
        Arrays.sort(devs);
        return devs;
    }

    public static Map<BOrd, PointLearnNodeInfo> loadNodesPartiallyViaProxyStation(BNiagaraStation station, BOrd[] ords, Context cx) throws Exception {
        BFoxClientConnection connection = NiagaraLearnUtil.getWorkbenchToStationConnection((BComponent)station);
        BSlotInfo[] slotInfos = (BSlotInfo[])NiagaraLearnUtil.withFoxEngaged(connection, "PointChannel - loadNodesPartially at " + Clock.ticks(), () -> NiagaraLearnUtil.getPointChannel(connection).discoverPartialSlots(station.getStationName(), ords));
        return NiagaraLearnUtil.loadNodesPartially(slotInfos);
    }

    public static Map<BOrd, PointLearnNodeInfo> loadNodesPartiallyViaLocalStation(BNiagaraStation station, BOrd[] ords, Context cx) throws Exception {
        BFoxClientConnection connection = NiagaraLearnUtil.getSupervisorToSubordinateConnection(station);
        BSlotInfo[] slotInfos = (BSlotInfo[])NiagaraLearnUtil.withFoxEngaged(connection, "PointChannel - loadNodesPartially at " + Clock.ticks(), () -> {
            BOrd[] virtualOrds = BPointChannel.decodeServerOrdsToClientVirtualOrds(ords);
            return BPointChannel.discoverPartialSlotsViaVirtualChannel(virtualOrds, connection);
        });
        return NiagaraLearnUtil.loadNodesPartially(slotInfos);
    }

    public static Map<BOrd, PointLearnNodeInfo> loadNodesViaLocalStation(BNiagaraStation station, BOrd ord, Context cx) throws Exception {
        BFoxClientConnection connection = NiagaraLearnUtil.getSupervisorToSubordinateConnection(station);
        BSlotInfo[] slotInfos = (BSlotInfo[])NiagaraLearnUtil.withFoxEngaged(connection, "PointChannel - loadNodes at " + Clock.ticks(), () -> {
            BOrd[] virtualOrds = BPointChannel.decodeServerOrdsToClientVirtualOrds(new BOrd[]{ord});
            return BPointChannel.discoverPointsViaVirtualChannel(virtualOrds[0], connection);
        });
        return NiagaraLearnUtil.loadNodesPartially(slotInfos);
    }

    public static boolean supportsPartialNodeLoading(BNiagaraStation station) {
        if (NiagaraLearnUtil.getLocalStationVersion(station).compareTo(VER_3_7) < 0) {
            return false;
        }
        return !NiagaraLearnUtil.isProxyStation(station) || NiagaraLearnUtil.getProxyStationVersion(station).compareTo(VER_4_9U1) >= 0;
    }

    public static boolean partiallyLoadedNodesWillIncludeOutSlot(BNiagaraStation station) {
        return NiagaraLearnUtil.getLocalStationVersion(station).compareTo(VER_4_4) >= 0;
    }

    public static Object[] getExportHistoryDiscovery(BComponent target) {
        Object[] discoveredHistory = DriverUtil.getHistoryDiscovery((BComponent)target);
        BNiagaraStation station = NiagaraLearnUtil.getNiagaraStation(target);
        String targetStationName = station.getName();
        boolean needFilter = false;
        for (Object historyEntry : discoveredHistory) {
            BIHistory history;
            if (historyEntry instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)historyEntry;
                if (!dev.getDeviceName().equals(targetStationName)) continue;
                needFilter = true;
                break;
            }
            if (!(historyEntry instanceof BIHistory) || !(history = (BIHistory)historyEntry).getId().getDeviceName().equals(targetStationName)) continue;
            needFilter = true;
            break;
        }
        if (!needFilter) {
            return discoveredHistory;
        }
        ArrayList<Object> result = new ArrayList<Object>(discoveredHistory.length);
        for (Object historyEntry : discoveredHistory) {
            BIHistory history;
            if (historyEntry instanceof BHistoryDevice) {
                BHistoryDevice dev = (BHistoryDevice)historyEntry;
                if (dev.getDeviceName().equals(targetStationName)) continue;
                result.add(dev);
                continue;
            }
            if (!(historyEntry instanceof BIHistory) || (history = (BIHistory)historyEntry).getId().getDeviceName().equals(targetStationName)) continue;
            result.add(history);
        }
        return result.toArray();
    }

    public static BNiagaraStation getNiagaraStation(BComponent target) {
        for (BComponent parent = target; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNiagaraStation)) continue;
            return (BNiagaraStation)parent;
        }
        return null;
    }

    private static BINavNode discoverPointRoots(BDeviceExt remotePoints, BqlDiscoverer discoverer, Context cx) throws Exception {
        BITable networksAndDevices = (BITable)discoverer.bqlDiscover(remotePoints, FIND_NETWORKS_AND_DEVICES);
        ColumnList cols = networksAndDevices.getColumns();
        BNiagaraPointLearnBase root = NiagaraLearnUtil.makeStationRootNode(cx);
        BNiagaraPointLearnBase base = NiagaraLearnUtil.makeStationRootNode(cx);
        root.addNavChild((BINavNode)base);
        try (TableCursor c = networksAndDevices.cursor();){
            Array ancestorBases = new Array(BNiagaraPointLearnBase.class);
            ancestorBases.push((Object)base);
            while (c.next()) {
                String name = c.cell(cols.get(0)).toString();
                String navName = c.cell(cols.get(1)).toString();
                String navOrdString = c.cell(cols.get(2)).toString();
                BOrd navOrd = BOrd.make((String)navOrdString).relativizeToSession();
                navOrdString = navOrd.toString();
                BIcon navIcon = BIcon.make((String)c.cell(cols.get(3)).toString());
                BNiagaraPointLearnBase currentBase = new BNiagaraPointLearnBase(name, navName, navOrd, navIcon);
                BNiagaraPointLearnBase ancestorBase = (BNiagaraPointLearnBase)((Object)ancestorBases.peek());
                String ancestorOrdStr = NiagaraLearnUtil.ordStr((BINavNode)ancestorBase);
                while (ancestorBase != null && !navOrdString.startsWith(ancestorOrdStr)) {
                    try {
                        ancestorBases.pop();
                        ancestorBase = (BNiagaraPointLearnBase)((Object)ancestorBases.peek());
                        ancestorOrdStr = NiagaraLearnUtil.ordStr((BINavNode)ancestorBase);
                    }
                    catch (Exception e) {
                        ancestorBase = null;
                    }
                }
                if (ancestorBase == null) {
                    ancestorBase = base;
                    if (ancestorBases.isEmpty()) {
                        ancestorBases.push((Object)base);
                    }
                }
                if (ancestorBase.getNavChild(currentBase.getNavName()) != null) {
                    currentBase = new BNiagaraPointLearnBase(name + " (" + navOrdString + ')', navName, navOrd, navIcon);
                }
                ancestorBase.addNavChild((BINavNode)currentBase);
                ancestorBases.push((Object)currentBase);
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withFoxEngaged(BFoxClientConnection connection, String interestName, SupplierCanThrowException<T, ? extends Exception> s) throws Exception {
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest(interestName);
        try {
            connection.engageNoRetry((BFoxClientConnection.Interest)interest);
            Object object = s.get();
            return (T)object;
        }
        finally {
            connection.disengage((BFoxClientConnection.Interest)interest);
        }
    }

    private static boolean isProxyStation(BNiagaraStation station) {
        return station.getSession() instanceof BFoxSession;
    }

    private static Version getLocalStationVersion(BNiagaraStation station) {
        String subordinateStationVersionStr = station.getVersion();
        try {
            return subordinateStationVersionStr.isEmpty() ? Version.ZERO : new Version(subordinateStationVersionStr);
        }
        catch (Exception e) {
            return Version.ZERO;
        }
    }

    private static Version getProxyStationVersion(BNiagaraStation station) {
        BFoxSession session = (BFoxSession)station.getSession();
        try {
            return new Version(session.getConnection().session().getRemoteHello().getString("app.version", ""));
        }
        catch (Exception e) {
            return Version.ZERO;
        }
    }

    private static Map<BOrd, PointLearnNodeInfo> loadNodesPartially(BSlotInfo[] infos) throws Exception {
        LinkedHashMap<BOrd, PointLearnNodeInfo> ordsToNodes = new LinkedHashMap<BOrd, PointLearnNodeInfo>();
        for (int i = 0; i < infos.length; ++i) {
            BOrd ord = infos[i].getSlotOrd();
            PointLearnNodeInfo node = new PointLearnNodeInfo();
            node.mySlotInfo = infos[i];
            int nextIdx = i + 1;
            node.childSlotInfos = nextIdx < infos.length && infos[nextIdx].getSlotOrd().equals((Object)BOrd.make((String)(ord.encodeToString() + "/out"))) ? new BSlotInfo[]{infos[nextIdx]} : EMPTY_SLOT_INFO_ARRAY;
            node.partiallyLoaded = true;
            node.fullyLoaded = false;
            node.name = node.mySlotInfo.getSlotName();
            node.path = NiagaraLearnUtil.toSlotPathString(node.mySlotInfo.getSlotOrd().relativizeToSession().toString());
            NiagaraLearnUtil.computeFacets(node.mySlotInfo, node.childSlotInfos);
            node.facets = node.mySlotInfo.getFacets();
            node.displayName = node.mySlotInfo.getSlotDisplayName();
            try {
                BIcon infoIcon = node.mySlotInfo.getSlotIcon();
                if (!BIcon.DEFAULT.equals((Object)infoIcon)) {
                    node.icon = BImage.make((BIcon)infoIcon);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ordsToNodes.put(ord, node);
        }
        return ordsToNodes;
    }

    private static String ordStr(BINavNode navNode) {
        String ancestorOrdStr = navNode.getNavOrd().toString();
        if (!ancestorOrdStr.endsWith("/")) {
            ancestorOrdStr = ancestorOrdStr + "/";
        }
        return ancestorOrdStr;
    }

    public static BNiagaraStation getNiagaraStation(BDeviceExt deviceExt) {
        BDevice device = deviceExt.getDevice();
        if (!(device instanceof BNiagaraStation)) {
            throw new IllegalStateException("device extension not rooted under a Niagara station");
        }
        return (BNiagaraStation)device;
    }

    private static BFoxClientConnection getWorkbenchToStationConnection(BComponent component) {
        BISession session = component.getSession();
        if (!(session instanceof BFoxSession)) {
            throw new IllegalStateException("component not mounted in FOX proxy component space");
        }
        BFoxSession foxSession = (BFoxSession)session;
        return foxSession.getConnection();
    }

    private static BFoxClientConnection getSupervisorToSubordinateConnection(BNiagaraStation station) {
        return station.getClientConnection();
    }

    public static BPointChannel getPointChannel(BFoxClientConnection connection) {
        return (BPointChannel)connection.getChannels().get("point", BPointChannel.TYPE);
    }

    public static BDataChannel getDataChannel(BFoxClientConnection connection) {
        return (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
    }

    public static BNiagaraVirtualChannel getVirtualChannel(BFoxClientConnection connection) {
        return (BNiagaraVirtualChannel)connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE);
    }

    public static BObject bqlDiscoverViaLocalExt(BDeviceExt localExt, BOrd bqlQuery) throws Exception {
        BNiagaraStation station = NiagaraLearnUtil.getNiagaraStation(localExt);
        BFoxClientConnection connection = NiagaraLearnUtil.getSupervisorToSubordinateConnection(station);
        return (BObject)NiagaraLearnUtil.withFoxEngaged(connection, "PointChannel - Discover at " + Clock.ticks(), () -> BPointChannel.discoverViaDataChannel(localExt, bqlQuery, connection));
    }

    public static BObject bqlDiscoverViaProxyExt(BDeviceExt proxyExt, BOrd bqlQuery) throws Exception {
        BFoxClientConnection connection = NiagaraLearnUtil.getWorkbenchToStationConnection((BComponent)proxyExt);
        BPointChannel pointChannel = NiagaraLearnUtil.getPointChannel(connection);
        return pointChannel.discover(proxyExt, bqlQuery);
    }

    public static String toSlotPathString(String ordString) {
        if (ordString.startsWith("station:|")) {
            return ordString.substring(9);
        }
        if (!ordString.startsWith("slot:")) {
            return "slot:" + ordString;
        }
        return ordString;
    }

    public static void computeFacets(BSlotInfo parentInfo, BSlotInfo ... childInfos) {
        try {
            if (BTypeSpec.make((String)parentInfo.getTypeSpec()).getTypeInfo().is(BControlPoint.TYPE)) {
                for (BSlotInfo childInfo : childInfos) {
                    if (!"out".equals(childInfo.getSlotName())) continue;
                    parentInfo.setFacets(childInfo.getFacets());
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BNiagaraPointLearnBase makeStationRootNode(Context cx) {
        String baseDisplayName = BAJA_LEX.get("nav.station", cx);
        return new BNiagaraPointLearnBase("config", baseDisplayName, STATION_ROOT_ORD, STATION_ICON);
    }

    @FunctionalInterface
    private static interface BqlDiscoverer {
        public BObject bqlDiscover(BDeviceExt var1, BOrd var2) throws Exception;
    }
}

